/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.job;

import buildinfo.BuildInfo$;
import com.ebiznext.comet.config.DatasetArea$;
import com.ebiznext.comet.config.Settings;
import com.ebiznext.comet.config.Settings$;
import com.ebiznext.comet.extractor.ScriptGen;
import com.ebiznext.comet.job.atlas.AtlasConfig;
import com.ebiznext.comet.job.atlas.AtlasConfig$;
import com.ebiznext.comet.job.convert.Parquet2CSV;
import com.ebiznext.comet.job.convert.Parquet2CSVConfig;
import com.ebiznext.comet.job.convert.Parquet2CSVConfig$;
import com.ebiznext.comet.job.index.bqload.BigQueryLoadConfig;
import com.ebiznext.comet.job.index.bqload.BigQueryLoadConfig$;
import com.ebiznext.comet.job.index.connectionload.ConnectionLoadConfig;
import com.ebiznext.comet.job.index.connectionload.ConnectionLoadConfig$;
import com.ebiznext.comet.job.index.esload.ESLoadConfig;
import com.ebiznext.comet.job.index.esload.ESLoadConfig$;
import com.ebiznext.comet.job.index.kafkaload.KafkaJob;
import com.ebiznext.comet.job.index.kafkaload.KafkaJobConfig;
import com.ebiznext.comet.job.index.kafkaload.KafkaJobConfig$;
import com.ebiznext.comet.job.infer.InferSchemaConfig;
import com.ebiznext.comet.job.infer.InferSchemaConfig$;
import com.ebiznext.comet.job.ingest.LoadConfig;
import com.ebiznext.comet.job.ingest.LoadConfig$;
import com.ebiznext.comet.job.metrics.MetricsConfig;
import com.ebiznext.comet.job.metrics.MetricsConfig$;
import com.ebiznext.comet.schema.generator.Xls2Yml$;
import com.ebiznext.comet.schema.generator.Xls2YmlConfig$;
import com.ebiznext.comet.schema.generator.Yml2GraphViz;
import com.ebiznext.comet.schema.generator.Yml2GraphVizConfig$;
import com.ebiznext.comet.schema.generator.Yml2XlsConfig$;
import com.ebiznext.comet.schema.generator.Yml2XlsWriter;
import com.ebiznext.comet.schema.handlers.SchemaHandler;
import com.ebiznext.comet.utils.CometObjectMapper;
import com.ebiznext.comet.utils.CometObjectMapper$;
import com.ebiznext.comet.workflow.ImportConfig$;
import com.ebiznext.comet.workflow.IngestionWorkflow;
import com.ebiznext.comet.workflow.TransformConfig;
import com.ebiznext.comet.workflow.TransformConfig$;
import com.ebiznext.comet.workflow.WatchConfig;
import com.ebiznext.comet.workflow.WatchConfig$;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;

public final class Main$
implements StrictLogging {
    public static Main$ MODULE$;
    private final ObjectMapper mapper;
    private final Logger logger;

    static {
        new Main$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    private void printUsage() {
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(164).append("\n        |Usage : One of\n        |").append(LoadConfig$.MODULE$.usage()).append("\n        |").append(ImportConfig$.MODULE$.usage()).append("\n        |").append(TransformConfig$.MODULE$.usage()).append("\n        |").append(WatchConfig$.MODULE$.usage()).append("\n        |").append(ESLoadConfig$.MODULE$.usage()).append("\n        |").append(BigQueryLoadConfig$.MODULE$.usage()).append("\n        |").append(InferSchemaConfig$.MODULE$.usage()).append("\n        |").append(MetricsConfig$.MODULE$.usage()).append("\n        |").append(Parquet2CSVConfig$.MODULE$.usage()).append("\n        |").append(Xls2YmlConfig$.MODULE$.usage()).append("\n        |").append(Yml2XlsConfig$.MODULE$.usage()).append("\n        |").append(KafkaJobConfig$.MODULE$.usage()).append("\n        |").append(Yml2GraphVizConfig$.MODULE$.usage()).append("\n        |").toString())).stripMargin());
    }

    public void main(String[] args) {
        boolean bl;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Settings settings = Settings$.MODULE$.apply(ConfigFactory.load());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Comet Version {}", new Object[]{BuildInfo$.MODULE$.version()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        DatasetArea$.MODULE$.initMetadata(settings.metadataStorageHandler(), settings);
        SchemaHandler schemaHandler = new SchemaHandler(settings.metadataStorageHandler(), settings);
        schemaHandler.checkValidity();
        DatasetArea$.MODULE$.initDomains(settings.storageHandler(), (Iterable<String>)((Iterable)schemaHandler.domains().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom())), settings);
        IngestionWorkflow workflow = new IngestionWorkflow(settings.storageHandler(), schemaHandler, settings.launcherService(), settings);
        if (args.length == 0) {
            this.printUsage();
        }
        List arglist = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toList();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Running Comet {}", new Object[]{arglist});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String string = (String)arglist.head();
        boolean bl2 = "job".equals(string) ? true : "transform".equals(string);
        if (bl2) {
            boolean bl3;
            Option<TransformConfig> option = TransformConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
            if (option instanceof Some) {
                Some some = (Some)option;
                TransformConfig config = (TransformConfig)some.value();
                bl3 = workflow.autoJob(config);
            } else {
                Predef$.MODULE$.println((Object)TransformConfig$.MODULE$.usage());
                bl3 = false;
            }
            bl = bl3;
        } else if ("import".equals(string)) {
            workflow.loadLanding();
            bl = true;
        } else if ("watch".equals(string)) {
            boolean bl4;
            Option<WatchConfig> option = WatchConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
            if (option instanceof Some) {
                Some some = (Some)option;
                WatchConfig config = (WatchConfig)some.value();
                bl4 = workflow.loadPending(config);
            } else {
                Predef$.MODULE$.println((Object)WatchConfig$.MODULE$.usage());
                bl4 = false;
            }
            bl = bl4;
        } else {
            boolean bl5 = "ingest".equals(string) ? true : "load".equals(string);
            if (bl5) {
                boolean bl6;
                Option<LoadConfig> option = LoadConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LoadConfig config = (LoadConfig)some.value();
                    bl6 = workflow.load(config);
                } else {
                    Predef$.MODULE$.println((Object)LoadConfig$.MODULE$.usage());
                    bl6 = false;
                }
                bl = bl6;
            } else {
                boolean bl7 = "index".equals(string) ? true : "esload".equals(string);
                if (bl7) {
                    boolean bl8;
                    Option<ESLoadConfig> option = ESLoadConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        ESLoadConfig config = (ESLoadConfig)some.value();
                        bl8 = workflow.esLoad(config).isSuccess();
                    } else {
                        Predef$.MODULE$.println((Object)ESLoadConfig$.MODULE$.usage());
                        bl8 = false;
                    }
                    bl = bl8;
                } else if ("atlas".equals(string)) {
                    boolean bl9;
                    Option<AtlasConfig> option = AtlasConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        AtlasConfig config = (AtlasConfig)some.value();
                        bl9 = workflow.atlas(config);
                    } else {
                        Predef$.MODULE$.println((Object)AtlasConfig$.MODULE$.usage());
                        bl9 = false;
                    }
                    bl = bl9;
                } else if ("kafkaload".equals(string)) {
                    boolean bl10;
                    Option<KafkaJobConfig> option = KafkaJobConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        KafkaJobConfig config = (KafkaJobConfig)some.value();
                        bl10 = new KafkaJob(config, settings).run().isSuccess();
                    } else {
                        Predef$.MODULE$.println((Object)KafkaJobConfig$.MODULE$.usage());
                        bl10 = false;
                    }
                    bl = bl10;
                } else if ("bqload".equals(string)) {
                    boolean bl11;
                    Option<BigQueryLoadConfig> option = BigQueryLoadConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        BigQueryLoadConfig config = (BigQueryLoadConfig)some.value();
                        bl11 = workflow.bqload(config, workflow.bqload$default$2()).isSuccess();
                    } else {
                        Predef$.MODULE$.println((Object)BigQueryLoadConfig$.MODULE$.usage());
                        bl11 = false;
                    }
                    bl = bl11;
                } else if ("cnxload".equals(string)) {
                    boolean bl12;
                    Option<ConnectionLoadConfig> option = ConnectionLoadConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        ConnectionLoadConfig config = (ConnectionLoadConfig)some.value();
                        bl12 = workflow.jdbcload(config).isSuccess();
                    } else {
                        Predef$.MODULE$.println((Object)ConnectionLoadConfig$.MODULE$.usage());
                        bl12 = false;
                    }
                    bl = bl12;
                } else if ("infer-schema".equals(string)) {
                    boolean bl13;
                    Option<InferSchemaConfig> option = InferSchemaConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        InferSchemaConfig config = (InferSchemaConfig)some.value();
                        bl13 = workflow.infer(config).isSuccess();
                    } else {
                        Predef$.MODULE$.println((Object)InferSchemaConfig$.MODULE$.usage());
                        bl13 = false;
                    }
                    bl = bl13;
                } else if ("metrics".equals(string)) {
                    boolean bl14;
                    Option<MetricsConfig> option = MetricsConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        MetricsConfig config = (MetricsConfig)some.value();
                        bl14 = workflow.metric(config).isSuccess();
                    } else {
                        Predef$.MODULE$.println((Object)MetricsConfig$.MODULE$.usage());
                        bl14 = false;
                    }
                    bl = bl14;
                } else if ("parquet2csv".equals(string)) {
                    boolean bl15;
                    Option<Parquet2CSVConfig> option = Parquet2CSVConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1)));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Parquet2CSVConfig config = (Parquet2CSVConfig)some.value();
                        bl15 = new Parquet2CSV(config, settings.storageHandler(), settings).run().isSuccess();
                    } else {
                        Predef$.MODULE$.println((Object)Parquet2CSVConfig$.MODULE$.usage());
                        bl15 = false;
                    }
                    bl = bl15;
                } else if ("xls2yml".equals(string)) {
                    bl = Xls2Yml$.MODULE$.run((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1));
                } else if ("yml2xls".equals(string)) {
                    new Yml2XlsWriter(schemaHandler).run((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1));
                    bl = true;
                } else if ("yml2gv".equals(string)) {
                    new Yml2GraphViz(schemaHandler).run((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1));
                    bl = true;
                } else if ("extract".equals(string)) {
                    bl = new ScriptGen(settings.storageHandler(), schemaHandler, settings.launcherService(), settings).run((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1));
                } else {
                    this.printUsage();
                    bl = false;
                }
            }
        }
        boolean result = bl;
        System.exit(result ? 0 : 1);
    }

    private Main$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.mapper = new CometObjectMapper((JsonFactory)new YAMLFactory(), CometObjectMapper$.MODULE$.$lessinit$greater$default$2());
        this.mapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

