/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.job.index.connectionload;

import com.ebiznext.comet.config.Settings;
import com.ebiznext.comet.config.SparkEnv;
import com.ebiznext.comet.job.index.connectionload.ConnectionLoadConfig;
import com.ebiznext.comet.schema.model.SinkType;
import com.ebiznext.comet.schema.model.Views;
import com.ebiznext.comet.utils.JobBase;
import com.ebiznext.comet.utils.JobResult;
import com.ebiznext.comet.utils.SparkJob;
import com.ebiznext.comet.utils.SparkJobResult;
import com.ebiznext.comet.utils.Utils$;
import com.google.cloud.bigquery.JobInfo;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00154AAC\u0006\u00011!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005+\u0001\t\u0015\r\u0011b\u0001,\u0011!\u0011\u0004A!A!\u0002\u0013a\u0003\"B\u001a\u0001\t\u0003!\u0004\"B\u001d\u0001\t\u0003R\u0004b\u0002$\u0001\u0005\u0004%\ta\u0012\u0005\u0007'\u0002\u0001\u000b\u0011\u0002%\t\u000bQ\u0003A\u0011A+\t\u000b}\u0003A\u0011\t1\u0003#\r{gN\\3di&|g\u000eT8bI*{'M\u0003\u0002\r\u001b\u0005q1m\u001c8oK\u000e$\u0018n\u001c8m_\u0006$'B\u0001\b\u0010\u0003\u0015Ig\u000eZ3y\u0015\t\u0001\u0012#A\u0002k_\nT!AE\n\u0002\u000b\r|W.\u001a;\u000b\u0005Q)\u0012\u0001C3cSjtW\r\u001f;\u000b\u0003Y\t1aY8n\u0007\u0001\u00192\u0001A\r !\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001eI\u0007\u0002C)\u0011!%E\u0001\u0006kRLGn]\u0005\u0003I\u0005\u0012\u0001b\u00159be.TuNY\u0001\nG2L7i\u001c8gS\u001e\u0004\"a\n\u0015\u000e\u0003-I!!K\u0006\u0003)\r{gN\\3di&|g\u000eT8bI\u000e{gNZ5h\u0003!\u0019X\r\u001e;j]\u001e\u001cX#\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\n\u0012AB2p]\u001aLw-\u0003\u00022]\tA1+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u00051A(\u001b8jiz\"\"!\u000e\u001d\u0015\u0005Y:\u0004CA\u0014\u0001\u0011\u0015QC\u0001q\u0001-\u0011\u0015)C\u00011\u0001'\u0003\u0011q\u0017-\\3\u0016\u0003m\u0002\"\u0001P\"\u000f\u0005u\n\u0005C\u0001 \u001c\u001b\u0005y$B\u0001!\u0018\u0003\u0019a$o\\8u}%\u0011!iG\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002C7\u0005!1m\u001c8g+\u0005A\u0005CA%R\u001b\u0005Q%B\u0001$L\u0015\taU*\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003\u001d>\u000ba!\u00199bG\",'\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u0015\ni1i\u001c8gS\u001e,(/\u0019;j_:\fQaY8oM\u0002\nqA];o\u0015\u0012\u00135\tF\u0001W!\r9&\fX\u0007\u00021*\u0011\u0011lG\u0001\u0005kRLG.\u0003\u0002\\1\n\u0019AK]=\u0011\u0005\u0001j\u0016B\u00010\"\u00059\u0019\u0006/\u0019:l\u0015>\u0014'+Z:vYR\f1A];o)\u0005\t\u0007cA,[EB\u0011\u0001eY\u0005\u0003I\u0006\u0012\u0011BS8c%\u0016\u001cX\u000f\u001c;")
public class ConnectionLoadJob
implements SparkJob {
    private final ConnectionLoadConfig cliConfig;
    private final Settings settings;
    private final Configuration conf;
    private SparkEnv sparkEnv;
    private SparkSession session;
    private final Logger logger;
    private volatile byte bitmap$0;

    @Override
    public void registerUdf(String udf) {
        SparkJob.registerUdf$(this, udf);
    }

    @Override
    public DataFrameWriter<Row> partitionedDatasetWriter(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionedDatasetWriter$(this, dataset, partition);
    }

    @Override
    public Dataset<Row> partitionDataset(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionDataset$(this, dataset, partition);
    }

    @Override
    public Object analyze(String fullTableName) {
        return SparkJob.analyze$(this, fullTableName);
    }

    @Override
    public void createSparkViews(Views views, Map<String, String> sqlParameters) {
        SparkJob.createSparkViews$(this, views, sqlParameters);
    }

    @Override
    public Tuple3<SinkType, Option<String>, String> parseViewDefinition(String valueWithEnv) {
        return JobBase.parseViewDefinition$(this, valueWithEnv);
    }

    private SparkEnv sparkEnv$lzycompute() {
        ConnectionLoadJob connectionLoadJob = this;
        synchronized (connectionLoadJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sparkEnv = SparkJob.sparkEnv$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkEnv;
    }

    @Override
    public SparkEnv sparkEnv() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sparkEnv$lzycompute() : this.sparkEnv;
    }

    private SparkSession session$lzycompute() {
        ConnectionLoadJob connectionLoadJob = this;
        synchronized (connectionLoadJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.session = SparkJob.session$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.session;
    }

    @Override
    public SparkSession session() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.session$lzycompute() : this.session;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public String name() {
        return new StringBuilder(14).append("jdbcload-JDBC-").append(this.cliConfig.outputTable()).toString();
    }

    public Configuration conf() {
        return this.conf;
    }

    public Try<SparkJobResult> runJDBC() {
        BoxedUnit boxedUnit;
        Either<String, Dataset<Row>> inputPath = this.cliConfig.sourceFile();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Input path {}", new Object[]{inputPath});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Dataset dataset;
            Either either = inputPath;
            if (either instanceof Left) {
                Left left = (Left)either;
                String path = (String)left.value();
                dataset = this.session().read().parquet(path);
            } else if (either instanceof Right) {
                Dataset df;
                Right right = (Right)either;
                dataset = df = (Dataset)right.value();
            } else {
                throw new MatchError((Object)either);
            }
            Dataset sourceDF = dataset;
            JobInfo.WriteDisposition writeDisposition = $this.cliConfig.writeDisposition();
            JobInfo.WriteDisposition writeDisposition2 = JobInfo.WriteDisposition.WRITE_TRUNCATE;
            SaveMode writeMode = !(writeDisposition != null ? !writeDisposition.equals(writeDisposition2) : writeDisposition2 != null) ? SaveMode.Overwrite : SaveMode.Append;
            JobInfo.WriteDisposition writeDisposition3 = $this.cliConfig.writeDisposition();
            JobInfo.WriteDisposition writeDisposition4 = JobInfo.WriteDisposition.WRITE_TRUNCATE;
            DataFrameWriter dfw = sourceDF.write().format($this.cliConfig.format()).option("truncate", !(writeDisposition3 != null ? !writeDisposition3.equals(writeDisposition4) : writeDisposition4 != null)).option("dbtable", $this.cliConfig.outputTable()).mode((String)$this.cliConfig.mode().getOrElse((Function0 & Serializable & scala.Serializable)() -> writeMode.toString()));
            ((DataFrameWriter)$this.cliConfig.options().foldLeft((Object)dfw, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                DataFrameWriter w;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        w = (DataFrameWriter)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                DataFrameWriter dataFrameWriter = w.option(k, v);
                return dataFrameWriter;
            })).save();
            return new SparkJobResult((Option<Dataset<Row>>)None$.MODULE$);
        });
    }

    @Override
    public Try<JobResult> run() {
        Try<SparkJobResult> res = this.runJDBC();
        return Utils$.MODULE$.logFailure(res, this.logger());
    }

    public ConnectionLoadJob(ConnectionLoadConfig cliConfig, Settings settings) {
        BoxedUnit boxedUnit;
        this.cliConfig = cliConfig;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        JobBase.$init$(this);
        SparkJob.$init$(this);
        this.conf = this.session().sparkContext().hadoopConfiguration();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JDBC Config {}", new Object[]{cliConfig});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

