/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.job.index.kafkaload;

import com.ebiznext.comet.config.Settings;
import com.ebiznext.comet.config.SparkEnv;
import com.ebiznext.comet.job.index.kafkaload.DataFrameTransform;
import com.ebiznext.comet.job.index.kafkaload.KafkaJobConfig;
import com.ebiznext.comet.schema.model.SinkType;
import com.ebiznext.comet.schema.model.Views;
import com.ebiznext.comet.utils.JobBase;
import com.ebiznext.comet.utils.JobResult;
import com.ebiznext.comet.utils.SparkJob;
import com.ebiznext.comet.utils.SparkJobResult;
import com.ebiznext.comet.utils.Utils$;
import com.ebiznext.comet.utils.kafka.KafkaClient;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0007\u000f\u0001mA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005U!Aq\u0006\u0001BC\u0002\u0013\r\u0001\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00032\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u001dq\u0004A1A\u0005\n}Baa\u0012\u0001!\u0002\u0013\u0001\u0005\"\u0002%\u0001\t\u0003I\u0005\"B*\u0001\t\u0003I\u0005\"\u0002+\u0001\t\u0013)\u0006\"\u0002:\u0001\t\u0003\u001a\b\"\u0002=\u0001\t\u0003J(\u0001C&bM.\f'j\u001c2\u000b\u0005=\u0001\u0012!C6bM.\fGn\\1e\u0015\t\t\"#A\u0003j]\u0012,\u0007P\u0003\u0002\u0014)\u0005\u0019!n\u001c2\u000b\u0005U1\u0012!B2p[\u0016$(BA\f\u0019\u0003!)'-\u001b>oKb$(\"A\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003KQ\tQ!\u001e;jYNL!a\n\u0013\u0003\u0011M\u0003\u0018M]6K_\n\fab[1gW\u0006TuNY\"p]\u001aLw-F\u0001+!\tYC&D\u0001\u000f\u0013\ticB\u0001\bLC\u001a\\\u0017MS8c\u0007>tg-[4\u0002\u001f-\fgm[1K_\n\u001cuN\u001c4jO\u0002\n\u0001b]3ui&twm]\u000b\u0002cA\u0011!'N\u0007\u0002g)\u0011A\u0007F\u0001\u0007G>tg-[4\n\u0005Y\u001a$\u0001C*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002;{Q\u00111\b\u0010\t\u0003W\u0001AQaL\u0003A\u0004EBQ\u0001K\u0003A\u0002)\n1\u0002^8qS\u000e\u001cuN\u001c4jOV\t\u0001\t\u0005\u0002B\t:\u0011!GQ\u0005\u0003\u0007N\n\u0001bU3ui&twm]\u0005\u0003\u000b\u001a\u0013\u0001cS1gW\u0006$v\u000e]5d\u0007>tg-[4\u000b\u0005\r\u001b\u0014\u0001\u0004;pa&\u001c7i\u001c8gS\u001e\u0004\u0013aB8gM2|\u0017\r\u001a\u000b\u0002\u0015B\u00191J\u0014)\u000e\u00031S!!\u0014\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003\u001f2\u00131\u0001\u0016:z!\t\u0019\u0013+\u0003\u0002SI\tq1\u000b]1sW*{'MU3tk2$\u0018\u0001\u00027pC\u0012\f\u0001\u0002\u001e:b]N4w.\u001c\u000b\u0003-B\u0004\"aV7\u000f\u0005aSgBA-h\u001d\tQFM\u0004\u0002\\C:\u0011AlX\u0007\u0002;*\u0011aLG\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001\f1a\u001c:h\u0013\t\u00117-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A&\u0011QMZ\u0001\u0006gB\f'o\u001b\u0006\u0003E\u000eL!\u0001[5\u0002\u0007M\fHN\u0003\u0002fM&\u00111\u000e\\\u0001\ba\u0006\u001c7.Y4f\u0015\tA\u0017.\u0003\u0002o_\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003W2DQ!\u001d\u0006A\u0002Y\u000b!\u0001\u001a4\u0002\u0007I,h\u000eF\u0001u!\rYe*\u001e\t\u0003GYL!a\u001e\u0013\u0003\u0013){'MU3tk2$\u0018\u0001\u00028b[\u0016,\u0012A\u001f\t\u0003w~t!\u0001`?\u0011\u0005qs\u0012B\u0001@\u001f\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011AA\u0002\u0005\u0019\u0019FO]5oO*\u0011aP\b")
public class KafkaJob
implements SparkJob {
    private final KafkaJobConfig kafkaJobConfig;
    private final Settings settings;
    private final Settings.KafkaTopicConfig topicConfig;
    private SparkEnv sparkEnv;
    private SparkSession session;
    private final Logger logger;
    private volatile byte bitmap$0;

    @Override
    public void registerUdf(String udf) {
        SparkJob.registerUdf$(this, udf);
    }

    @Override
    public DataFrameWriter<Row> partitionedDatasetWriter(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionedDatasetWriter$(this, dataset, partition);
    }

    @Override
    public Dataset<Row> partitionDataset(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionDataset$(this, dataset, partition);
    }

    @Override
    public Object analyze(String fullTableName) {
        return SparkJob.analyze$(this, fullTableName);
    }

    @Override
    public void createSparkViews(Views views, Map<String, String> sqlParameters) {
        SparkJob.createSparkViews$(this, views, sqlParameters);
    }

    @Override
    public Tuple3<SinkType, Option<String>, String> parseViewDefinition(String valueWithEnv) {
        return JobBase.parseViewDefinition$(this, valueWithEnv);
    }

    private SparkEnv sparkEnv$lzycompute() {
        KafkaJob kafkaJob = this;
        synchronized (kafkaJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sparkEnv = SparkJob.sparkEnv$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkEnv;
    }

    @Override
    public SparkEnv sparkEnv() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sparkEnv$lzycompute() : this.sparkEnv;
    }

    private SparkSession session$lzycompute() {
        KafkaJob kafkaJob = this;
        synchronized (kafkaJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.session = SparkJob.session$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.session;
    }

    @Override
    public SparkSession session() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.session$lzycompute() : this.session;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public KafkaJobConfig kafkaJobConfig() {
        return this.kafkaJobConfig;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    private Settings.KafkaTopicConfig topicConfig() {
        return this.topicConfig;
    }

    public Try<SparkJobResult> offload() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> !this.kafkaJobConfig().streaming() ? (SparkJobResult)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> new KafkaClient(this.settings().comet().kafka(), this.settings()), (Function1 & Serializable & scala.Serializable)kafkaClient -> {
            BoxedUnit boxedUnit;
            Some some;
            int n;
            Dataset dataset;
            Tuple2<Dataset<Row>, List<Tuple2<Object, Object>>> tuple2 = kafkaClient.consumeTopicBatch(this.kafkaJobConfig().topicConfigName(), this.session(), this.topicConfig());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Dataset df = (Dataset)tuple2._1();
            List offsets = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)df, (Object)offsets);
            Tuple2 tuple23 = tuple22;
            Dataset df2 = (Dataset)tuple23._1();
            List offsets2 = (List)tuple23._2();
            Dataset transformedDF = this.transfom((Dataset<Row>)df2);
            Option<Object> option = this.kafkaJobConfig().coalesce();
            if (None$.MODULE$.equals(option)) {
                dataset = transformedDF;
            } else if (option instanceof Some) {
                Some some2 = (Some)option;
                int x = BoxesRunTime.unboxToInt((Object)some2.value());
                dataset = transformedDF.coalesce(x);
            } else {
                throw new MatchError(option);
            }
            Dataset finalDF = dataset;
            finalDF.write().mode(this.kafkaJobConfig().mode()).format(this.kafkaJobConfig().format()).options(this.kafkaJobConfig().writeOptions()).save(this.kafkaJobConfig().path());
            Option<Object> option2 = this.kafkaJobConfig().coalesce();
            if (option2 instanceof Some && 1 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option2).value()))) {
                Object object;
                String extension = this.kafkaJobConfig().format();
                Path targetPath = new Path(this.kafkaJobConfig().path());
                Path singleFile = (Path)this.settings().storageHandler().list(targetPath, new StringBuilder(1).append(".").append(extension).toString(), LocalDateTime.MIN, false).head();
                Path tmpPath = new Path(new StringBuilder(4).append(targetPath.toString()).append(".tmp").toString());
                if (this.settings().storageHandler().move(singleFile, tmpPath)) {
                    this.settings().storageHandler().delete(targetPath);
                    object = BoxesRunTime.boxToBoolean((boolean)this.settings().storageHandler().move(tmpPath, targetPath));
                } else {
                    object = BoxedUnit.UNIT;
                }
                boxedUnit = object;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            kafkaClient.topicSaveOffsets(this.kafkaJobConfig().topicConfigName(), this.topicConfig().accessOptions(), (List<Tuple2<Object, Object>>)offsets2);
            return new SparkJobResult((Option<Dataset<Row>>)new Some((Object)transformedDF));
        }) : (SparkJobResult)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> new KafkaClient(this.settings().comet().kafka(), this.settings()), (Function1 & Serializable & scala.Serializable)kafkaClient -> {
            Trigger trigger;
            Dataset<Row> df = kafkaClient.consumeTopicStreaming(this.session(), this.topicConfig());
            Dataset<Row> transformedDF = this.transfom(df);
            String string = this.kafkaJobConfig().streamingTrigger().toLowerCase();
            if ("once".equals(string)) {
                trigger = Trigger.Once();
            } else if ("processingtime".equals(string)) {
                trigger = Trigger.ProcessingTime((String)this.kafkaJobConfig().streamingTriggerOption());
            } else if ("continuous".equals(string)) {
                trigger = Trigger.Continuous((String)this.kafkaJobConfig().streamingTriggerOption());
            } else {
                throw new MatchError((Object)string);
            }
            Trigger trigger2 = trigger;
            DataStreamWriter writer = transformedDF.writeStream().outputMode(this.kafkaJobConfig().streamingWriteMode()).format(this.kafkaJobConfig().streamingWriteFormat()).options(this.kafkaJobConfig().writeOptions()).trigger(trigger2);
            Seq<String> seq = this.kafkaJobConfig().streamingWritePartitionBy();
            DataStreamWriter dataStreamWriter = Nil$.MODULE$.equals(seq) ? writer : writer.partitionBy(seq);
            DataStreamWriter partitionedWriter = dataStreamWriter;
            if (this.kafkaJobConfig().streamingWriteToTable()) {
                throw new Exception("streamingWriteToTable Not Supported");
            }
            StreamingQuery streamingQuery = partitionedWriter.start(this.kafkaJobConfig().path());
            streamingQuery.awaitTermination();
            return new SparkJobResult((Option<Dataset<Row>>)None$.MODULE$);
        }));
    }

    public Try<SparkJobResult> load() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (SparkJobResult)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> new KafkaClient(this.settings().comet().kafka(), this.settings()), (Function1 & Serializable & scala.Serializable)kafkaClient -> {
            Dataset df = this.session().read().format(this.kafkaJobConfig().format()).load((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringOps(Predef$.MODULE$.augmentString(this.kafkaJobConfig().path())).split(',')));
            Dataset<Row> transformedDF = this.transfom((Dataset<Row>)df);
            kafkaClient.sinkToTopic(this.topicConfig(), transformedDF);
            return new SparkJobResult((Option<Dataset<Row>>)new Some(transformedDF));
        }));
    }

    /*
     * WARNING - void declaration
     */
    private Dataset<Row> transfom(Dataset<Row> df) {
        void var3_6;
        Dataset<Row> dataset;
        Option<DataFrameTransform> option = this.kafkaJobConfig().transformInstance();
        if (option instanceof Some) {
            Some some = (Some)option;
            DataFrameTransform transformer = (DataFrameTransform)some.value();
            dataset = transformer.transform(df);
        } else if (None$.MODULE$.equals(option)) {
            dataset = df;
        } else {
            throw new MatchError(option);
        }
        Dataset<Row> transformedDF = dataset;
        return var3_6;
    }

    @Override
    public Try<JobResult> run() {
        return this.kafkaJobConfig().offload() ? this.offload() : this.load();
    }

    @Override
    public String name() {
        return String.valueOf(this.kafkaJobConfig().topicConfigName());
    }

    public KafkaJob(KafkaJobConfig kafkaJobConfig, Settings settings) {
        this.kafkaJobConfig = kafkaJobConfig;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        JobBase.$init$(this);
        SparkJob.$init$(this);
        this.topicConfig = (Settings.KafkaTopicConfig)settings.comet().kafka().topics().apply((Object)kafkaJobConfig.topicConfigName());
    }
}

