/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.job.ingest;

import com.ebiznext.comet.config.Settings;
import com.ebiznext.comet.schema.model.Attribute;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class XmlSimplePrivacyJob$ {
    public static XmlSimplePrivacyJob$ MODULE$;

    static {
        new XmlSimplePrivacyJob$();
    }

    public Dataset<Row> applyPrivacy(Dataset<Row> inputDF, Attribute attribute, SparkSession session, Settings settings) {
        String openTag = new StringBuilder(2).append("<").append(attribute.name()).append(">").toString();
        String closeTag = new StringBuilder(3).append("</").append(attribute.name()).append(">").toString();
        Pattern pattern = Pattern.compile(new StringBuilder(6).append(".*").append(openTag).append(".*").append(closeTag).append(".*").toString());
        RDD resultRDD = inputDF.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)row -> {
            String string;
            String line = row.getString(0);
            boolean bl = pattern.matcher(line).matches();
            if (!bl) {
                string = line;
            } else if (bl) {
                int openIndex = line.indexOf(openTag) + new StringOps(Predef$.MODULE$.augmentString(openTag)).size();
                int closeIndex = line.indexOf(closeTag);
                String prefix = line.substring(0, openIndex);
                String suffix = line.substring(closeIndex);
                String privacyInput = line.substring(openIndex, closeIndex);
                string = new StringBuilder(0).append(prefix).append(attribute.getPrivacy().crypt(privacyInput, (Map<String, Option<String>>)Predef$.MODULE$.Map().empty(), settings)).append(suffix).toString();
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            String privacy = string;
            return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{privacy}));
        }), inputDF.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
        StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        return session.createDataFrame(resultRDD, schema);
    }

    private XmlSimplePrivacyJob$() {
        MODULE$ = this;
    }
}

