/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.schema.generator;

import better.files.File;
import better.files.File$;
import com.ebiznext.comet.config.Settings;
import com.ebiznext.comet.config.Settings$;
import com.ebiznext.comet.schema.generator.XlsModel;
import com.ebiznext.comet.schema.generator.Yml2XlsConfig;
import com.ebiznext.comet.schema.generator.Yml2XlsConfig$;
import com.ebiznext.comet.schema.handlers.SchemaHandler;
import com.ebiznext.comet.schema.model.Attribute;
import com.ebiznext.comet.schema.model.Domain;
import com.ebiznext.comet.schema.model.Format$DSV$;
import com.ebiznext.comet.schema.model.Format$POSITION$;
import com.ebiznext.comet.schema.model.MergeOptions;
import com.ebiznext.comet.schema.model.Metadata;
import com.ebiznext.comet.schema.model.Schema;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001%4AAB\u0004\u0001%!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003-\u0001\u0011\u0005Q\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003F\u0001\u0011\u0005a\tC\u0003^\u0001\u0011\u0005aLA\u0007Z[2\u0014\u0004\f\\:Xe&$XM\u001d\u0006\u0003\u0011%\t\u0011bZ3oKJ\fGo\u001c:\u000b\u0005)Y\u0011AB:dQ\u0016l\u0017M\u0003\u0002\r\u001b\u0005)1m\\7fi*\u0011abD\u0001\tK\nL'P\\3yi*\t\u0001#A\u0002d_6\u001c\u0001a\u0005\u0003\u0001'e\t\u0003C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b?5\t1D\u0003\u0002\u001d;\u0005a1oY1mC2|wmZ5oO*\u0011adD\u0001\tif\u0004Xm]1gK&\u0011\u0001e\u0007\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0005\u0002#G5\tq!\u0003\u0002%\u000f\tA\u0001\f\\:N_\u0012,G.A\u0007tG\",W.\u0019%b]\u0012dWM\u001d\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S%\t\u0001\u0002[1oI2,'o]\u0005\u0003W!\u0012QbU2iK6\f\u0007*\u00198eY\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0002/_A\u0011!\u0005\u0001\u0005\u0006K\t\u0001\rAJ\u0001\u0004eVtGC\u0001\u001a6!\t!2'\u0003\u00025+\t!QK\\5u\u0011\u001514\u00011\u00018\u0003\u0011\t'oZ:\u0011\u0007QA$(\u0003\u0002:+\t)\u0011I\u001d:bsB\u00111H\u0011\b\u0003y\u0001\u0003\"!P\u000b\u000e\u0003yR!aP\t\u0002\rq\u0012xn\u001c;?\u0013\t\tU#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!\u0016\u0003-9WM\\3sCR,\u0007\f\\:\u0015\u0007\u001d\u00036\f\u0006\u00023\u0011\")\u0011\n\u0002a\u0002\u0015\u0006A1/\u001a;uS:<7\u000f\u0005\u0002L\u001d6\tAJ\u0003\u0002N\u0017\u000511m\u001c8gS\u001eL!a\u0014'\u0003\u0011M+G\u000f^5oONDQ!\u0015\u0003A\u0002I\u000b1\u0002Z8nC&tg*Y7fgB\u00191\u000b\u0017\u001e\u000f\u0005Q3fBA\u001fV\u0013\u00051\u0012BA,\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0017.\u0003\u0007M+\u0017O\u0003\u0002X+!)A\f\u0002a\u0001u\u0005Iq.\u001e;qkR$\u0015N]\u0001\u000foJLG/\u001a#p[\u0006Lg\u000e\u00177t)\r\u0011tl\u001a\u0005\u0006A\u0016\u0001\r!Y\u0001\u0007I>l\u0017-\u001b8\u0011\u0005\t,W\"A2\u000b\u0005\u0011L\u0011!B7pI\u0016d\u0017B\u00014d\u0005\u0019!u.\\1j]\")\u0001.\u0002a\u0001u\u00051am\u001c7eKJ\u0004")
public class Yml2XlsWriter
implements LazyLogging,
XlsModel {
    private final SchemaHandler schemaHandler;
    private final List<Tuple2<String, String>> allDomainHeaders;
    private final List<Tuple2<String, String>> allSchemaHeaders;
    private final List<Tuple2<String, String>> allAttributeHeaders;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public List<Tuple2<String, String>> allDomainHeaders() {
        return this.allDomainHeaders;
    }

    @Override
    public List<Tuple2<String, String>> allSchemaHeaders() {
        return this.allSchemaHeaders;
    }

    @Override
    public List<Tuple2<String, String>> allAttributeHeaders() {
        return this.allAttributeHeaders;
    }

    @Override
    public void com$ebiznext$comet$schema$generator$XlsModel$_setter_$allDomainHeaders_$eq(List<Tuple2<String, String>> x$1) {
        this.allDomainHeaders = x$1;
    }

    @Override
    public void com$ebiznext$comet$schema$generator$XlsModel$_setter_$allSchemaHeaders_$eq(List<Tuple2<String, String>> x$1) {
        this.allSchemaHeaders = x$1;
    }

    @Override
    public void com$ebiznext$comet$schema$generator$XlsModel$_setter_$allAttributeHeaders_$eq(List<Tuple2<String, String>> x$1) {
        this.allAttributeHeaders = x$1;
    }

    private Logger logger$lzycompute() {
        Yml2XlsWriter yml2XlsWriter = this;
        synchronized (yml2XlsWriter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void run(String[] args) {
        Settings settings = Settings$.MODULE$.apply(ConfigFactory.load());
        Option<Yml2XlsConfig> option = Yml2XlsConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (option instanceof Some) {
            Some some = (Some)option;
            Yml2XlsConfig config = (Yml2XlsConfig)some.value();
            this.generateXls(config.domains(), config.xlsDirectory(), settings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.println((Object)Yml2XlsConfig$.MODULE$.usage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void generateXls(Seq<String> domainNames, String outputDir, Settings settings) {
        Seq<String> seq = domainNames;
        List list = Nil$.MODULE$.equals(seq) ? this.schemaHandler.domains() : (List)this.schemaHandler.domains().filter((Function1 & Serializable & scala.Serializable)domain -> BoxesRunTime.boxToBoolean((boolean)seq.contains((Object)domain.name())));
        List domains = list;
        domains.foreach((Function1 & Serializable & scala.Serializable)domain -> {
            this.writeDomainXls(domain, outputDir);
            return BoxedUnit.UNIT;
        });
    }

    public void writeDomainXls(Domain domain, String folder) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)14);
        font.setFontName("Calibri");
        font.setBold(true);
        XSSFCellStyle boldStyle = workbook.createCellStyle();
        boldStyle.setFont((Font)font);
        File xlsOut = File$.MODULE$.apply(folder, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(5).append(domain.name()).append(".xlsx").toString()}));
        XSSFSheet domainSheet = workbook.createSheet("domain");
        Yml2XlsWriter.fillHeaders$1(this.allDomainHeaders(), domainSheet, boldStyle);
        XSSFRow domainRow = domainSheet.createRow(2);
        domainRow.createCell(0).setCellValue(domain.name());
        domainRow.createCell(1).setCellValue(domain.directory());
        domainRow.createCell(2).setCellValue((String)domain.ack().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        domainRow.createCell(3).setCellValue((String)domain.comment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> domainSheet.autoSizeColumn(i));
        XSSFSheet schemaSheet = workbook.createSheet("schemas");
        Yml2XlsWriter.fillHeaders$1(this.allSchemaHeaders(), schemaSheet, boldStyle);
        ((List)domain.schemas().zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Yml2XlsWriter.$anonfun$writeDomainXls$8(this, domain, schemaSheet, workbook, boldStyle, x0$1);
            return BoxedUnit.UNIT;
        });
        xlsOut.delete(true, xlsOut.delete$default$2());
        workbook.write((OutputStream)xlsOut.newFileOutputStream(false));
    }

    public static final /* synthetic */ void $anonfun$writeDomainXls$2(XSSFRow header$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        int columnIndex = tuple2._2$mcI$sp();
        XSSFCell cell = header$1.createCell(columnIndex);
        cell.setCellValue(key);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$writeDomainXls$4(XSSFRow labelHeader$1, XSSFCellStyle boldStyle$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String value = (String)tuple2._1();
        int columnIndex = tuple2._2$mcI$sp();
        XSSFCell cell = labelHeader$1.createCell(columnIndex);
        cell.setCellValue(value);
        cell.setCellStyle((CellStyle)boldStyle$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void fillHeaders$1(List headers, XSSFSheet sheet, XSSFCellStyle boldStyle$1) {
        XSSFRow header = sheet.createRow(0);
        header.setHeight((short)0);
        ((List)((IterableLike)headers.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = key = (String)tuple2._1();
            return string;
        }, List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Yml2XlsWriter.$anonfun$writeDomainXls$2(header, x0$2);
            return BoxedUnit.UNIT;
        });
        XSSFRow labelHeader = sheet.createRow(1);
        ((List)((IterableLike)headers.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            String value;
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = value = (String)tuple2._2();
            return string;
        }, List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Yml2XlsWriter.$anonfun$writeDomainXls$4(labelHeader, boldStyle$1, x0$4);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$writeDomainXls$15(boolean x$4) {
        return ((Object)BoxesRunTime.boxToBoolean((boolean)x$4)).toString();
    }

    public static final /* synthetic */ void $anonfun$writeDomainXls$17(XSSFRow schemaRow$1, MergeOptions mergeOptions) {
        schemaRow$1.createCell(7).setCellValue((String)mergeOptions.timestamp().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow$1.createCell(8).setCellValue(mergeOptions.key().mkString(","));
        schemaRow$1.createCell(15).setCellValue((String)mergeOptions.queryFilter().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$writeDomainXls$45(boolean x$13) {
        return ((Object)BoxesRunTime.boxToBoolean((boolean)x$13)).toString();
    }

    public static final /* synthetic */ void $anonfun$writeDomainXls$31(XSSFSheet attributesSheet$1, Metadata metadata$1, Tuple2 x0$2) {
        XSSFRow attrRow;
        Attribute attr;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            attr = (Attribute)tuple2._1();
            int rowIndex = tuple2._2$mcI$sp();
            attrRow = attributesSheet$1.createRow(2 + rowIndex);
            attrRow.createCell(0).setCellValue(attr.name());
            attrRow.createCell(1).setCellValue((String)attr.rename().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            attrRow.createCell(2).setCellValue(attr.type());
            attrRow.createCell(3).setCellValue(attr.required());
            attrRow.getCell(3).setCellType(CellType.BOOLEAN);
            attrRow.createCell(4).setCellValue(attr.getPrivacy().toString());
            attrRow.createCell(5).setCellValue((String)attr.metricType().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            attrRow.createCell(6).setCellValue((String)attr.default().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            attrRow.createCell(7).setCellValue((String)attr.script().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            attrRow.createCell(8).setCellValue((String)attr.comment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            attrRow.createCell(9).setCellValue("");
            attrRow.createCell(10).setCellValue("");
            Object object = metadata$1.format().getOrElse((Function0 & Serializable & scala.Serializable)() -> Format$DSV$.MODULE$);
            Format$POSITION$ format$POSITION$ = Format$POSITION$.MODULE$;
            if (!(object != null ? !object.equals(format$POSITION$) : format$POSITION$ != null)) {
                attrRow.getCell(9).setCellType(CellType.NUMERIC);
                attrRow.getCell(10).setCellType(CellType.NUMERIC);
                attrRow.getCell(9).setCellValue((String)attr.position().map((Function1 & Serializable & scala.Serializable)x$10 -> ((Object)BoxesRunTime.boxToInteger((int)x$10.first())).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
                attrRow.getCell(10).setCellValue((String)attr.position().map((Function1 & Serializable & scala.Serializable)x$11 -> ((Object)BoxesRunTime.boxToInteger((int)x$11.last())).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        attrRow.createCell(11).setCellValue((String)attr.trim().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        attrRow.createCell(12).setCellValue((String)attr.ignore().map((Function1 & Serializable & scala.Serializable)x$13 -> Yml2XlsWriter.$anonfun$writeDomainXls$45(BoxesRunTime.unboxToBoolean((Object)x$13))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "false"));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$writeDomainXls$8(Yml2XlsWriter $this, Domain domain$1, XSSFSheet schemaSheet$1, XSSFWorkbook workbook$1, XSSFCellStyle boldStyle$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Schema schema = (Schema)tuple2._1();
        int rowIndex = tuple2._2$mcI$sp();
        Metadata metadata = schema.mergedMetadata(domain$1.metadata());
        XSSFRow schemaRow = schemaSheet$1.createRow(2 + rowIndex);
        schemaRow.createCell(0).setCellValue(schema.name());
        schemaRow.createCell(1).setCellValue(schema.pattern().toString());
        schemaRow.createCell(2).setCellValue((String)metadata.mode().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(3).setCellValue((String)metadata.write().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(4).setCellValue((String)metadata.format().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(5).setCellValue((String)metadata.withHeader().map((Function1 & Serializable & scala.Serializable)x$4 -> Yml2XlsWriter.$anonfun$writeDomainXls$15(BoxesRunTime.unboxToBoolean((Object)x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.getCell(5).setCellType(CellType.BOOLEAN);
        schemaRow.createCell(6).setCellValue(metadata.getSeparator());
        schema.merge().foreach((Function1 & Serializable & scala.Serializable)mergeOptions -> {
            Yml2XlsWriter.$anonfun$writeDomainXls$17(schemaRow, mergeOptions);
            return BoxedUnit.UNIT;
        });
        schemaRow.createCell(9).setCellValue((String)schema.comment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(10).setCellValue((String)metadata.encoding().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(11).setCellValue((String)metadata.partition().map((Function1 & Serializable & scala.Serializable)x$5 -> ((Object)BoxesRunTime.boxToDouble((double)x$5.getSampling())).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(12).setCellValue((String)metadata.partition().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getAttributes().mkString(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(13).setCellValue((String)metadata.getSink().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(14).setCellValue((String)metadata.clustering().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.mkString(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> schemaSheet$1.autoSizeColumn(i));
        XSSFSheet attributesSheet = workbook$1.createSheet(schema.name());
        Yml2XlsWriter.fillHeaders$1($this.allAttributeHeaders(), attributesSheet, boldStyle$1);
        ((List)schema.attributes().zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Yml2XlsWriter.$anonfun$writeDomainXls$31(attributesSheet, metadata, x0$2);
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> attributesSheet.autoSizeColumn(i));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Yml2XlsWriter(SchemaHandler schemaHandler) {
        this.schemaHandler = schemaHandler;
        LazyLogging.$init$((LazyLogging)this);
        XlsModel.$init$(this);
    }
}

