/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.schema.handlers;

import com.ebiznext.comet.config.Settings;
import com.ebiznext.comet.job.index.bqload.BigQueryLoadConfig;
import com.ebiznext.comet.job.index.connectionload.ConnectionLoadConfig;
import com.ebiznext.comet.job.index.esload.ESLoadConfig;
import com.ebiznext.comet.schema.handlers.LaunchHandler;
import com.ebiznext.comet.schema.model.Domain;
import com.ebiznext.comet.schema.model.Schema;
import com.ebiznext.comet.utils.AirflowJobResult;
import com.ebiznext.comet.utils.JobResult;
import com.ebiznext.comet.workflow.IngestionWorkflow;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0004\t\u0001MAQA\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005\u0012)BQA\u0012\u0001\u0005B\u001dCq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u00020\u0001!\t%!\r\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\ty\u0011)\u001b:gY><H*Y;oG\",'O\u0003\u0002\n\u0015\u0005A\u0001.\u00198eY\u0016\u00148O\u0003\u0002\f\u0019\u000511o\u00195f[\u0006T!!\u0004\b\u0002\u000b\r|W.\u001a;\u000b\u0005=\u0001\u0012\u0001C3cSjtW\r\u001f;\u000b\u0003E\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u000b\u001b=A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"a\u0007\u000f\u000e\u0003!I!!\b\u0005\u0003\u001b1\u000bWO\\2i\u0011\u0006tG\r\\3s!\tyB%D\u0001!\u0015\t\t#%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002$!\u0005AA/\u001f9fg\u00064W-\u0003\u0002&A\ti1\u000b\u001e:jGRdunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005m\u0001\u0011\u0001\u00029pgR$2aK\u001cE!\ras&M\u0007\u0002[)\u0011aFF\u0001\u0005kRLG.\u0003\u00021[\t\u0019AK]=\u0011\u0005I*T\"A\u001a\u000b\u0005Qb\u0011!B;uS2\u001c\u0018B\u0001\u001c4\u0005A\t\u0015N\u001d4m_^TuN\u0019*fgVdG\u000fC\u00039\u0005\u0001\u0007\u0011(A\u0002ve2\u0004\"AO!\u000f\u0005mz\u0004C\u0001\u001f\u0017\u001b\u0005i$B\u0001 \u0013\u0003\u0019a$o\\8u}%\u0011\u0001IF\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002A-!)QI\u0001a\u0001s\u000591m\\7nC:$\u0017AB5oO\u0016\u001cH\u000f\u0006\u0004I+r#\u0007n \u000b\u0003\u00136\u00032\u0001L\u0018K!\t\u00114*\u0003\u0002Mg\tI!j\u001c2SKN,H\u000e\u001e\u0005\u0006\u001d\u000e\u0001\u001daT\u0001\tg\u0016$H/\u001b8hgB\u0011\u0001kU\u0007\u0002#*\u0011!\u000bD\u0001\u0007G>tg-[4\n\u0005Q\u000b&\u0001C*fiRLgnZ:\t\u000bY\u001b\u0001\u0019A,\u0002\u0011]|'o\u001b4m_^\u0004\"\u0001\u0017.\u000e\u0003eS!A\u0016\u0007\n\u0005mK&!E%oO\u0016\u001cH/[8o/>\u00148N\u001a7po\")Ql\u0001a\u0001=\u00061Am\\7bS:\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019\u0006\u0002\u000b5|G-\u001a7\n\u0005\r\u0004'A\u0002#p[\u0006Lg\u000eC\u0003\f\u0007\u0001\u0007Q\r\u0005\u0002`M&\u0011q\r\u0019\u0002\u0007'\u000eDW-\\1\t\u000b%\u001c\u0001\u0019\u00016\u0002\u000bA\fG\u000f[:\u0011\u0007-\u00048O\u0004\u0002m]:\u0011A(\\\u0005\u0002/%\u0011qNF\u0001\ba\u0006\u001c7.Y4f\u0013\t\t(O\u0001\u0003MSN$(BA8\u0017!\t!X0D\u0001v\u0015\t1x/\u0001\u0002gg*\u0011\u00010_\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005i\\\u0018AB1qC\u000eDWMC\u0001}\u0003\ry'oZ\u0005\u0003}V\u0014A\u0001U1uQ\"9\u0011\u0011A\u0002A\u0002\u0005\r\u0011aB8qi&|gn\u001d\t\u0006u\u0005\u0015\u0011(O\u0005\u0004\u0003\u000f\u0019%aA'ba\u00061Qm\u001d'pC\u0012$b!!\u0004\u0002\u0018\u0005eA\u0003BA\b\u0003+\u00012!FA\t\u0013\r\t\u0019B\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015qE\u0001q\u0001P\u0011\u00151F\u00011\u0001X\u0011\u0019\u0011F\u00011\u0001\u0002\u001cA!\u0011QDA\u0016\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012AB3tY>\fGM\u0003\u0003\u0002&\u0005\u001d\u0012!B5oI\u0016D(bAA\u0015\u0019\u0005\u0019!n\u001c2\n\t\u00055\u0012q\u0004\u0002\r\u000bNcu.\u00193D_:4\u0017nZ\u0001\u0007EFdw.\u00193\u0015\r\u0005M\u0012qGA\u001d)\u0011\ty!!\u000e\t\u000b9+\u00019A(\t\u000bY+\u0001\u0019A,\t\rI+\u0001\u0019AA\u001e!\u0011\ti$!\u0011\u000e\u0005\u0005}\"\u0002BA\u0018\u0003GIA!a\u0011\u0002@\t\u0011\")[4Rk\u0016\u0014\u0018\u0010T8bI\u000e{gNZ5h\u0003!QGMY2m_\u0006$GCBA%\u0003\u001b\ny\u0005\u0006\u0003\u0002\u0010\u0005-\u0003\"\u0002(\u0007\u0001\by\u0005\"\u0002,\u0007\u0001\u00049\u0006B\u0002*\u0007\u0001\u0004\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\u0011\t9&a\t\u0002\u001d\r|gN\\3di&|g\u000e\\8bI&!\u00111LA+\u0005Q\u0019uN\u001c8fGRLwN\u001c'pC\u0012\u001cuN\u001c4jO\u0002")
public class AirflowLauncher
implements LaunchHandler,
StrictLogging {
    private final Logger logger;

    @Override
    public Try<JobResult> ingest(IngestionWorkflow workflow, Domain domain, Schema schema, Path path, Map<String, String> options, Settings settings) {
        return LaunchHandler.ingest$(this, workflow, domain, schema, path, options, settings);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Try<AirflowJobResult> post(String url, String command) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            String json = new StringBuilder(29).append("{\"conf\":\"{\\\"command\\\":\\\"").append(command).append("\\\"}\"}").toString();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("JSON to post to Airflow: {}", new Object[]{json});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            CloseableHttpClient client = HttpClients.createDefault();
            StringEntity requestEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)requestEntity);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(21).append("Posting to Airflow: ").append(httpPost.getURI().toString()).append("\n").append(EntityUtils.toString((HttpEntity)httpPost.getEntity(), (String)"UTF-8")).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(26).append("Post result from Airflow: ").append(responseBody).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            client.close();
            return new AirflowJobResult(responseBody);
        });
    }

    @Override
    public Try<JobResult> ingest(IngestionWorkflow workflow, Domain domain, Schema schema, List<Path> paths, Map<String, String> options, Settings settings) {
        String endpoint = settings.comet().airflow().endpoint();
        String ingest = settings.comet().airflow().ingest();
        String url = new StringBuilder(15).append(endpoint).append("/dags/").append(ingest).append("/dag_runs").toString();
        String command = new StringBuilder(9).append("ingest ").append(domain.name()).append(" ").append(schema.name()).append(" ").append(paths.mkString(",")).toString();
        Thread.sleep(1000L);
        return this.post(url, command);
    }

    @Override
    public boolean esLoad(IngestionWorkflow workflow, ESLoadConfig config, Settings settings) {
        String endpoint = settings.comet().airflow().endpoint();
        String url = new StringBuilder(26).append(endpoint).append("/dags/comet_index/dag_runs").toString();
        String resource = new .colon.colon((Object)new StringBuilder(12).append("--timestamp ").append(config.timestamp()).toString(), (List)new .colon.colon((Object)new StringBuilder(9).append("--domain ").append(config.domain()).toString(), (List)new .colon.colon((Object)new StringBuilder(9).append("--schema ").append(config.schema()).toString(), (List)new .colon.colon((Object)new StringBuilder(9).append("--format ").append(config.format()).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("--dataset ").append(config.getDataset(settings)).toString(), (List)Nil$.MODULE$))))).mkString(" ");
        Option id2 = config.id().map((Function1 & Serializable & scala.Serializable)id -> new StringBuilder(5).append("--id ").append((String)id).toString());
        Option mapping = config.mapping().map((Function1 & Serializable & scala.Serializable)path -> new StringBuilder(10).append("--mapping ").append(path.toString()).toString());
        String params = ((TraversableOnce)new .colon.colon((Object)new Some((Object)resource), (List)new .colon.colon((Object)id2, (List)new .colon.colon((Object)mapping, (List)Nil$.MODULE$))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).mkString(" ");
        String command = new StringBuilder(7).append("index ").append(params).append(" ").toString();
        return this.post(url, command).isSuccess();
    }

    @Override
    public boolean bqload(IngestionWorkflow workflow, BigQueryLoadConfig config, Settings settings) {
        String endpoint = settings.comet().airflow().endpoint();
        String url = new StringBuilder(27).append(endpoint).append("/dags/comet_bqload/dag_runs").toString();
        String params = new .colon.colon((Object)new StringBuilder(14).append("--source_file ").append(config.source()).toString(), (List)new .colon.colon((Object)new StringBuilder(17).append("--output_dataset ").append(config.outputDataset()).toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("--output_table ").append(config.outputTable()).toString(), (List)new .colon.colon((Object)new StringBuilder(16).append("--source_format ").append(config.sourceFormat()).toString(), (List)new .colon.colon((Object)new StringBuilder(21).append("--create_disposition ").append(config.createDisposition()).toString(), (List)new .colon.colon((Object)new StringBuilder(20).append("--write_disposition ").append(config.writeDisposition()).toString(), (List)new .colon.colon((Object)((String)config.outputPartition().map((Function1 & Serializable & scala.Serializable)partition -> new StringBuilder(19).append("--output_partition ").append((String)partition).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)Nil$.MODULE$))))))).mkString(" ");
        String command = new StringBuilder(8).append("bqload ").append(params).append(" ").toString();
        return this.post(url, command).isSuccess();
    }

    @Override
    public boolean jdbcload(IngestionWorkflow workflow, ConnectionLoadConfig config, Settings settings) {
        String endpoint = settings.comet().airflow().endpoint();
        String url = new StringBuilder(29).append(endpoint).append("/dags/comet_jdbcload/dag_runs").toString();
        String params = new .colon.colon((Object)new StringBuilder(14).append("--source_file ").append(config.sourceFile()).toString(), (List)new .colon.colon((Object)"--options partitions=1000,user=sa,password=sa,batch_size=1,driver=org.postgresqlDriver,url=jdbc:postgresql:...", (List)new .colon.colon((Object)"--format=jdbc", (List)new .colon.colon((Object)new StringBuilder(21).append("--create_disposition ").append(config.createDisposition()).toString(), (List)new .colon.colon((Object)new StringBuilder(20).append("--write_disposition ").append(config.writeDisposition()).toString(), (List)Nil$.MODULE$))))).mkString(" ");
        String command = new StringBuilder(10).append("jdbcload ").append(params).append(" ").toString();
        return this.post(url, command).isSuccess();
    }

    public AirflowLauncher() {
        LaunchHandler.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
    }
}

