/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.schema.handlers;

import com.ebiznext.comet.config.Settings;
import com.ebiznext.comet.schema.handlers.StorageHandler;
import com.ebiznext.comet.utils.conversion.Conversions$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tMa\u0001\u0002\u0010 \u0001)B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\t\u0002\u0011\t\u0011)A\u0006\u000b\")1\n\u0001C\u0001\u0019\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006B\u00020\u0001A\u0003%1\u000b\u0003\u0005`\u0001!\u0015\r\u0011\"\u0001a\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015Y\u0007\u0001\"\u0011c\u0011\u001da\u0007A1A\u0005\u00025Daa\u001d\u0001!\u0002\u0013q\u0007\"\u0002;\u0001\t\u0003)\b\"\u0002@\u0001\t\u0003y\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002h\u0001!\t%!\u001b\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t!9\u0011q\u000f\u0001\u0005B\u0005e\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011\u001d\ty\t\u0001C!\u0003#Cq!!&\u0001\t\u0003\t9\nC\u0004\u0002\"\u0002!\t!a)\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBAx\u0001\u0011\u0005\u0013\u0011\u001f\u0005\b\u0005\u0003\u0001A\u0011\tB\u0002\u0011\u001d\u00119\u0001\u0001C!\u0005\u0013\u0011!\u0003\u00133ggN#xN]1hK\"\u000bg\u000e\u001a7fe*\u0011\u0001%I\u0001\tQ\u0006tG\r\\3sg*\u0011!eI\u0001\u0007g\u000eDW-\\1\u000b\u0005\u0011*\u0013!B2p[\u0016$(B\u0001\u0014(\u0003!)'-\u001b>oKb$(\"\u0001\u0015\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Y\u0013\u0007\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004B]f\u0014VM\u001a\t\u0003eMj\u0011aH\u0005\u0003i}\u0011ab\u0015;pe\u0006<W\rS1oI2,'/\u0001\u0006gS2,7+_:uK6\u00042\u0001L\u001c:\u0013\tATF\u0001\u0004PaRLwN\u001c\t\u0003u\u0005s!aO \u0011\u0005qjS\"A\u001f\u000b\u0005yJ\u0013A\u0002\u001fs_>$h(\u0003\u0002A[\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001U&\u0001\u0005tKR$\u0018N\\4t!\t1\u0015*D\u0001H\u0015\tA5%\u0001\u0004d_:4\u0017nZ\u0005\u0003\u0015\u001e\u0013\u0001bU3ui&twm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055\u0003FC\u0001(P!\t\u0011\u0004\u0001C\u0003E\u0007\u0001\u000fQ\tC\u00036\u0007\u0001\u0007a'\u0001\u0003d_:4W#A*\u0011\u0005QcV\"A+\u000b\u0005E3&BA,Y\u0003\u0019A\u0017\rZ8pa*\u0011\u0011LW\u0001\u0007CB\f7\r[3\u000b\u0003m\u000b1a\u001c:h\u0013\tiVKA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0006G>tg\rI\u0001\u0015]>\u0014X.\u00197ju\u0016$g)\u001b7f'f\u001cH/Z7\u0016\u0003Y\nq\u0003\\8dW\u0006\u001b\u0017/^5tSRLwN\u001c)pY2$\u0016.\\3\u0016\u0003\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\u0011\u0011,(/\u0019;j_:T!\u0001[\u0017\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002kK\nqa)\u001b8ji\u0016$UO]1uS>t\u0017a\u00057pG.\u0014VM\u001a:fg\"\u0004v\u000e\u001c7US6,\u0017A\u00014t+\u0005q\u0007CA8r\u001b\u0005\u0001(B\u00017W\u0013\t\u0011\bO\u0001\u0006GS2,7+_:uK6\f1AZ:!\u0003=9W\r^(viB,Ho\u0015;sK\u0006lGC\u0001<z!\tyw/\u0003\u0002ya\n\u0011bi\u0015#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0011\u0015Q8\u00021\u0001|\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005=d\u0018BA?q\u0005\u0011\u0001\u0016\r\u001e5\u0002\tI,\u0017\r\u001a\u000b\u0004s\u0005\u0005\u0001\"\u0002>\r\u0001\u0004Y\u0018!B<sSR,GCBA\u0004\u0003\u001b\t\t\u0002E\u0002-\u0003\u0013I1!a\u0003.\u0005\u0011)f.\u001b;\t\r\u0005=Q\u00021\u0001:\u0003\u0011!\u0017\r^1\t\u000bil\u0001\u0019A>\u0002\u0017]\u0014\u0018\u000e^3CS:\f'/\u001f\u000b\u0007\u0003\u000f\t9\"!\n\t\u000f\u0005=a\u00021\u0001\u0002\u001aA)A&a\u0007\u0002 %\u0019\u0011QD\u0017\u0003\u000b\u0005\u0013(/Y=\u0011\u00071\n\t#C\u0002\u0002$5\u0012AAQ=uK\")!P\u0004a\u0001w\u0006yA.[:u\t&\u0014Xm\u0019;pe&,7\u000f\u0006\u0003\u0002,\u0005u\u0002#BA\u0017\u0003oYh\u0002BA\u0018\u0003gq1\u0001PA\u0019\u0013\u0005q\u0013bAA\u001b[\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001d\u0003w\u0011A\u0001T5ti*\u0019\u0011QG\u0017\t\u000bi|\u0001\u0019A>\u0002\t1L7\u000f\u001e\u000b\u000b\u0003W\t\u0019%!\u0012\u0002J\u0005u\u0003\"\u0002>\u0011\u0001\u0004Y\b\u0002CA$!A\u0005\t\u0019A\u001d\u0002\u0013\u0015DH/\u001a8tS>t\u0007\"CA&!A\u0005\t\u0019AA'\u0003\u0015\u0019\u0018N\\2f!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\nA\u0001^5nK*\u0011\u0011qK\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\\\u0005E#!\u0004'pG\u0006dG)\u0019;f)&lW\rC\u0004\u0002`A\u0001\r!!\u0019\u0002\u0013I,7-\u001e:tSZ,\u0007c\u0001\u0017\u0002d%\u0019\u0011QM\u0017\u0003\u000f\t{w\u000e\\3b]\u0006!Qn\u001c<f)\u0019\t\t'a\u001b\u0002n!)!0\u0005a\u0001w\"1\u0011qN\tA\u0002m\fA\u0001Z3ti\u00061A-\u001a7fi\u0016$B!!\u0019\u0002v!)!P\u0005a\u0001w\u00061Qn\u001b3jeN$B!!\u0019\u0002|!)!p\u0005a\u0001w\u0006i1m\u001c9z\rJ|W\u000eT8dC2$b!a\u0002\u0002\u0002\u0006\u0015\u0005BBAB)\u0001\u000710\u0001\u0004t_V\u00148-\u001a\u0005\u0007\u0003_\"\u0002\u0019A>\u0002\u001b5|g/\u001a$s_6dunY1m)\u0019\t9!a#\u0002\u000e\"1\u00111Q\u000bA\u0002mDa!a\u001c\u0016\u0001\u0004Y\u0018AB3ySN$8\u000f\u0006\u0003\u0002b\u0005M\u0005\"\u0002>\u0017\u0001\u0004Y\u0018!\u00032m_\u000e\\7+\u001b>f)\u0011\tI*a(\u0011\u00071\nY*C\u0002\u0002\u001e6\u0012A\u0001T8oO\")!p\u0006a\u0001w\u0006q1m\u001c8uK:$8+^7nCJLH\u0003BAS\u0003W\u00032a\\AT\u0013\r\tI\u000b\u001d\u0002\u000f\u0007>tG/\u001a8u'VlW.\u0019:z\u0011\u0015Q\b\u00041\u0001|\u00035\u0019\b/Y2f\u0007>t7/^7fIR!\u0011\u0011TAY\u0011\u0015Q\u0018\u00041\u0001|\u00031a\u0017m\u001d;N_\u0012Lg-[3e)\u0011\t9,!<\u0011\t\u0005e\u0016q\u001d\b\u0005\u0003w\u000b\tO\u0004\u0003\u0002>\u0006mg\u0002BA`\u0003+tA!!1\u0002P:!\u00111YAf\u001d\u0011\t)-!3\u000f\u0007q\n9-C\u0001\\\u0013\tI&,C\u0002\u0002Nb\u000bQa\u001d9be.LA!!5\u0002T\u0006\u00191/\u001d7\u000b\u0007\u00055\u0007,\u0003\u0003\u0002X\u0006e\u0017!C3yK\u000e,H/[8o\u0015\u0011\t\t.a5\n\t\u0005u\u0017q\\\u0001\ngR\u0014X-Y7j]\u001eTA!a6\u0002Z&!\u00111]As\u0003A1\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cWM\u0003\u0003\u0002^\u0006}\u0017\u0002BAu\u0003W\u0014\u0011\u0002V5nKN$\u0018-\u001c9\u000b\t\u0005\r\u0018Q\u001d\u0005\u0006uj\u0001\ra_\u0001\u0007i>,8\r\u001b>\u0015\t\u0005M\u0018q \t\u0007\u0003k\fY0a\u0002\u000e\u0005\u0005](bAA}[\u0005!Q\u000f^5m\u0013\u0011\ti0a>\u0003\u0007Q\u0013\u0018\u0010C\u0003{7\u0001\u000710A\u0003u_V\u001c\u0007\u000e\u0006\u0003\u0002t\n\u0015\u0001\"\u0002>\u001d\u0001\u0004Y\u0018!B;ou&\u0004HCBAz\u0005\u0017\u0011y\u0001\u0003\u0004\u0003\u000eu\u0001\ra_\u0001\u000bg>,(oY3GS2,\u0007B\u0002B\t;\u0001\u000710A\u0005uCJ<W\r\u001e#je\u0002")
public class HdfsStorageHandler
implements StorageHandler {
    private Option<String> normalizedFileSystem;
    private Option<String> fileSystem;
    private final Settings settings;
    private final Configuration conf;
    private final FileSystem fs;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public String list$default$2() {
        return StorageHandler.list$default$2$(this);
    }

    @Override
    public LocalDateTime list$default$3() {
        return StorageHandler.list$default$3$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Configuration conf() {
        return this.conf;
    }

    private Option<String> normalizedFileSystem$lzycompute() {
        HdfsStorageHandler hdfsStorageHandler = this;
        synchronized (hdfsStorageHandler) {
            if (!this.bitmap$0) {
                this.normalizedFileSystem = this.fileSystem.map((Function1 & Serializable & scala.Serializable)fs -> fs.endsWith(":") ? new StringBuilder(3).append((String)fs).append("///").toString() : (!fs.endsWith("://") && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(fs)).last()) == '/' ? (String)new StringOps(Predef$.MODULE$.augmentString(fs)).dropRight(1) : (fs.endsWith("://") ? new StringBuilder(2).append((String)fs).append("/.").toString() : fs)));
                this.bitmap$0 = true;
            }
        }
        this.fileSystem = null;
        return this.normalizedFileSystem;
    }

    public Option<String> normalizedFileSystem() {
        return !this.bitmap$0 ? this.normalizedFileSystem$lzycompute() : this.normalizedFileSystem;
    }

    @Override
    public FiniteDuration lockAcquisitionPollTime() {
        return this.settings.comet().lock().pollTime();
    }

    @Override
    public FiniteDuration lockRefreshPollTime() {
        return this.settings.comet().lock().refreshTime();
    }

    public FileSystem fs() {
        return this.fs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FSDataOutputStream getOutputStream(Path path) {
        void var2_2;
        this.fs().delete(path, false);
        FSDataOutputStream outputStream = this.fs().create(path);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String read(Path path) {
        void var3_3;
        FSDataInputStream stream = this.fs().open(path);
        String content = IOUtils.toString((InputStream)stream, (String)"UTF-8");
        return var3_3;
    }

    @Override
    public void write(String data, Path path) {
        FSDataOutputStream os = this.getOutputStream(path);
        os.writeBytes(data);
        os.close();
    }

    public void writeBinary(byte[] data, Path path) {
        FSDataOutputStream os = this.getOutputStream(path);
        os.write(data, 0, data.length);
        os.close();
    }

    @Override
    public List<Path> listDirectories(Path path) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fs().listStatus(path))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory())))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).toList();
    }

    @Override
    public List<Path> list(Path path, String extension, LocalDateTime since, boolean recursive) {
        List list;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("list({}, {}, {})", new Object[]{path, extension, since});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            RemoteIterator iterator = this.fs().listFiles(path, recursive);
            return (List)((List)Conversions$.MODULE$.convertToScalaIterator(iterator).filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$list$2(this, since, extension, status))).toList().sortBy((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)BoxesRunTime.boxToLong((long)r.getModificationTime()), (Object)r.getPath().getName()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable & scala.Serializable)status -> status.getPath(), List$.MODULE$.canBuildFrom());
        });
        if (try_ instanceof Success) {
            List list2;
            Success success = (Success)try_;
            list = list2 = (List)success.value();
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(16).append("Ignoring folder ").append(path).toString(), e);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            list = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return list;
    }

    @Override
    public boolean move(Path path, Path dest) {
        this.delete(dest);
        this.mkdirs(dest.getParent());
        return this.fs().rename(path, dest);
    }

    @Override
    public boolean delete(Path path) {
        return this.fs().delete(path, true);
    }

    @Override
    public boolean mkdirs(Path path) {
        return this.fs().mkdirs(path);
    }

    @Override
    public void copyFromLocal(Path source, Path dest) {
        this.fs().copyFromLocalFile(source, dest);
    }

    @Override
    public void moveFromLocal(Path source, Path dest) {
        String string = this.fs().getScheme();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.fs().moveFromLocalFile(source, dest);
        } else {
            this.move(source, dest);
        }
    }

    @Override
    public boolean exists(Path path) {
        return this.fs().exists(path);
    }

    @Override
    public long blockSize(Path path) {
        return this.fs().getDefaultBlockSize(path);
    }

    @Override
    public ContentSummary contentSummary(Path path) {
        return this.fs().getContentSummary(path);
    }

    @Override
    public long spaceConsumed(Path path) {
        return this.contentSummary(path).getSpaceConsumed();
    }

    @Override
    public long lastModified(Path path) {
        return this.fs().getFileStatus(path).getModificationTime();
    }

    @Override
    public Try<BoxedUnit> touchz(Path path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fs().create(path, false).close());
    }

    @Override
    public Try<BoxedUnit> touch(Path path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fs().setTimes(path, System.currentTimeMillis(), -1L));
    }

    @Override
    public Try<BoxedUnit> unzip(Path sourceFile, Path targetDir) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!this.fs().exists(sourceFile)) {
                throw new Exception(new StringBuilder(15).append(sourceFile.toString()).append(" does not exist").toString());
            }
            FSDataInputStream fsInputStream = this.fs().open(sourceFile);
            ZipInputStream zipInputStream = new ZipInputStream((InputStream)fsInputStream);
            package$.MODULE$.Stream().continually((Function0 & Serializable & scala.Serializable)() -> zipInputStream.getNextEntry()).takeWhile((Function1 & Serializable & scala.Serializable)ze -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$unzip$3(ze))).foreach((Function1 & Serializable & scala.Serializable)zipEntry -> {
                HdfsStorageHandler.$anonfun$unzip$4(zipInputStream, zipEntry);
                return BoxedUnit.UNIT;
            });
            zipInputStream.close();
        });
    }

    public static final /* synthetic */ void $anonfun$new$1(HdfsStorageHandler $this, String fs) {
        $this.conf().set("fs.defaultFS", fs);
    }

    public static final /* synthetic */ void $anonfun$new$2(HdfsStorageHandler $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        $this.conf().set(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$list$2(HdfsStorageHandler $this, LocalDateTime since$1, String extension$1, LocatedFileStatus status) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("found file={}", new Object[]{status});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LocalDateTime time = LocalDateTime.ofInstant(Instant.ofEpochMilli(status.getModificationTime()), ZoneId.systemDefault());
        return time.isAfter(since$1) && status.getPath().getName().endsWith(extension$1);
    }

    public static final /* synthetic */ boolean $anonfun$unzip$3(ZipEntry ze) {
        return ze != null && !ze.isDirectory();
    }

    public static final /* synthetic */ void $anonfun$unzip$4(ZipInputStream zipInputStream$1, ZipEntry zipEntry) {
        String string = zipEntry.getName();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int bytesRead = zipInputStream$1.read(buf, 0, 4096);
        while (bytesRead > -1) {
            outputStream.write(buf, 0, bytesRead);
            bytesRead = zipInputStream$1.read(buf, 0, 4096);
        }
        outputStream.close();
        zipInputStream$1.closeEntry();
    }

    public HdfsStorageHandler(Option<String> fileSystem, Settings settings) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        this.fileSystem = fileSystem;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        this.conf = new Configuration();
        this.normalizedFileSystem().foreach((Function1 & Serializable & scala.Serializable)fs -> {
            HdfsStorageHandler.$anonfun$new$1(this, fs);
            return BoxedUnit.UNIT;
        });
        ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(settings.comet().hadoop()).asScala()).toMap(Predef$.MODULE$.$conforms()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HdfsStorageHandler.$anonfun$new$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.fs = FileSystem.get((Configuration)this.conf());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(3).append("fs=").append(this.fs()).toString());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(20).append("fs.getHomeDirectory=").append(this.fs().getHomeDirectory()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(10).append("fs.getUri=").append(this.fs().getUri()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

