/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.utils;

import com.ebiznext.comet.schema.handlers.StorageHandler;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0011#\u0001-B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\")\u0001\u000b\u0001C\u0001#\")a\u000b\u0001C\u0001/\")1\f\u0001C\u0001/\"9A\f\u0001b\u0001\n\u0013i\u0006bBA\u0016\u0001\u0001\u0006IA\u0018\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011%\t\u0019\u0007AI\u0001\n\u0003\t)\u0007C\u0004\u0002\u0000\u0001!\t!!!\t\u0013\u0005E\u0005!%A\u0005\u0002\u0005M\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\n\u0003G\u0003\u0011\u0013!C\u0001\u0003OBq!a\n\u0001\t\u0003\ti\u0001C\u0004\u0002&\u0002!I!!\u0004\b\u000b\u0001\u0014\u0003\u0012A1\u0007\u000b\u0005\u0012\u0003\u0012\u00012\t\u000bA\u000bB\u0011A2\u0007\t\u0011\fB!\u001a\u0005\tuM\u0011\t\u0011)A\u0005w!Aqi\u0005B\u0001B\u0003%\u0001\n\u0003\u0005r'\t\u0005\t\u0015!\u0003Y\u0011\u0015\u00016\u0003\"\u0001s\u0011\u001dA8C1A\u0005\neDq!!\u0003\u0014A\u0003%!\u0010C\u0004\u0002\fM!\t!!\u0004\t\u0011\u0005U1C1A\u0005\neDq!a\u0006\u0014A\u0003%!\u0010C\u0005\u0002\u001aM\u0011\r\u0011\"\u0003\u0002\u001c!A\u0011QE\n!\u0002\u0013\ti\u0002C\u0004\u0002(M!\t!!\u0004\t\u000f\u0005%2\u0003\"\u0011\u0002\u000e\tAa)\u001b7f\u0019>\u001c7N\u0003\u0002$I\u0005)Q\u000f^5mg*\u0011QEJ\u0001\u0006G>lW\r\u001e\u0006\u0003O!\n\u0001\"\u001a2ju:,\u0007\u0010\u001e\u0006\u0002S\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00028Q\u0005AA/\u001f9fg\u00064W-\u0003\u0002:i\ti1\u000b\u001e:jGRdunZ4j]\u001e\fA\u0001]1uQB\u0011A(R\u0007\u0002{)\u0011ahP\u0001\u0003MNT!\u0001Q!\u0002\r!\fGm\\8q\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\n\u0005\u0019k$\u0001\u0002)bi\"\fab\u001d;pe\u0006<W\rS1oI2,'\u000f\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006A\u0001.\u00198eY\u0016\u00148O\u0003\u0002NI\u000511o\u00195f[\u0006L!a\u0014&\u0003\u001dM#xN]1hK\"\u000bg\u000e\u001a7fe\u00061A(\u001b8jiz\"2A\u0015+V!\t\u0019\u0006!D\u0001#\u0011\u0015Q4\u00011\u0001<\u0011\u001595\u00011\u0001I\u00035\u0019\u0007.Z2lS:\u0004VM]5pIV\t\u0001\f\u0005\u0002.3&\u0011!L\f\u0002\u0005\u0019>tw-A\u0007sK\u001a\u0014Xm\u001d5QKJLw\u000eZ\u0001\fM&dWmV1uG\",'/F\u0001_!\ty6C\u0004\u0002T!\u0005Aa)\u001b7f\u0019>\u001c7\u000e\u0005\u0002T#M\u0011\u0011\u0003\f\u000b\u0002C\nYAj\\2l/\u0006$8\r[3s'\u0011\u0019bM\u001c\u001a\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001\u00027b]\u001eT\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\n1qJ\u00196fGR\u0004\"aZ8\n\u0005AD'\u0001\u0003*v]:\f'\r\\3\u0002\u001fI,\u0007o\u001c:uS:<\u0007+\u001a:j_\u0012$Ba];woB\u0011AoE\u0007\u0002#!)!h\u0006a\u0001w!)qi\u0006a\u0001\u0011\")\u0011o\u0006a\u00011\u0006A\u0001O]5ti&tW-F\u0001{!\rY\u0018QA\u0007\u0002y*\u0011QP`\u0001\u0007CR|W.[2\u000b\u0007}\f\t!\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\u0001k\u0003\u0011)H/\u001b7\n\u0007\u0005\u001dAPA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\naJL7\u000f^5oK\u0002\nQb\u00195fG.\u0004&/[:uS:,GCAA\b!\ri\u0013\u0011C\u0005\u0004\u0003'q#\u0001B+oSR\fQa\u001d9f]R\faa\u001d9f]R\u0004\u0013aA:f[V\u0011\u0011Q\u0004\t\u0005\u0003?\t\t#D\u0001\u007f\u0013\r\t\u0019C \u0002\n'\u0016l\u0017\r\u001d5pe\u0016\fAa]3nA\u00059!/\u001a7fCN,\u0017a\u0001:v]\u0006aa-\u001b7f/\u0006$8\r[3sA\u0005qAO]=Fq\u000edWo]5wK2LX\u0003BA\u0019\u0003\u0007\"B!a\r\u0002`Q!\u0011QGA+!\u0019\t9$a\u000f\u0002@5\u0011\u0011\u0011\b\u0006\u0004\u0003\u0007q\u0013\u0002BA\u001f\u0003s\u00111\u0001\u0016:z!\u0011\t\t%a\u0011\r\u0001\u00119\u0011Q\t\u0005C\u0002\u0005\u001d#!\u0001+\u0012\t\u0005%\u0013q\n\t\u0004[\u0005-\u0013bAA']\t9aj\u001c;iS:<\u0007cA\u0017\u0002R%\u0019\u00111\u000b\u0018\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002X!!\t\u0019AA-\u0003\ty\u0007\u000fE\u0003.\u00037\ny$C\u0002\u0002^9\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\t\u0003CB\u0001\u0013!a\u00011\u0006yA/[7f_V$\u0018J\\'jY2L7/\u0001\ruef,\u0005p\u00197vg&4X\r\\=%I\u00164\u0017-\u001e7uIE*B!a\u001a\u0002~U\u0011\u0011\u0011\u000e\u0016\u00041\u0006-4FAA7!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]d&\u0001\u0006b]:|G/\u0019;j_:LA!a\u001f\u0002r\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005\u0015\u0013B1\u0001\u0002H\u0005iAm\\#yG2,8/\u001b<fYf,B!a!\u0002\nR!\u0011QQAH)\u0011\t9)a#\u0011\t\u0005\u0005\u0013\u0011\u0012\u0003\b\u0003\u000bR!\u0019AA$\u0011!\t9F\u0003CA\u0002\u00055\u0005#B\u0017\u0002\\\u0005\u001d\u0005\u0002CA1\u0015A\u0005\t\u0019\u0001-\u0002/\u0011|W\t_2mkNLg/\u001a7zI\u0011,g-Y;mi\u0012\nT\u0003BA4\u0003+#q!!\u0012\f\u0005\u0004\t9%A\u0004uefdunY6\u0015\t\u0005m\u0015\u0011\u0015\t\u0004[\u0005u\u0015bAAP]\t9!i\\8mK\u0006t\u0007\u0002CA1\u0019A\u0005\t\u0019\u0001-\u0002#Q\u0014\u0018\u0010T8dW\u0012\"WMZ1vYR$\u0013'A\u0003xCR\u001c\u0007\u000e")
public class FileLock
implements StrictLogging {
    private final Path path;
    private final StorageHandler storageHandler;
    private final LockWatcher fileWatcher;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public long checkinPeriod() {
        return this.storageHandler.lockAcquisitionPollTime().toMillis();
    }

    public long refreshPeriod() {
        return this.storageHandler.lockRefreshPollTime().toMillis();
    }

    private LockWatcher fileWatcher() {
        return this.fileWatcher;
    }

    public <T> Try<T> tryExclusively(long timeoutInMillis, Function0<T> op) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.doExclusively(timeoutInMillis, op));
    }

    public <T> long tryExclusively$default$1() {
        return -1L;
    }

    public <T> T doExclusively(long timeoutInMillis, Function0<T> op) {
        Object object;
        if (this.tryLock(timeoutInMillis)) {
            try {
                object = op.apply();
            }
            finally {
                this.release();
            }
        } else {
            throw new TimeoutException(new StringBuilder(47).append("Failed to obtain lock on file ").append(this.path).append(" waited (millis) ").append(timeoutInMillis).toString());
        }
        return (T)object;
    }

    public <T> long doExclusively$default$1() {
        return -1L;
    }

    public boolean tryLock(long timeoutInMillis) {
        BoxedUnit boxedUnit;
        int maxTries;
        this.fileWatcher().checkPristine();
        this.storageHandler.mkdirs(this.path.getParent());
        int n = maxTries = timeoutInMillis == -1L ? Integer.MAX_VALUE : (int)(timeoutInMillis / this.checkinPeriod());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Trying to acquire lock for file {} during {} ms", new Object[]{this.path.toString(), BoxesRunTime.boxToLong((long)timeoutInMillis)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.getLock$1(maxTries);
    }

    public long tryLock$default$1() {
        return -1L;
    }

    public void release() {
        this.fileWatcher().release();
    }

    private void watch() {
        Thread th = new Thread((Runnable)this.fileWatcher(), new StringBuilder(13).append("LockWatcher-").append(System.currentTimeMillis()).append("-").append(this.path.toString()).toString());
        th.start();
    }

    private final boolean getLock$1(int numberOfTries) {
        boolean bl;
        block9: {
            block10: {
                Try<BoxedUnit> try_;
                while (true) {
                    Object object;
                    if (numberOfTries == 0) {
                        bl = false;
                        break block9;
                    }
                    try_ = this.storageHandler.touchz(this.path);
                    if (try_ instanceof Success) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Succeeded to acquire lock for file {} after {} tries", new Object[]{this.path.toString(), BoxesRunTime.boxToInteger((int)numberOfTries)});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block10;
                    }
                    if (!(try_ instanceof Failure)) break;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    e.printStackTrace();
                    if (this.storageHandler.exists(this.path)) {
                        BoxedUnit boxedUnit;
                        long lastModified = this.storageHandler.lastModified(this.path);
                        long currentTimeMillis = System.currentTimeMillis();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("\n               |lastModified={}\n\n              |System.currentTimeMillis()={}\n\n              |checkinPeriod*4={}\n\n               hPeriod*4={}\n              |\n          ", new Object[]{BoxesRunTime.boxToLong((long)lastModified), BoxesRunTime.boxToLong((long)currentTimeMillis), BoxesRunTime.boxToLong((long)(this.checkinPeriod() * 4L)), BoxesRunTime.boxToLong((long)(this.refreshPeriod() * 4L))});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = currentTimeMillis - lastModified > this.refreshPeriod() * 4L ? BoxesRunTime.boxToBoolean((boolean)this.storageHandler.delete(this.path)) : BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    Thread.sleep(this.checkinPeriod());
                    --numberOfTries;
                }
                throw new MatchError(try_);
            }
            this.watch();
            boolean bl2 = true;
            bl = bl2;
        }
        return bl;
    }

    public FileLock(Path path, StorageHandler storageHandler) {
        this.path = path;
        this.storageHandler = storageHandler;
        StrictLogging.$init$((StrictLogging)this);
        this.fileWatcher = new LockWatcher(path, storageHandler, this.refreshPeriod());
    }

    public static class LockWatcher
    implements Runnable,
    StrictLogging {
        private final Path path;
        private final StorageHandler storageHandler;
        private final long reportingPeriod;
        private final AtomicBoolean pristine;
        private final AtomicBoolean spent;
        private final Semaphore sem;
        private final Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        private AtomicBoolean pristine() {
            return this.pristine;
        }

        public void checkPristine() {
            boolean wasPristine = this.pristine().getAndSet(false);
            if (!wasPristine) {
                throw new IllegalStateException(new StringBuilder(58).append("FileLock instance on ").append(this.path).append(" had already been used, cannot re-use").toString());
            }
        }

        private AtomicBoolean spent() {
            return this.spent;
        }

        private Semaphore sem() {
            return this.sem;
        }

        public void release() {
            boolean wasAlreadySpent = this.spent().getAndSet(true);
            if (wasAlreadySpent) {
                throw new IllegalStateException(new StringBuilder(58).append("LockWatcher thread on ").append(this.path).append(" already spent, cannot release again").toString());
            }
            this.sem().release();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    BoxedUnit boxedUnit;
                    if (this.sem().tryAcquire(this.reportingPeriod, TimeUnit.MILLISECONDS)) {
                        this.storageHandler.delete(this.path);
                        return;
                    }
                    this.storageHandler.touch(this.path);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("watcher {} modified={}", new Object[]{this.path, BoxesRunTime.boxToLong((long)this.storageHandler.lastModified(this.path))});
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }

        public LockWatcher(Path path, StorageHandler storageHandler, long reportingPeriod) {
            this.path = path;
            this.storageHandler = storageHandler;
            this.reportingPeriod = reportingPeriod;
            StrictLogging.$init$((StrictLogging)this);
            this.pristine = new AtomicBoolean(true);
            this.spent = new AtomicBoolean(false);
            this.sem = new Semaphore(0);
        }
    }
}

