/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.utils.repackaged;

import com.ebiznext.comet.utils.repackaged.SupportedCustomDataType;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;

public class BigQuerySchemaConverters {
    private static final int BQ_NUMERIC_PRECISION = 38;
    private static final int BQ_NUMERIC_SCALE = 9;
    private static final DecimalType NUMERIC_SPARK_TYPE = DataTypes.createDecimalType((int)38, (int)9);
    private static final int MAX_BIGQUERY_NESTED_DEPTH = 15;
    private static final String MAPTYPE_ERROR_MESSAGE = "MapType is unsupported.";

    public static StructType toSpark(Schema schema) {
        List<StructField> list = schema.getFields().stream().map(BigQuerySchemaConverters::convert).collect(Collectors.toList());
        StructType structType = new StructType(list.toArray(new StructField[0]));
        return structType;
    }

    public static InternalRow convertToInternalRow(Schema schema, List<String> list, GenericRecord genericRecord) {
        return BigQuerySchemaConverters.convertAll(schema.getFields(), genericRecord, list);
    }

    static Object convert(Field field, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (field.getMode() == Field.Mode.REPEATED) {
            LegacySQLTypeName legacySQLTypeName = LegacySQLTypeName.valueOfStrict((String)field.getType().name());
            Field field2 = Field.newBuilder((String)field.getName(), (LegacySQLTypeName)legacySQLTypeName, (FieldList)field.getSubFields()).setMode(Field.Mode.REQUIRED).build();
            List list = (List)object2;
            return new GenericArrayData(list.stream().map(object -> BigQuerySchemaConverters.convert(field2, object)).collect(Collectors.toList()));
        }
        Object object3 = BigQuerySchemaConverters.convertByBigQueryType(field, object2);
        Optional<Object> optional = BigQuerySchemaConverters.getCustomDataType(field).map(dataType -> ((UserDefinedType)dataType).deserialize(object3));
        return optional.orElse(object3);
    }

    static Object convertByBigQueryType(Field field2, Object object) {
        if (LegacySQLTypeName.INTEGER.equals((Object)field2.getType()) || LegacySQLTypeName.FLOAT.equals((Object)field2.getType()) || LegacySQLTypeName.BOOLEAN.equals((Object)field2.getType()) || LegacySQLTypeName.DATE.equals((Object)field2.getType()) || LegacySQLTypeName.TIME.equals((Object)field2.getType()) || LegacySQLTypeName.TIMESTAMP.equals((Object)field2.getType())) {
            return object;
        }
        if (LegacySQLTypeName.STRING.equals((Object)field2.getType()) || LegacySQLTypeName.DATETIME.equals((Object)field2.getType()) || LegacySQLTypeName.GEOGRAPHY.equals((Object)field2.getType())) {
            return UTF8String.fromBytes((byte[])((Utf8)object).getBytes());
        }
        if (LegacySQLTypeName.BYTES.equals((Object)field2.getType())) {
            return BigQuerySchemaConverters.getBytes((ByteBuffer)object);
        }
        if (LegacySQLTypeName.NUMERIC.equals((Object)field2.getType())) {
            byte[] byArray = BigQuerySchemaConverters.getBytes((ByteBuffer)object);
            BigDecimal bigDecimal = new BigDecimal(new BigInteger(byArray), 9);
            Decimal decimal = Decimal.apply((BigDecimal)bigDecimal, (int)38, (int)9);
            return decimal;
        }
        if (LegacySQLTypeName.RECORD.equals((Object)field2.getType())) {
            return BigQuerySchemaConverters.convertAll(field2.getSubFields(), (GenericRecord)object, field2.getSubFields().stream().map(field -> field.getName()).collect(Collectors.toList()));
        }
        throw new IllegalStateException("Unexpected type: " + field2.getType());
    }

    private static byte[] getBytes(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    static GenericInternalRow convertAll(FieldList fieldList, GenericRecord genericRecord, List<String> list) {
        HashMap hashMap = new HashMap();
        fieldList.stream().forEach(field -> hashMap.put(field.getName(), BigQuerySchemaConverters.convert(field, genericRecord.get(field.getName()))));
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = hashMap.get(list.get(i));
        }
        return new GenericInternalRow(objectArray);
    }

    private static StructField convert(Field field) {
        DataType dataType = BigQuerySchemaConverters.getDataType(field);
        boolean bl = true;
        if (field.getMode() == Field.Mode.REQUIRED) {
            bl = false;
        } else if (field.getMode() == Field.Mode.REPEATED) {
            dataType = new ArrayType(dataType, true);
        }
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        if (field.getDescription() != null) {
            metadataBuilder.putString("description", field.getDescription());
        }
        return new StructField(field.getName(), dataType, bl, metadataBuilder.build());
    }

    private static DataType getDataType(Field field) {
        return BigQuerySchemaConverters.getCustomDataType(field).orElseGet(() -> BigQuerySchemaConverters.getStandardDataType(field));
    }

    @VisibleForTesting
    static Optional<DataType> getCustomDataType(Field field) {
        String string = field.getDescription();
        if (string != null && LegacySQLTypeName.RECORD.equals((Object)field.getType())) {
            return SupportedCustomDataType.forDescription(string).map(SupportedCustomDataType::getSparkDataType);
        }
        return Optional.empty();
    }

    private static DataType getStandardDataType(Field field) {
        if (LegacySQLTypeName.INTEGER.equals((Object)field.getType())) {
            return DataTypes.LongType;
        }
        if (LegacySQLTypeName.FLOAT.equals((Object)field.getType())) {
            return DataTypes.DoubleType;
        }
        if (LegacySQLTypeName.NUMERIC.equals((Object)field.getType())) {
            return NUMERIC_SPARK_TYPE;
        }
        if (LegacySQLTypeName.STRING.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        if (LegacySQLTypeName.BOOLEAN.equals((Object)field.getType())) {
            return DataTypes.BooleanType;
        }
        if (LegacySQLTypeName.BYTES.equals((Object)field.getType())) {
            return DataTypes.BinaryType;
        }
        if (LegacySQLTypeName.DATE.equals((Object)field.getType())) {
            return DataTypes.DateType;
        }
        if (LegacySQLTypeName.TIMESTAMP.equals((Object)field.getType())) {
            return DataTypes.TimestampType;
        }
        if (LegacySQLTypeName.TIME.equals((Object)field.getType())) {
            return DataTypes.LongType;
        }
        if (LegacySQLTypeName.DATETIME.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        if (LegacySQLTypeName.RECORD.equals((Object)field.getType())) {
            List<StructField> list = field.getSubFields().stream().map(BigQuerySchemaConverters::convert).collect(Collectors.toList());
            return new StructType(list.toArray(new StructField[0]));
        }
        if (LegacySQLTypeName.GEOGRAPHY.equals((Object)field.getType())) {
            return DataTypes.StringType;
        }
        throw new IllegalStateException("Unexpected type: " + field.getType());
    }

    public static Schema toBigQuerySchema(StructType structType) {
        FieldList fieldList = BigQuerySchemaConverters.sparkToBigQueryFields(structType, 0);
        return Schema.of((Iterable)fieldList);
    }

    private static FieldList sparkToBigQueryFields(StructType structType, int n) {
        Preconditions.checkArgument((n < 15 ? 1 : 0) != 0, (Object)"Spark Schema exceeds BigQuery maximum nesting depth.");
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (StructField structField : structType.fields()) {
            arrayList.add(BigQuerySchemaConverters.createBigQueryColumn(structField, n));
        }
        return FieldList.of(arrayList);
    }

    @VisibleForTesting
    protected static Field createBigQueryColumn(StructField structField, int n) {
        String string;
        LegacySQLTypeName legacySQLTypeName;
        DataType dataType = structField.dataType();
        String string2 = structField.name();
        Field.Mode mode = structField.nullable() ? Field.Mode.NULLABLE : Field.Mode.REQUIRED;
        FieldList fieldList = null;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            mode = Field.Mode.REPEATED;
            dataType = arrayType.elementType();
        }
        if (dataType instanceof StructType) {
            fieldList = BigQuerySchemaConverters.sparkToBigQueryFields((StructType)dataType, n + 1);
            legacySQLTypeName = LegacySQLTypeName.RECORD;
        } else {
            legacySQLTypeName = BigQuerySchemaConverters.toBigQueryType(dataType);
        }
        try {
            string = structField.metadata().getString("comment");
        }
        catch (NoSuchElementException noSuchElementException) {
            return BigQuerySchemaConverters.createBigQueryFieldBuilder(string2, legacySQLTypeName, mode, fieldList).build();
        }
        return BigQuerySchemaConverters.createBigQueryFieldBuilder(string2, legacySQLTypeName, mode, fieldList).setDescription(string).build();
    }

    @VisibleForTesting
    protected static LegacySQLTypeName toBigQueryType(DataType dataType) {
        if (dataType instanceof BinaryType) {
            return LegacySQLTypeName.BYTES;
        }
        if (dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType) {
            return LegacySQLTypeName.INTEGER;
        }
        if (dataType instanceof BooleanType) {
            return LegacySQLTypeName.BOOLEAN;
        }
        if (dataType instanceof FloatType || dataType instanceof DoubleType) {
            return LegacySQLTypeName.FLOAT;
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            if (decimalType.precision() <= 38 && decimalType.scale() <= 9) {
                return LegacySQLTypeName.NUMERIC;
            }
            throw new IllegalArgumentException("Decimal type is too wide to fit in BigQuery Numeric format");
        }
        if (dataType instanceof StringType) {
            return LegacySQLTypeName.STRING;
        }
        if (dataType instanceof TimestampType) {
            return LegacySQLTypeName.TIMESTAMP;
        }
        if (dataType instanceof DateType) {
            return LegacySQLTypeName.DATE;
        }
        if (dataType instanceof MapType) {
            throw new IllegalArgumentException(MAPTYPE_ERROR_MESSAGE);
        }
        throw new IllegalArgumentException("Data type not expected: " + dataType.simpleString());
    }

    private static Field.Builder createBigQueryFieldBuilder(String string, LegacySQLTypeName legacySQLTypeName, Field.Mode mode, FieldList fieldList) {
        return Field.newBuilder((String)string, (LegacySQLTypeName)legacySQLTypeName, (FieldList)fieldList).setMode(mode);
    }
}

