/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import com.ebiznext.comet.utils.Utils$;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JsonIngestionUtil$ {
    public static JsonIngestionUtil$ MODULE$;
    private final Comparator<StructField> structFieldComparator;
    private final Function2<DataType, DataType, Option<DataType>> findTightestCommonTypeOfTwo;
    private final JsonFactory factory;

    static {
        new JsonIngestionUtil$();
    }

    public List<String> compareTypes(DataType schemaType, DataType datasetType) {
        return this.compareTypes((List<String>)Nil$.MODULE$, (Tuple3<String, DataType, Object>)new Tuple3((Object)"root", (Object)schemaType, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (Tuple3<String, DataType, Object>)new Tuple3((Object)"root", (Object)datasetType, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public List<String> compareTypes(List<String> context, Tuple3<String, DataType, Object> schemaType, Tuple3<String, DataType, Object> datasetType) {
        Nil$ nil$;
        block22: {
            Tuple2 tuple2;
            boolean datasetAttrNullable;
            DataType datasetAttrType;
            String datasetAttrName;
            boolean schemaAttrNullable;
            DataType schemaAttrType;
            String schemaAttrName;
            while (true) {
                DataType dataType;
                Tuple3 tuple3;
                if ((tuple3 = schemaType) == null) {
                    throw new MatchError(tuple3);
                }
                String schemaAttrName2 = (String)tuple3._1();
                DataType schemaAttrType2 = (DataType)tuple3._2();
                boolean schemaAttrNullable2 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                Tuple3 tuple32 = new Tuple3((Object)schemaAttrName2, (Object)schemaAttrType2, (Object)BoxesRunTime.boxToBoolean((boolean)schemaAttrNullable2));
                Tuple3 tuple33 = tuple32;
                schemaAttrName = (String)tuple33._1();
                schemaAttrType = (DataType)tuple33._2();
                schemaAttrNullable = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
                Tuple3 tuple34 = datasetType;
                if (tuple34 == null) {
                    throw new MatchError(tuple34);
                }
                String datasetAttrName2 = (String)tuple34._1();
                DataType datasetAttrType2 = (DataType)tuple34._2();
                boolean datasetAttrNullable2 = BoxesRunTime.unboxToBoolean((Object)tuple34._3());
                Tuple3 tuple35 = new Tuple3((Object)datasetAttrName2, (Object)datasetAttrType2, (Object)BoxesRunTime.boxToBoolean((boolean)datasetAttrNullable2));
                Tuple3 tuple36 = tuple35;
                datasetAttrName = (String)tuple36._1();
                datasetAttrType = (DataType)tuple36._2();
                datasetAttrNullable = BoxesRunTime.unboxToBoolean((Object)tuple36._3());
                boolean schemaTypeNullable = schemaAttrNullable;
                tuple2 = new Tuple2((Object)schemaAttrType, (Object)datasetAttrType);
                if (tuple2 != null) {
                    DataType t1 = (DataType)tuple2._1();
                    DataType t2 = (DataType)tuple2._2();
                    DataType dataType2 = t1;
                    DataType dataType3 = t2;
                    if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
                        nil$ = Nil$.MODULE$;
                        break block22;
                    }
                }
                if (tuple2 != null && NullType$.MODULE$.equals(dataType = (DataType)tuple2._2()) && schemaTypeNullable) {
                    nil$ = Nil$.MODULE$;
                    break block22;
                }
                if (tuple2 != null && tuple2._1() instanceof IntegralType && tuple2._2() instanceof IntegralType) {
                    nil$ = Nil$.MODULE$;
                    break block22;
                }
                if (tuple2 != null && tuple2._1() instanceof FractionalType && tuple2._2() instanceof IntegralType) {
                    nil$ = Nil$.MODULE$;
                    break block22;
                }
                if (tuple2 != null && tuple2._1() instanceof FractionalType && tuple2._2() instanceof FractionalType) {
                    nil$ = Nil$.MODULE$;
                    break block22;
                }
                boolean bl = tuple2 != null && tuple2._1() instanceof TimestampType && tuple2._2() instanceof DateType ? true : tuple2 != null && tuple2._1() instanceof DateType && tuple2._2() instanceof TimestampType;
                if (bl) {
                    nil$ = Nil$.MODULE$;
                    break block22;
                }
                boolean bl2 = tuple2 != null && tuple2._1() instanceof TimestampType ? true : tuple2 != null && tuple2._1() instanceof DateType;
                if (bl2) {
                    nil$ = Nil$.MODULE$;
                    break block22;
                }
                if (tuple2 != null && tuple2._1() instanceof StringType && tuple2._2() instanceof StringType) {
                    nil$ = Nil$.MODULE$;
                    break block22;
                }
                if (tuple2 != null) {
                    DataType dataType4 = (DataType)tuple2._1();
                    DataType dataType5 = (DataType)tuple2._2();
                    if (dataType4 instanceof StructType) {
                        StructType structType = (StructType)dataType4;
                        StructField[] unsortedFields1 = structType.fields();
                        if (dataType5 instanceof StructType) {
                            StructType structType2 = (StructType)dataType5;
                            StructField[] unsortedFields2 = structType2.fields();
                            StructField[] fields1 = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unsortedFields1)).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), (Ordering)Ordering.String$.MODULE$);
                            StructField[] fields2 = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unsortedFields2)).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), (Ordering)Ordering.String$.MODULE$);
                            MutableList errorList = (MutableList)MutableList$.MODULE$.empty();
                            int f1Idx = 0;
                            int f2Idx = 0;
                            boolean typeComp = true;
                            while (f1Idx < fields1.length && f2Idx < fields2.length && typeComp) {
                                StructField f1 = fields1[f1Idx];
                                StructField f2 = fields2[f2Idx];
                                int nameComp = f1.name().compareTo(f2.name());
                                if (nameComp < 0 && f1.nullable()) {
                                    ++f1Idx;
                                    continue;
                                }
                                if (nameComp == 0) {
                                    DataType f1Type = f1.dataType();
                                    DataType f2Type = f2.dataType();
                                    errorList.$plus$plus$eq(this.compareTypes((List<String>)((List)context.$colon$plus((Object)schemaAttrName, List$.MODULE$.canBuildFrom())), (Tuple3<String, DataType, Object>)new Tuple3((Object)f1.name(), (Object)f1Type, (Object)BoxesRunTime.boxToBoolean((boolean)f1.nullable())), (Tuple3<String, DataType, Object>)new Tuple3((Object)f2.name(), (Object)f2Type, (Object)BoxesRunTime.boxToBoolean((boolean)f2.nullable()))));
                                    ++f1Idx;
                                    ++f2Idx;
                                    typeComp = typeComp && errorList.isEmpty();
                                    continue;
                                }
                                this.addError((List<String>)context, (MutableList<String>)errorList, f2);
                                typeComp = false;
                            }
                            if (f1Idx == fields1.length) {
                                while (f2Idx < fields2.length) {
                                    StructField f2 = fields2[f2Idx];
                                    this.addError((List<String>)context, (MutableList<String>)errorList, f2);
                                    ++f2Idx;
                                }
                            }
                            nil$ = errorList.toList();
                            break block22;
                        }
                    }
                }
                if (tuple2 == null) break;
                DataType dataType6 = (DataType)tuple2._1();
                DataType dataType7 = (DataType)tuple2._2();
                if (!(dataType6 instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType6;
                DataType elementType1 = arrayType.elementType();
                boolean containsNull1 = arrayType.containsNull();
                if (!(dataType7 instanceof ArrayType)) break;
                ArrayType arrayType2 = (ArrayType)dataType7;
                DataType elementType2 = arrayType2.elementType();
                datasetType = new Tuple3((Object)schemaAttrName, (Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull1));
                schemaType = new Tuple3((Object)schemaAttrName, (Object)elementType1, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull1));
                context = (List)context.$colon$plus((Object)schemaAttrName, List$.MODULE$.canBuildFrom());
            }
            if (tuple2 != null) {
                nil$ = new .colon.colon((Object)new StringBuilder(73).append("Validation error in context: ").append(context.mkString(".")).append(", ").append(datasetAttrName).append(":").append(datasetAttrType).append(" isnullable:").append(datasetAttrNullable).append(" against ").append("schema ").append(schemaAttrName).append(":").append(schemaAttrType).append(" isnullable:").append(schemaAttrNullable).toString(), (List)Nil$.MODULE$);
            } else {
                throw new MatchError((Object)tuple2);
            }
        }
        return nil$;
    }

    private void addError(List<String> context, MutableList<String> errorList, StructField f2) {
        errorList.$plus$eq((Object)new StringBuilder(35).append(f2.name()).append(", ").append(f2.dataType().typeName()).append(", ").append(context.mkString(".")).append(", unknown field ").append(f2.name()).append(" : ").append(f2.dataType().typeName()).append(" in context ").append(context.mkString(".")).toString());
    }

    public Function2<DataType, DataType, Option<DataType>> findTightestCommonTypeOfTwo() {
        return this.findTightestCommonTypeOfTwo;
    }

    public DataType compatibleType(DataType t1, DataType t2) {
        return (DataType)((Option)this.findTightestCommonTypeOfTwo().apply((Object)t1, (Object)t2)).getOrElse(() -> JsonIngestionUtil$.$anonfun$compatibleType$1(t1, t2));
    }

    private Option<DataType> canonicalizeType(DataType tpe) {
        Object object;
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            object = this.canonicalizeType(elementType).map((Function1 & Serializable & scala.Serializable)canonicalType -> arrayType.copy(canonicalType, arrayType.copy$default$2()));
        } else {
            StructType structType;
            StructField[] fields;
            StructField[] canonicalFields;
            object = dataType instanceof StructType ? ((canonicalFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields()))).withFilter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)JsonIngestionUtil$.$anonfun$canonicalizeType$2(field))).flatMap((Function1 & Serializable & scala.Serializable)field -> Option$.MODULE$.option2Iterable(MODULE$.canonicalizeType(field.dataType()).map((Function1 & Serializable & scala.Serializable)canonicalType -> {
                DataType x$1 = canonicalType;
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$1, x$3, x$4);
            })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))).length > 0 ? new Some((Object)new StructType(canonicalFields)) : None$.MODULE$) : (NullType$.MODULE$.equals(dataType) ? new Some((Object)StringType$.MODULE$) : new Some((Object)dataType));
        }
        return object;
    }

    private StructType withCorruptField(StructType struct, String columnNameOfCorruptRecords) {
        StructType structType;
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])struct.fieldNames())).contains((Object)columnNameOfCorruptRecords)) {
            StructField structField = new StructField(columnNameOfCorruptRecords, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField[] newFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])struct.fields())).$plus$colon((Object)structField, ClassTag$.MODULE$.apply(StructField.class));
            Arrays.sort((Object[])newFields, this.structFieldComparator);
            structType = new StructType(newFields);
        } else {
            structType = struct;
        }
        return structType;
    }

    private Function2<DataType, DataType, DataType> compatibleRootType(String columnNameOfCorruptRecords, boolean shouldHandleCorruptRecord) {
        return (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType ty2 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType ty1 = arrayType.elementType();
                    return (DataType)MODULE$.compatibleRootType(columnNameOfCorruptRecords, shouldHandleCorruptRecord).apply((Object)ty1, (Object)ty2);
                }
            }
            if (tuple2 != null) {
                DataType ty1 = (DataType)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType ty2 = arrayType.elementType();
                    return (DataType)MODULE$.compatibleRootType(columnNameOfCorruptRecords, shouldHandleCorruptRecord).apply((Object)ty1, (Object)ty2);
                }
            }
            if (tuple2 != null) {
                DataType struct = (DataType)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                if (struct instanceof StructType) {
                    StructType structType = (StructType)struct;
                    if (NullType$.MODULE$.equals(dataType)) {
                        return structType;
                    }
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType struct = (DataType)tuple2._2();
                if (NullType$.MODULE$.equals(dataType) && struct instanceof StructType) {
                    StructType structType = (StructType)struct;
                    return structType;
                }
            }
            if (tuple2 != null) {
                DataType struct = (DataType)tuple2._1();
                DataType o = (DataType)tuple2._2();
                if (struct instanceof StructType) {
                    StructType structType = (StructType)struct;
                    if (!(o instanceof StructType) && shouldHandleCorruptRecord) {
                        return MODULE$.withCorruptField(structType, columnNameOfCorruptRecords);
                    }
                }
            }
            if (tuple2 != null) {
                DataType o = (DataType)tuple2._1();
                DataType struct = (DataType)tuple2._2();
                if (struct instanceof StructType) {
                    StructType structType = (StructType)struct;
                    if (!(o instanceof StructType) && shouldHandleCorruptRecord) {
                        return MODULE$.withCorruptField(structType, columnNameOfCorruptRecords);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            DataType ty1 = (DataType)tuple2._1();
            DataType ty2 = (DataType)tuple2._2();
            return MODULE$.compatibleType(ty1, ty2);
        };
    }

    public DataType inferSchema(JsonParser parser) {
        NullType$ nullType$;
        block20: {
            JsonToken jsonToken;
            while (true) {
                boolean bl;
                if (bl = (jsonToken = parser.getCurrentToken()) == null ? true : JsonToken.VALUE_NULL.equals(jsonToken)) {
                    nullType$ = NullType$.MODULE$;
                    break block20;
                }
                if (!JsonToken.FIELD_NAME.equals(jsonToken)) break;
                parser.nextToken();
            }
            if (JsonToken.START_ARRAY.equals(jsonToken)) {
                NullType$ elementType = NullType$.MODULE$;
                while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                    elementType = this.compatibleType((DataType)elementType, this.inferSchema(parser));
                }
                nullType$ = ArrayType$.MODULE$.apply((DataType)elementType);
            } else if (JsonToken.START_OBJECT.equals(jsonToken)) {
                ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
                while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                    builder.$plus$eq((Object)new StructField(parser.getCurrentName(), this.inferSchema(parser), true, StructField$.MODULE$.apply$default$4()));
                }
                StructField[] fields = (StructField[])builder.result();
                nullType$ = new StructType(fields);
            } else if (JsonToken.VALUE_STRING.equals(jsonToken)) {
                nullType$ = StringType$.MODULE$;
            } else {
                boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                if (bl) {
                    LongType$ longType$;
                    JsonParser.NumberType numberType = parser.getNumberType();
                    boolean bl2 = JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType);
                    if (bl2) {
                        longType$ = LongType$.MODULE$;
                    } else {
                        boolean bl3 = JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType);
                        if (bl3) {
                            BigDecimal v = parser.getDecimalValue();
                            longType$ = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                        } else {
                            boolean bl4 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                            if (bl4) {
                                longType$ = DoubleType$.MODULE$;
                            } else {
                                throw new MatchError((Object)numberType);
                            }
                        }
                    }
                    nullType$ = longType$;
                } else {
                    boolean bl5 = JsonToken.VALUE_TRUE.equals(jsonToken) ? true : JsonToken.VALUE_FALSE.equals(jsonToken);
                    if (bl5) {
                        nullType$ = BooleanType$.MODULE$;
                    } else {
                        throw new Exception("Should never happen");
                    }
                }
            }
        }
        return nullType$;
    }

    public Try<DataType> parseString(String content) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (DataType)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> MODULE$.factory().createParser(content), (Function1 & Serializable & scala.Serializable)parser -> {
            parser.nextToken();
            return MODULE$.inferSchema((JsonParser)parser);
        }));
    }

    public RDD<Either<List<String>, Tuple2<String, String>>> parseRDD(RDD<Row> inputRDD, DataType schemaSparkType) {
        return inputRDD.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)row -> {
            Left left;
            String rowAsString = (String)row.getAs("value");
            Try<DataType> try_ = MODULE$.parseString(rowAsString);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                DataType datasetType = (DataType)success.value();
                List<String> errorList = MODULE$.compareTypes(schemaSparkType, datasetType);
                left = errorList.isEmpty() ? package$.MODULE$.Right().apply((Object)new Tuple2((Object)rowAsString, row.getAs("input_file_name()"))) : package$.MODULE$.Left().apply(errorList);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new .colon.colon((Object)exception.toString(), (List)Nil$.MODULE$));
            } else {
                throw new MatchError(try_);
            }
            return left;
        }), inputRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Either.class));
    }

    public JsonFactory factory() {
        return this.factory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findTightestCommonTypeOfTwo$2(NumericType x14$1, NumericType x15$1, NumericType t) {
        NumericType numericType = t;
        NumericType numericType2 = x14$1;
        if (numericType == null) {
            if (numericType2 == null) return true;
        } else if (numericType.equals(numericType2)) return true;
        NumericType numericType3 = t;
        NumericType numericType4 = x15$1;
        if (numericType3 != null) {
            if (!numericType3.equals(numericType4)) return false;
            return true;
        }
        if (numericType4 == null) return true;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ DataType $anonfun$compatibleType$1(DataType t1$1, DataType t2$1) {
        block14: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block13: {
                                block12: {
                                    block11: {
                                        var4_2 = new Tuple2((Object)t1$1, (Object)t2$1);
                                        if (var4_2 == null || !DoubleType$.MODULE$.equals(var5_3 = (DataType)var4_2._1()) || !(var4_2._2() instanceof DecimalType)) break block11;
                                        var3_4 = true;
                                        break block12;
                                    }
                                    if (var4_2 == null) ** GOTO lbl-1000
                                    var6_5 = (DataType)var4_2._2();
                                    if (var4_2._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var6_5)) {
                                        var3_4 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        var3_4 = false;
                                    }
                                }
                                if (!var3_4) break block13;
                                var2_6 = DoubleType$.MODULE$;
                                break block14;
                            }
                            if (var4_2 == null) break block15;
                            t1 = (DataType)var4_2._1();
                            t2 = (DataType)var4_2._2();
                            if (!(t1 instanceof DecimalType)) break block15;
                            var9_9 = (DecimalType)t1;
                            if (!(t2 instanceof DecimalType)) break block15;
                            var10_10 = (DecimalType)t2;
                            scale = scala.math.package$.MODULE$.max(var9_9.scale(), var10_10.scale());
                            range = scala.math.package$.MODULE$.max(var9_9.precision() - var9_9.scale(), var10_10.precision() - var10_10.scale());
                            var2_6 = range + scale > 38 ? DoubleType$.MODULE$ : new DecimalType(range + scale, scale);
                            break block14;
                        }
                        if (var4_2 == null) break block16;
                        var13_13 = (DataType)var4_2._1();
                        var14_14 = (DataType)var4_2._2();
                        if (!(var13_13 instanceof StructType)) break block16;
                        var15_15 = (StructType)var13_13;
                        fields1 = var15_15.fields();
                        if (!(var14_14 instanceof StructType)) break block16;
                        var17_17 = (StructType)var14_14;
                        fields2 = var17_17.fields();
                        newFields = new ArrayList<StructField>();
                        f1Idx = 0;
                        f2Idx = 0;
                        while (f1Idx < fields1.length && f2Idx < fields2.length) {
                            f1Name = fields1[f1Idx].name();
                            comp = f1Name.compareTo(f2Name = fields2[f2Idx].name());
                            if (comp == 0) {
                                dataType = JsonIngestionUtil$.MODULE$.compatibleType(fields1[f1Idx].dataType(), fields2[f2Idx].dataType());
                                newFields.add(new StructField(f1Name, dataType, true, StructField$.MODULE$.apply$default$4()));
                                ++f1Idx;
                                ++f2Idx;
                                continue;
                            }
                            if (comp < 0) {
                                newFields.add(fields1[f1Idx]);
                                ++f1Idx;
                                continue;
                            }
                            newFields.add(fields2[f2Idx]);
                            ++f2Idx;
                        }
                        while (f1Idx < fields1.length) {
                            newFields.add(fields1[f1Idx]);
                            ++f1Idx;
                        }
                        while (f2Idx < fields2.length) {
                            newFields.add(fields2[f2Idx]);
                            ++f2Idx;
                        }
                        var2_6 = new StructType((StructField[])newFields.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StructField.class))));
                        break block14;
                    }
                    if (var4_2 == null) break block17;
                    var26_26 = (DataType)var4_2._1();
                    var27_27 = (DataType)var4_2._2();
                    if (!(var26_26 instanceof ArrayType)) break block17;
                    var28_28 = (ArrayType)var26_26;
                    elementType1 = var28_28.elementType();
                    containsNull1 = var28_28.containsNull();
                    if (!(var27_27 instanceof ArrayType)) break block17;
                    var31_31 = (ArrayType)var27_27;
                    elementType2 = var31_31.elementType();
                    containsNull2 = var31_31.containsNull();
                    var2_6 = new ArrayType(JsonIngestionUtil$.MODULE$.compatibleType(elementType1, elementType2), containsNull1 != false || containsNull2 != false);
                    break block14;
                }
                if (var4_2 == null) break block18;
                t1 = (DataType)var4_2._1();
                t2 = (DataType)var4_2._2();
                if (!(t1 instanceof IntegralType)) break block18;
                var36_36 = (IntegralType)t1;
                if (!(t2 instanceof DecimalType)) break block18;
                var37_37 = (DecimalType)t2;
                var2_6 = JsonIngestionUtil$.MODULE$.compatibleType((DataType)DecimalType$.MODULE$.forType((DataType)var36_36), (DataType)var37_37);
                break block14;
            }
            if (var4_2 == null) ** GOTO lbl-1000
            t1 = (DataType)var4_2._1();
            t2 = (DataType)var4_2._2();
            if (!(t1 instanceof DecimalType)) ** GOTO lbl-1000
            var40_40 = (DecimalType)t1;
            if (t2 instanceof IntegralType) {
                var41_41 = (IntegralType)t2;
                var2_6 = JsonIngestionUtil$.MODULE$.compatibleType((DataType)var40_40, (DataType)DecimalType$.MODULE$.forType((DataType)var41_41));
            } else if (var4_2 != null) {
                var2_6 = StringType$.MODULE$;
            } else {
                throw new MatchError((Object)var4_2);
            }
        }
        return var2_6;
    }

    public static final /* synthetic */ boolean $anonfun$canonicalizeType$2(StructField field) {
        return field.name().length() > 0;
    }

    private JsonIngestionUtil$() {
        MODULE$ = this;
        this.structFieldComparator = new Comparator<StructField>(){

            public Comparator<StructField> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<StructField> thenComparing(Comparator<? super StructField> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<StructField> thenComparing(Function<? super StructField, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<StructField> thenComparing(Function<? super StructField, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<StructField> thenComparingInt(ToIntFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<StructField> thenComparingLong(ToLongFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<StructField> thenComparingDouble(ToDoubleFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(StructField o1, StructField o2) {
                return new StringOps(Predef$.MODULE$.augmentString(o1.name())).compare(o2.name());
            }
        };
        this.findTightestCommonTypeOfTwo = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            boolean bl;
            void var2_14;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType t2 = (DataType)tuple2._2();
                DataType dataType = t1;
                DataType dataType2 = t2;
                if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                    Some some = new Some((Object)t1);
                    return var2_14;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType t1 = (DataType)tuple2._2();
                if (NullType$.MODULE$.equals(dataType)) {
                    Some some = new Some((Object)t1);
                    return var2_14;
                }
            }
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                if (NullType$.MODULE$.equals(dataType)) {
                    Some some = new Some((Object)t1);
                    return var2_14;
                }
            }
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType t2 = (DataType)tuple2._2();
                if (t1 instanceof IntegralType) {
                    DecimalType decimalType;
                    IntegralType integralType = (IntegralType)t1;
                    if (t2 instanceof DecimalType && (decimalType = (DecimalType)t2).isWiderThan((DataType)integralType)) {
                        Some some = new Some((Object)decimalType);
                        return var2_14;
                    }
                }
            }
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType t2 = (DataType)tuple2._2();
                if (t1 instanceof DecimalType) {
                    IntegralType integralType;
                    DecimalType decimalType = (DecimalType)t1;
                    if (t2 instanceof IntegralType && decimalType.isWiderThan((DataType)(integralType = (IntegralType)t2))) {
                        Some some = new Some((Object)decimalType);
                        return var2_14;
                    }
                }
            }
            if (tuple2 != null) {
                DataType t1 = (DataType)tuple2._1();
                DataType t2 = (DataType)tuple2._2();
                if (t1 instanceof NumericType) {
                    NumericType numericType = (NumericType)t1;
                    if (t2 instanceof NumericType) {
                        NumericType numericType2 = (NumericType)t2;
                        if (!(numericType instanceof DecimalType) && !(numericType2 instanceof DecimalType)) {
                            int index = TypeCoercion$.MODULE$.numericPrecedence().lastIndexWhere((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)JsonIngestionUtil$.$anonfun$findTightestCommonTypeOfTwo$2(numericType, numericType2, t)));
                            Some some = new Some(TypeCoercion$.MODULE$.numericPrecedence().apply(index));
                            return var2_14;
                        }
                    }
                }
            }
            if (bl = tuple2 != null && tuple2._1() instanceof TimestampType && tuple2._2() instanceof DateType ? true : tuple2 != null && tuple2._1() instanceof DateType && tuple2._2() instanceof TimestampType) {
                Some some = new Some((Object)TimestampType$.MODULE$);
                return var2_14;
            }
            None$ none$ = None$.MODULE$;
            return var2_14;
        };
        this.factory = new JsonFactory();
    }
}

