/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.whisper.core;

import com.eclecticlogic.whisper.core.DigestMessage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class Digest {
    private List<DigestMessage> digestMessages = new ArrayList<DigestMessage>();

    public boolean isMessagesSuppressed() {
        return this.digestMessages.size() > 0;
    }

    public String getSubject() {
        if (this.digestMessages.size() == 1) {
            DigestMessage dm = this.digestMessages.get(0);
            return MessageFormat.format("[{0}:{1}] {2}", dm.getMessagesSinceLastDigest(), dm.getMessagesSinceStart(), dm.getMessage());
        }
        int sum = 0;
        for (DigestMessage dm : this.digestMessages) {
            sum += dm.getMessagesSinceLastDigest();
        }
        return MessageFormat.format("{0} distinct messages suppressed. Total suppressed since last digest: {1}", this.digestMessages.size(), sum);
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        for (DigestMessage dm : this.digestMessages) {
            builder.append(dm.getDetails());
            builder.append("\n-------------------------------------------------------------------\n");
            builder.append("\n\n\n");
        }
        return builder.toString();
    }

    public void add(DigestMessage dm) {
        this.digestMessages.add(dm);
    }

    public void clear() {
        this.digestMessages.clear();
    }
}

