/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.whisper.core;

import com.eclecticlogic.whisper.core.Digest;
import com.eclecticlogic.whisper.core.DigestMessage;
import com.eclecticlogic.whisper.core.SuppressionQueue;
import com.eclecticlogic.whisper.core.WhisperManager;
import com.eclecticlogic.whisper.spi.Message;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Muffler<E> {
    private final String messageKey;
    private boolean inSuppression;
    private AtomicInteger messagesSinceSuppressionStart = new AtomicInteger();
    private AtomicInteger messagesSinceLastDigest = new AtomicInteger();
    private AtomicReference<Message<E>> lastMessage = new AtomicReference();
    private SuppressionQueue queue = new SuppressionQueue();
    private WhisperManager<E> manager;

    public Muffler(WhisperManager<E> manager, String messageKey) {
        this.manager = manager;
        this.messageKey = messageKey;
        this.queue.setSuppressAfter(manager.getSuppressAfter());
    }

    public void log(Message<E> message) {
        if (this.inSuppression) {
            Message<E> msg = this.lastMessage.get();
            if (msg != null && msg.getMessageAge() > this.manager.getSuppressionExpirationTime()) {
                this.inSuppression = false;
                this.manager.remove(this.messageKey);
                this.manager.log(message);
            } else {
                this.messagesSinceSuppressionStart.incrementAndGet();
                this.messagesSinceLastDigest.incrementAndGet();
                this.lastMessage.set(message);
            }
        } else {
            this.queue.offer(message.getMessageTime());
            if (this.queue.size() > this.manager.getSuppressionOnMessagesCount()) {
                this.queue.clear();
                this.inSuppression = true;
                this.log(message);
            } else {
                this.manager.logThrough(message);
            }
        }
    }

    public void digest(Digest digest) {
        Message<E> m = this.lastMessage.get();
        if (m != null) {
            if (this.messagesSinceLastDigest.get() == 0) {
                if (m.getMessageAge() > this.manager.getSuppressionExpirationTime()) {
                    this.inSuppression = false;
                    this.manager.remove(this.messageKey);
                    this.lastMessage.set(null);
                }
            } else {
                DigestMessage dm = new DigestMessage();
                dm.setMessage(m.getMessage());
                dm.setFullMessage(m.getFullMessage());
                dm.setMessagesSinceLastDigest(this.messagesSinceLastDigest.get());
                dm.setMessagesSinceSuppressionStart(this.messagesSinceSuppressionStart.get());
                this.messagesSinceLastDigest.set(0);
                digest.add(dm);
            }
        }
    }
}

