/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.whisper.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParameterUtil {
    private static final Pattern numbers = Pattern.compile("^([0-9]+).*");
    private static final Pattern units = Pattern.compile("[0-9\\s]+([a-z]+\\.*)$");
    private static final Pattern timePart = Pattern.compile(".*in([0-9\\s]+[a-z]+\\.*)$");

    private static long toMillis(String encodedValue) {
        String input = encodedValue.trim().toLowerCase();
        Matcher matcherMatcher = numbers.matcher(input);
        if (matcherMatcher.matches()) {
            String number = matcherMatcher.group(1);
            int value = Integer.parseInt(number);
            Matcher unitsMatcher = units.matcher(input);
            if (unitsMatcher.matches()) {
                String unit = unitsMatcher.group(1);
                if (unit.startsWith("s")) {
                    return value * 1000;
                }
                if (unit.startsWith("m")) {
                    return value * 60 * 1000;
                }
                if (unit.startsWith("h")) {
                    return value * 3600 * 1000;
                }
            }
        }
        return -1L;
    }

    public static long digestFrequencyToMillis(String digestFrequency) {
        return ParameterUtil.toMillis(digestFrequency);
    }

    public static long expireAfterToMillis(String expireAfter) {
        return ParameterUtil.toMillis(expireAfter);
    }

    public static int messageCountForSuppression(String suppressionExpression) {
        String[] parts = suppressionExpression.split(" *in *");
        if (parts != null && parts.length > 1) {
            return Integer.parseInt(parts[0].trim());
        }
        return -1;
    }

    public static long suppressionTimeForSuppression(String suppressionExpression) {
        Matcher matcher = timePart.matcher(suppressionExpression.trim());
        if (matcher.matches()) {
            return ParameterUtil.toMillis(matcher.group(1));
        }
        return -1L;
    }
}

