/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.whisper.core;

import com.eclecticlogic.whisper.core.Digest;
import com.eclecticlogic.whisper.core.Muffler;
import com.eclecticlogic.whisper.core.ParameterUtil;
import com.eclecticlogic.whisper.spi.Message;
import com.eclecticlogic.whisper.spi.MessageWriter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WhisperManager<E>
extends TimerTask {
    private int suppressionOnMessagesCount;
    private long suppressAfterMillis;
    private long suppressionExpirationAfterMillis;
    private MessageWriter<E> writer;
    private ConcurrentMap<String, Muffler<E>> queuesByMessage = new ConcurrentHashMap<String, Muffler<E>>();
    private Timer digestTimer;

    public WhisperManager(MessageWriter<E> writer, String supressionAfter, String expireAfter) {
        this.suppressAfterMillis = ParameterUtil.suppressionTimeForSuppression(supressionAfter);
        this.suppressionOnMessagesCount = ParameterUtil.messageCountForSuppression(supressionAfter);
        this.suppressionExpirationAfterMillis = ParameterUtil.expireAfterToMillis(expireAfter);
        this.writer = writer;
    }

    public long getSuppressAfter() {
        return this.suppressAfterMillis;
    }

    public int getSuppressionOnMessagesCount() {
        return this.suppressionOnMessagesCount;
    }

    public long getSuppressionExpirationTime() {
        return this.suppressionExpirationAfterMillis;
    }

    public void log(Message<E> message) {
        Muffler temp;
        Muffler<E> muffler;
        String messageKey = message.getCanonicalMessage();
        if (messageKey == null) {
            messageKey = "null";
        }
        if ((muffler = (Muffler<E>)this.queuesByMessage.get(messageKey)) == null && (temp = this.queuesByMessage.putIfAbsent(messageKey, muffler = new Muffler<E>(this, messageKey))) != null) {
            muffler = temp;
        }
        muffler.log(message);
    }

    public void remove(String messageKey) {
        this.queuesByMessage.remove(messageKey);
    }

    public void logThrough(Message<E> message) {
        this.writer.logThrough(message);
    }

    public void start(long digestFrequencyInMillis) {
        this.digestTimer = new Timer("whisper-timer", true);
        this.digestTimer.scheduleAtFixedRate((TimerTask)this, digestFrequencyInMillis, digestFrequencyInMillis);
    }

    public void stop() {
        this.digestTimer.cancel();
    }

    @Override
    public void run() {
        Digest digest = new Digest();
        for (Muffler muffler : this.queuesByMessage.values()) {
            muffler.digest(digest);
        }
        if (digest.isMessagesSuppressed()) {
            this.writer.logDigest(digest);
            digest.clear();
        }
    }
}

