/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.whisper.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.eclecticlogic.whisper.core.Digest;
import com.eclecticlogic.whisper.core.ParameterUtil;
import com.eclecticlogic.whisper.core.WhisperManager;
import com.eclecticlogic.whisper.logback.AbstractWhisperAppender;
import com.eclecticlogic.whisper.logback.LogbackMessage;
import com.eclecticlogic.whisper.spi.Message;
import com.eclecticlogic.whisper.spi.MessageWriter;
import java.util.Iterator;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class WhisperAppender
extends AbstractWhisperAppender
implements MessageWriter<ILoggingEvent> {
    private WhisperManager<ILoggingEvent> whisperManager;
    private String digestLoggerName;
    private String suppressAfter;
    private String expireAfter;
    private String digestFrequency;

    public String getSuppressAfter() {
        return this.suppressAfter;
    }

    public void setSuppressAfter(String suppressionAfter) {
        this.suppressAfter = suppressionAfter;
    }

    public String getExpireAfter() {
        return this.expireAfter;
    }

    public void setExpireAfter(String expireAfter) {
        this.expireAfter = expireAfter;
    }

    public String getDigestFrequency() {
        return this.digestFrequency;
    }

    public void setDigestFrequency(String digestFrequency) {
        this.digestFrequency = digestFrequency;
    }

    public String getDigestLoggerName() {
        return this.digestLoggerName;
    }

    public void setDigestLoggerName(String digestLoggerName) {
        this.digestLoggerName = digestLoggerName;
    }

    protected void append(ILoggingEvent event) {
        LogbackMessage message = new LogbackMessage(event);
        this.whisperManager.log(message);
    }

    @Override
    public void logThrough(Message<ILoggingEvent> message) {
        Iterator<Appender<ILoggingEvent>> it = this.iteratorForAppenders();
        while (it.hasNext()) {
            it.next().doAppend((Object)message.getEvent());
        }
    }

    @Override
    public void logDigest(Digest digest) {
        MDC.put((String)"whisper.digest.subject", (String)digest.getSubject());
        LoggerFactory.getLogger((String)this.getDigestLoggerName()).error(digest.getMessage());
    }

    public void start() {
        super.start();
        this.whisperManager = new WhisperManager<ILoggingEvent>(this, this.getSuppressAfter(), this.getExpireAfter());
        this.whisperManager.start(ParameterUtil.digestFrequencyToMillis(this.getDigestFrequency()));
    }

    public void stop() {
        this.whisperManager.stop();
        super.stop();
    }
}

