/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.RuntimeType;
import jersey.repackaged.com.google.common.base.Predicate;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AliasDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.binding.ScopedBindingBuilder;
import org.glassfish.jersey.internal.inject.CustomAnnotationImpl;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.ComponentBag;

public class ProviderBinder {
    private final ServiceLocator locator;

    public ProviderBinder(ServiceLocator locator) {
        this.locator = locator;
    }

    public void bindInstances(Iterable<Object> instances) {
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        for (Object instance : instances) {
            this.bindInstance(instance, dc);
        }
        dc.commit();
    }

    public void bindClasses(Class<?> ... classes) {
        if (classes != null && classes.length > 0) {
            DynamicConfiguration dc = Injections.getConfiguration(this.locator);
            for (Class<?> clazz : classes) {
                this.bindClass(clazz, this.locator, dc, false);
            }
            dc.commit();
        }
    }

    public void bindClasses(Iterable<Class<?>> classes) {
        this.bindClasses(classes, false);
    }

    public void bindClasses(Iterable<Class<?>> classes, boolean bindResources) {
        if (classes == null || !classes.iterator().hasNext()) {
            return;
        }
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        for (Class<?> clazz : classes) {
            this.bindClass(clazz, this.locator, dc, bindResources);
        }
        dc.commit();
    }

    public static void bindProvider(Class<?> providerClass, ContractProvider model, DynamicConfiguration dc) {
        for (Class<?> contract : model.getContracts()) {
            ScopedBindingBuilder<?> bindingBuilder = Injections.newBinder(providerClass).in(model.getScope()).qualifiedBy(new CustomAnnotationImpl());
            bindingBuilder.to(contract);
            int priority = model.getPriority(contract);
            if (priority > -1) {
                bindingBuilder.ranked(priority);
            }
            Injections.addBinding(bindingBuilder, dc);
        }
    }

    public static void bindProvider(Object providerInstance, ContractProvider model, DynamicConfiguration dc) {
        for (Class<?> contract : model.getContracts()) {
            ScopedBindingBuilder<Object> bindingBuilder = Injections.newBinder(providerInstance).qualifiedBy(new CustomAnnotationImpl());
            bindingBuilder.to(contract);
            int priority = model.getPriority(contract);
            if (priority > -1) {
                bindingBuilder.ranked(priority);
            }
            Injections.addBinding(bindingBuilder, dc);
        }
    }

    public static void bindProviders(ComponentBag componentBag, ServiceLocator locator) {
        ProviderBinder.bindProviders(componentBag, null, Collections.<Class<?>>emptySet(), locator);
    }

    public static void bindProviders(ComponentBag componentBag, RuntimeType constrainedTo, Set<Class<?>> registeredClasses, ServiceLocator locator) {
        DynamicConfiguration dc = Injections.getConfiguration(locator);
        ProviderBinder.bindProviders(componentBag, constrainedTo, registeredClasses, dc);
        dc.commit();
    }

    public static void bindProviders(final ComponentBag componentBag, final RuntimeType constrainedTo, final Set<Class<?>> registeredClasses, DynamicConfiguration dynamicConfiguration) {
        Predicate<ContractProvider> filter = new Predicate<ContractProvider>(){

            public boolean apply(ContractProvider input) {
                return ComponentBag.EXCLUDE_EMPTY.apply((Object)input) && ComponentBag.EXCLUDE_META_PROVIDERS.apply((Object)input);
            }
        };
        Set classes = Sets.newLinkedHashSet(componentBag.getClasses(filter));
        if (constrainedTo != null) {
            classes = Sets.filter((Set)classes, (Predicate)new Predicate<Class<?>>(){

                public boolean apply(Class<?> componentClass) {
                    return Providers.checkProviderRuntime(componentClass, componentBag.getModel(componentClass), constrainedTo, registeredClasses == null || !registeredClasses.contains(componentClass), false);
                }
            });
        }
        for (Class providerClass : classes) {
            ContractProvider model = componentBag.getModel(providerClass);
            ProviderBinder.bindProvider(providerClass, model, dynamicConfiguration);
        }
        Set instances = componentBag.getInstances(filter);
        if (constrainedTo != null) {
            instances = Sets.filter(instances, (Predicate)new Predicate<Object>(){

                public boolean apply(Object component) {
                    Class<?> componentClass = component.getClass();
                    return Providers.checkProviderRuntime(componentClass, componentBag.getModel(componentClass), constrainedTo, registeredClasses == null || !registeredClasses.contains(componentClass), false);
                }
            });
        }
        for (Object provider : instances) {
            ContractProvider model = componentBag.getModel(provider.getClass());
            ProviderBinder.bindProvider(provider, model, dynamicConfiguration);
        }
    }

    private <T> void bindInstance(T instance, DynamicConfiguration dc) {
        for (Class<?> contract : Providers.getProviderContracts(instance.getClass())) {
            Injections.addBinding(Injections.newBinder(instance).to(contract).qualifiedBy(new CustomAnnotationImpl()), dc);
        }
    }

    private <T> void bindClass(Class<T> clazz, ServiceLocator locator, DynamicConfiguration dc, boolean isResource) {
        Class<? extends Annotation> scope = this.getProviderScope(clazz);
        if (isResource) {
            ActiveDescriptor descriptor = dc.bind(BuilderHelper.activeLink(clazz).to(clazz).in(scope).build());
            for (Class<?> contract : Providers.getProviderContracts(clazz)) {
                AliasDescriptor aliasDescriptor = new AliasDescriptor(locator, descriptor, contract.getName(), null);
                aliasDescriptor.setScope(scope.getName());
                aliasDescriptor.addQualifierAnnotation(new CustomAnnotationImpl());
                dc.bind(aliasDescriptor);
            }
        } else {
            ScopedBindingBuilder<?> bindingBuilder = Injections.newBinder(clazz).in(scope).qualifiedBy(new CustomAnnotationImpl());
            for (Class<?> contract : Providers.getProviderContracts(clazz)) {
                bindingBuilder.to(contract);
            }
            Injections.addBinding(bindingBuilder, dc);
        }
    }

    private Class<? extends Annotation> getProviderScope(Class<?> clazz) {
        Class hk2Scope = Singleton.class;
        if (clazz.isAnnotationPresent(PerLookup.class)) {
            hk2Scope = PerLookup.class;
        }
        return hk2Scope;
    }
}

