/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.SubjectSecurityContext;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.ComponentModelValidator;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.internal.ModelErrors;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.spi.internal.ParameterValueHelper;

class SubResourceLocatorRouter
implements Router {
    private final ServiceLocator locator;
    private final ResourceMethod locatorModel;
    private final List<Factory<?>> valueProviders;
    private final RuntimeModelBuilder runtimeModelBuilder;
    private final JerseyResourceContext resourceContext;
    private final boolean disableValidation;
    private final boolean ignoreValidationErrors;

    public SubResourceLocatorRouter(ServiceLocator locator, RuntimeModelBuilder runtimeModelBuilder, ResourceMethod locatorModel) {
        this.locator = locator;
        this.runtimeModelBuilder = runtimeModelBuilder;
        this.locatorModel = locatorModel;
        this.valueProviders = ParameterValueHelper.createValueProviders(locator, locatorModel.getInvocable());
        this.resourceContext = locator.getService(JerseyResourceContext.class, new Annotation[0]);
        Configuration config = locator.getService(Configuration.class, new Annotation[0]);
        this.disableValidation = ServerProperties.getValue(config.getProperties(), "jersey.config.server.resource.validation.disable", Boolean.FALSE, Boolean.class);
        this.ignoreValidationErrors = ServerProperties.getValue(config.getProperties(), "jersey.config.server.resource.validation.ignoreErrors", Boolean.FALSE, Boolean.class);
    }

    @Override
    public Router.Continuation apply(RequestProcessingContext processingContext) {
        Resource subResource;
        Object subResourceInstance = this.getResource(processingContext);
        RoutingContext routingContext = processingContext.routingContext();
        if (subResourceInstance == null) {
            throw new NotFoundException();
        }
        if (subResourceInstance.getClass().isAssignableFrom(Resource.class)) {
            subResource = (Resource)subResourceInstance;
        } else {
            if (subResourceInstance.getClass().isAssignableFrom(Class.class)) {
                Class clazz = (Class)subResourceInstance;
                subResourceInstance = Injections.getOrCreate(this.locator, clazz);
            } else {
                routingContext.pushMatchedResource(subResourceInstance);
                this.resourceContext.bindResourceIfSingleton(subResourceInstance);
            }
            Resource.Builder builder = Resource.builder(subResourceInstance.getClass());
            if (builder == null) {
                builder = Resource.builder().name(subResourceInstance.getClass().getName());
            }
            subResource = builder.build();
        }
        ResourceModel resourceModel = new ResourceModel.Builder(true).addResource(subResource).build();
        resourceModel = this.processSubResource(resourceModel);
        if (!this.disableValidation) {
            this.validate(resourceModel, this.ignoreValidationErrors);
        }
        subResource = resourceModel.getResources().get(0);
        routingContext.pushLocatorSubResource(subResource);
        processingContext.triggerEvent(RequestEvent.Type.SUBRESOURCE_LOCATED);
        for (Class<?> handlerClass : subResource.getHandlerClasses()) {
            this.resourceContext.bindResource(handlerClass);
        }
        Router subResourceAcceptor = this.runtimeModelBuilder.buildModel(resourceModel.getRuntimeResourceModel(), true);
        return Router.Continuation.of(processingContext, subResourceAcceptor);
    }

    private ResourceModel processSubResource(ResourceModel subResourceModel) {
        Configuration configuration = this.locator.getService(Configuration.class, new Annotation[0]);
        Iterable allRankedProviders = Providers.getAllRankedProviders(this.locator, ModelProcessor.class);
        Iterable<ModelProcessor> modelProcessors = Providers.sortRankedProviders(new RankedComparator(), allRankedProviders);
        for (ModelProcessor modelProcessor : modelProcessors) {
            subResourceModel = modelProcessor.processSubResource(subResourceModel, configuration);
            this.validateEnhancedModel(subResourceModel);
        }
        return subResourceModel;
    }

    private void validateEnhancedModel(ResourceModel subResourceModel) {
        if (subResourceModel.getResources().size() != 1) {
            throw new ProcessingException(LocalizationMessages.ERROR_SUB_RESOURCE_LOCATOR_MORE_RESOURCES(subResourceModel.getResources().size()));
        }
    }

    private void validate(final ResourceModelComponent component, final boolean ignoreFatalIssues) {
        Errors.process(new Runnable(){

            @Override
            public void run() {
                ComponentModelValidator validator = new ComponentModelValidator(SubResourceLocatorRouter.this.locator);
                validator.validate(component);
                if (Errors.fatalIssuesFound() && !ignoreFatalIssues) {
                    throw new ModelValidationException(LocalizationMessages.ERROR_VALIDATION_SUBRESOURCE(), ModelErrors.getErrorsAsResourceModelIssues());
                }
            }
        });
    }

    private Object getResource(RequestProcessingContext context) {
        final Object resource = context.routingContext().peekMatchedResource();
        final Method handlingMethod = this.locatorModel.getInvocable().getHandlingMethod();
        final Object[] parameterValues = ParameterValueHelper.getParameterValues(this.valueProviders);
        context.triggerEvent(RequestEvent.Type.LOCATOR_MATCHED);
        PrivilegedAction invokeMethodAction = new PrivilegedAction(){

            public Object run() {
                try {
                    return handlingMethod.invoke(resource, parameterValues);
                }
                catch (IllegalAccessException | IllegalArgumentException | UndeclaredThrowableException ex) {
                    throw new ProcessingException(LocalizationMessages.ERROR_RESOURCE_JAVA_METHOD_INVOCATION(), ex);
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof WebApplicationException) {
                        throw (WebApplicationException)cause;
                    }
                    throw new MappableException(cause);
                }
                catch (Throwable t) {
                    throw new ProcessingException(t);
                }
            }
        };
        SecurityContext securityContext = context.request().getSecurityContext();
        return securityContext instanceof SubjectSecurityContext ? ((SubjectSecurityContext)securityContext).doAsSubject(invokeMethodAction) : invokeMethodAction.run();
    }
}

