/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.maleorang;

import com.ecwid.maleorang.MailchimpException;
import com.ecwid.maleorang.MailchimpMethod;
import com.ecwid.maleorang.MailchimpMethodInfo;
import com.ecwid.maleorang.MailchimpObject;
import com.ecwid.maleorang.connector.Connector;
import com.ecwid.maleorang.connector.HttpClientConnector;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0017J%\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/ecwid/maleorang/MailchimpClient;", "Ljava/io/Closeable;", "apiKey", "", "(Ljava/lang/String;)V", "connector", "Lcom/ecwid/maleorang/connector/Connector;", "(Ljava/lang/String;Lcom/ecwid/maleorang/connector/Connector;)V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "close", "", "execute", "R", "Lcom/ecwid/maleorang/MailchimpObject;", "method", "Lcom/ecwid/maleorang/MailchimpMethod;", "(Lcom/ecwid/maleorang/MailchimpMethod;)Lcom/ecwid/maleorang/MailchimpObject;", "maleorang-compileKotlin"})
public class MailchimpClient
implements Closeable {
    private final Logger log;
    private final String apiKey;
    private final Connector connector;

    @NotNull
    public final <R extends MailchimpObject> R execute(@NotNull MailchimpMethod<R> method) throws IOException, MailchimpException {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        MailchimpMethodInfo methodInfo = new MailchimpMethodInfo(method);
        Connector.Request request = new Connector.Request(methodInfo.getHttpMethod().name(), methodInfo.buildUrl(this.apiKey), "ignorable", this.apiKey, methodInfo.getRequestBody());
        if (this.log.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder("Request: ");
            sb.append(request.getMethod()).append(' ').append(request.getUrl());
            if (request.getRequestBody() != null) {
                sb.append('\n').append("Body: ").append(request.getRequestBody());
            }
            this.log.info(sb.toString());
        }
        Connector.Response response = this.connector.call(request);
        if (this.log.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder("Response: ");
            sb.append(response.getStatusCode()).append(' ').append(response.getReasonPhrase());
            if (response.getResponseBody() != null) {
                sb.append('\n').append("Body: ").append(response.getResponseBody());
            }
            this.log.info(sb.toString());
        }
        int n = response.getStatusCode();
        boolean bl = true;
        if (n < 200) {
            bl = false;
        }
        boolean bl2 = true;
        if (n > 299) {
            bl2 = false;
        }
        if (bl & bl2 ^ true) {
            int code = response.getStatusCode();
            String description = response.getReasonPhrase();
            if (response.getResponseBody() != null) {
                try {
                    JsonObject error = new JsonParser().parse(response.getResponseBody()).getAsJsonObject();
                    code = error.get("status").getAsInt();
                    String string = error.get("detail").getAsString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"error.get(\"detail\").asString");
                    description = string;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw (Throwable)new MailchimpException(code, description);
        }
        String string = response.getResponseBody();
        if (string == null) {
            string = "{}";
        }
        return MailchimpObject.Companion.fromJson(string, method.getResultType());
    }

    @Override
    public void close() throws IOException {
        this.connector.close();
    }

    protected MailchimpClient(@NotNull String apiKey, @NotNull Connector connector) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)connector, (String)"connector");
        this.apiKey = apiKey;
        this.connector = connector;
        this.log = Logger.getLogger(this.getClass().getName());
    }

    public MailchimpClient(@NotNull String apiKey) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        this(apiKey, new HttpClientConnector());
    }
}

