/*
 * Decompiled with CFR 0.152.
 */
package com.edugility.h2.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.h2.server.TcpServer;
import org.h2.tools.Server;

public abstract class AbstractH2Mojo
extends AbstractMojo {
    private boolean useSSL;
    private boolean allowOthers;
    private int port;
    private File baseDirectory;
    private boolean ifExists;
    private String shutdownPassword;
    private String shutdownHost;
    private boolean forceShutdown;
    private boolean shutdownAllServers;
    private boolean trace;
    private File java;
    private String[] javaOptions;

    protected AbstractH2Mojo() {
        this.setPort(9092);
        this.setShutdownPassword("h2-maven-plugin");
        this.setJava(new File(new File(new File(System.getProperty("java.home")), "bin"), "java"));
    }

    public boolean getShutdownAllServers() {
        return this.shutdownAllServers;
    }

    public void setShutdownAllServers(boolean shutdownAllServers) {
        this.shutdownAllServers = shutdownAllServers;
    }

    public String getShutdownPassword() {
        return this.shutdownPassword;
    }

    public void setShutdownPassword(String pw) {
        this.shutdownPassword = pw;
    }

    public String getShutdownHost() {
        return this.shutdownHost;
    }

    public void setShutdownHost(String shutdownHost) {
        this.shutdownHost = shutdownHost;
    }

    public boolean getForceShutdown() {
        return this.forceShutdown;
    }

    public void setForceShutdown(boolean shutdown) {
        this.forceShutdown = shutdown;
    }

    public final File getH2() {
        ProtectionDomain pd = Server.class.getProtectionDomain();
        assert (pd != null);
        CodeSource cs = pd.getCodeSource();
        assert (cs != null);
        URL location = cs.getLocation();
        assert (location != null);
        try {
            return new File(location.toURI());
        }
        catch (URISyntaxException wontHappen) {
            throw (InternalError)new InternalError().initCause(wontHappen);
        }
    }

    public File getJava() {
        return this.java;
    }

    public void setJava(File java) {
        this.java = java;
    }

    public String[] getJavaOptions() {
        return this.javaOptions;
    }

    public void setJavaOptions(String ... javaOptions) {
        this.javaOptions = javaOptions;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    public void setAllowOthers(boolean allowOthers) {
        this.allowOthers = allowOthers;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = Math.min(65535, Math.max(0, port));
    }

    protected Server createServer() throws SQLException {
        List<String> args = this.getServerArguments();
        Server server = Server.createTcpServer((String[])args.toArray(new String[args.size()]));
        return server;
    }

    protected ProcessBuilder getServerSpawner() {
        List<String> args = this.getServerArguments();
        assert (args != null);
        args.remove("-tcpDaemon");
        int argumentIndex = 0;
        File java = this.getJava();
        if (java == null) {
            java = new File(new File(new File(System.getProperty("java.home")), "bin"), "java");
        }
        args.add(argumentIndex++, java.getAbsolutePath());
        String[] javaOptions = this.getJavaOptions();
        if (javaOptions != null && javaOptions.length > 0) {
            for (String option : javaOptions) {
                if (option == null || option.trim().isEmpty()) continue;
                args.add(argumentIndex++, option);
            }
        }
        args.add(argumentIndex++, "-cp");
        File fileLocation = this.getH2();
        assert (fileLocation != null);
        args.add(argumentIndex++, fileLocation.getAbsolutePath());
        args.add(argumentIndex++, Server.class.getName());
        Log log = this.getLog();
        if (log != null && log.isDebugEnabled()) {
            log.debug((CharSequence)("Process arguments: " + args));
        }
        return new ProcessBuilder(args);
    }

    protected Process spawnServer() throws IOException {
        return this.getServerSpawner().start();
    }

    protected void shutdownServer() throws SQLException {
        String password = this.getShutdownPassword();
        if (password == null) {
            password = "";
        }
        int port = this.getPort();
        String host = this.getShutdownHost();
        host = host == null ? "" : host.trim();
        if (host.isEmpty()) {
            host = "localhost";
        }
        TcpServer.shutdown((String)String.format("tcp://%s:%d", host, port), (String)password, (boolean)this.getForceShutdown(), (boolean)this.getShutdownAllServers());
    }

    protected List<String> getServerArguments() {
        String password;
        LinkedList<String> args = new LinkedList<String>();
        File baseDirectory = this.getBaseDirectory();
        if (baseDirectory != null) {
            args.add("-baseDir");
            args.add(String.format("%s", baseDirectory.getAbsolutePath()));
        }
        if (this.getIfExists()) {
            args.add("-ifExists");
        }
        if (this.getTrace()) {
            args.add("-trace");
        }
        args.add("-tcp");
        if (this.getAllowOthers()) {
            args.add("-tcpAllowOthers");
        }
        if ((password = this.getShutdownPassword()) != null && !password.isEmpty()) {
            args.add("-tcpPassword");
            args.add(password);
        }
        args.add("-tcpPort");
        args.add(String.format("%d", Math.min(65535, Math.max(0, this.getPort()))));
        if (this.getUseSSL()) {
            args.add("-tcpSSL");
        }
        return args;
    }
}

