/*
 * Decompiled with CFR 0.152.
 */
package com.edugility.jpa.maven.plugin;

import com.edugility.jpa.maven.plugin.AbstractJPAMojo;
import com.edugility.jpa.maven.plugin.AnnotationDB;
import com.edugility.jpa.maven.plugin.FileException;
import com.edugility.jpa.maven.plugin.NotDirectoryException;
import com.edugility.jpa.maven.plugin.NotNormalFileException;
import com.edugility.jpa.maven.plugin.NotWritableDirectoryException;
import com.edugility.jpa.maven.plugin.NotWritableFileException;
import com.edugility.jpa.maven.plugin.PathCreationFailedException;
import com.edugility.jpa.maven.plugin.URLFilter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.IdClass;
import javax.persistence.MappedSuperclass;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ListEntityClassnamesMojo
extends AbstractJPAMojo {
    private static final Pattern quotePattern;
    private static final String DEFAULT_DEFAULT_PROPERTY_NAME = "entityClassnames";
    private static final String DEFAULT_OUTPUT_FILENAME;
    static final String DEFAULT_SUBDIR_PREFIX;
    private static final List<String> JPA_ANNOTATIONS;
    private boolean stripQuotes = true;
    private String encoding;
    private File outputFile;
    boolean useOutputFile;
    private String defaultPropertyName;
    private Map<String, String> propertyNames;
    private String firstItemPrefix;
    private String prefix;
    private String suffix;
    private String lastItemSuffix;
    private Set<URL> urls;

    public ListEntityClassnamesMojo() {
        this.setDefaultPropertyName(DEFAULT_DEFAULT_PROPERTY_NAME);
        this.setFirstItemPrefix("");
        this.setPrefix("");
        this.setSuffix("");
        this.setLastItemSuffix("");
    }

    public Map<String, String> getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(Map<String, String> propertyNames) {
        this.propertyNames = propertyNames;
    }

    final String stripQuotes(String text) {
        if (text != null && this.stripQuotes && quotePattern != null) {
            Matcher matcher = quotePattern.matcher(text);
            assert (matcher != null);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, matcher.group(2));
            }
            matcher.appendTail(sb);
            text = sb.toString();
        }
        return text;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = this.stripQuotes(prefix);
    }

    public String getFirstItemPrefix() {
        return this.firstItemPrefix;
    }

    public void setFirstItemPrefix(String firstItemPrefix) {
        this.firstItemPrefix = this.stripQuotes(firstItemPrefix);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = this.stripQuotes(suffix);
    }

    public String getLastItemSuffix() {
        return this.lastItemSuffix;
    }

    public void setLastItemSuffix(String lastItemSuffix) {
        this.lastItemSuffix = this.stripQuotes(lastItemSuffix);
    }

    private final Set<URL> initializeURLs() throws DependencyResolutionRequiredException {
        Set<URL> urls = this.getURLs();
        if (urls == null) {
            urls = this.getTestClasspathURLs();
        }
        assert (urls != null);
        URLFilter urlFilter = this.getURLFilter();
        Iterator<URL> iterator = urls.iterator();
        assert (iterator != null);
        while (iterator.hasNext()) {
            URL url = iterator.next();
            if (url != null && (urlFilter == null || urlFilter.accept(url))) continue;
            iterator.remove();
        }
        this.setURLs(urls);
        return this.getURLs();
    }

    private final Set<URL> getTestClasspathURLs() throws DependencyResolutionRequiredException {
        Set<URL> urls;
        Log log = this.getLog();
        assert (log != null);
        MavenProject project = this.getProject();
        List classpathElements = project == null ? null : project.getTestClasspathElements();
        if (classpathElements == null || classpathElements.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn((CharSequence)String.format("The test classpath contained no elements. Consequently no Entities were found.", new Object[0]));
            }
            urls = Collections.emptySet();
        } else {
            LinkedHashSet<URL> mutableUrls = new LinkedHashSet<URL>(classpathElements.size());
            for (Object o : classpathElements) {
                if (o == null) continue;
                File file = new File(o.toString());
                if (file.canRead()) {
                    try {
                        mutableUrls.add(file.toURI().toURL());
                        continue;
                    }
                    catch (MalformedURLException wontHappen) {
                        throw (InternalError)new InternalError(String.format("While attempting to convert a file, %s, into a URL, a MalformedURLException was encountered.", file)).initCause(wontHappen);
                    }
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((CharSequence)String.format("The test classpath element %s could not be read.", file));
            }
            urls = mutableUrls.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(mutableUrls);
        }
        if (log.isWarnEnabled() && urls.isEmpty()) {
            log.warn((CharSequence)String.format("No URLs were found from the test classpath (%s).", classpathElements));
        }
        return urls;
    }

    public final String getProjectBuildDirectoryName() {
        String buildDirectoryName;
        Build build;
        String returnValue = null;
        MavenProject project = this.getProject();
        if (project != null && (build = project.getBuild()) != null && (buildDirectoryName = build.getDirectory()) != null) {
            returnValue = buildDirectoryName;
        }
        if (returnValue == null) {
            returnValue = System.getProperty("maven.project.build.directory", System.getProperty("project.build.directory", String.format("%1$s%2$starget", System.getProperty("basedir", System.getProperty("user.dir", ".")), File.separator)));
        }
        return returnValue;
    }

    private final File initializeOutputFile() throws FileException {
        this.setOutputFile(this.initializeOutputFile(this.getOutputFile()));
        return this.getOutputFile();
    }

    final File initializeOutputFile(File outputFile) throws FileException {
        File projectBuildDirectory;
        if (outputFile == null) {
            projectBuildDirectory = new File(this.getProjectBuildDirectoryName());
            File outputDirectory = new File(projectBuildDirectory, DEFAULT_SUBDIR_PREFIX);
            this.validateOutputDirectory(outputDirectory);
            outputFile = new File(outputDirectory, DEFAULT_OUTPUT_FILENAME);
        } else {
            if (!outputFile.isAbsolute()) {
                projectBuildDirectory = new File(this.getProjectBuildDirectoryName());
                File outputDirectory = new File(projectBuildDirectory, DEFAULT_SUBDIR_PREFIX);
                this.validateOutputDirectory(outputDirectory);
                outputFile = new File(outputDirectory, outputFile.getPath());
            }
            if (outputFile.isDirectory()) {
                File outputDirectory = outputFile;
                this.validateOutputDirectory(outputDirectory);
                outputFile = new File(outputDirectory, DEFAULT_OUTPUT_FILENAME);
            } else if (outputFile.exists()) {
                if (!outputFile.isFile()) {
                    throw new NotNormalFileException(outputFile);
                }
                if (!outputFile.canWrite()) {
                    throw new NotWritableFileException(outputFile);
                }
                this.validateOutputDirectory(outputFile.getParentFile());
            } else {
                this.validateOutputDirectory(outputFile.getParentFile());
            }
        }
        assert (outputFile != null);
        assert (outputFile.isAbsolute());
        Log log = this.getLog();
        if (log != null && log.isDebugEnabled()) {
            log.debug((CharSequence)String.format("Output file initialized to %s", outputFile));
        }
        return outputFile;
    }

    private boolean validateOutputDirectory(File outputDirectory) throws FileException {
        boolean mkdirs = false;
        if (outputDirectory == null) {
            throw new IllegalArgumentException("outputDirectory", new NullPointerException("outputDirectory == null"));
        }
        if (outputDirectory.exists()) {
            if (!outputDirectory.isDirectory()) {
                throw new NotDirectoryException(outputDirectory);
            }
            if (!outputDirectory.canWrite()) {
                throw new NotWritableDirectoryException(outputDirectory);
            }
        } else {
            mkdirs = outputDirectory.mkdirs();
            if (!mkdirs) {
                throw new PathCreationFailedException(outputDirectory);
            }
        }
        return mkdirs;
    }

    private final void initialize() throws DependencyResolutionRequiredException, FileException {
        this.initializePropertyNames();
        this.initializeURLs();
        if (this.getUseOutputFile()) {
            this.initializeOutputFile();
        }
    }

    private final void initializePropertyNames() {
        if (this.propertyNames == null) {
            this.propertyNames = new HashMap<String, String>();
        }
        if (this.defaultPropertyName == null) {
            this.propertyNames.put(DEFAULT_DEFAULT_PROPERTY_NAME, "");
        } else {
            String defaultPropertyName = this.defaultPropertyName.trim();
            if (defaultPropertyName.isEmpty()) {
                this.propertyNames.put(DEFAULT_DEFAULT_PROPERTY_NAME, "");
            } else {
                this.propertyNames.put(defaultPropertyName, "");
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        encoding = encoding == null ? "" : encoding.trim();
        this.encoding = encoding.isEmpty() ? "UTF8" : encoding;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File file) {
        this.outputFile = file;
    }

    public boolean getUseOutputFile() {
        return this.useOutputFile;
    }

    public void setUseOutputFile(boolean useOutputFile) {
        this.useOutputFile = useOutputFile;
    }

    public Set<URL> getURLs() {
        return this.urls;
    }

    public void setURLs(Set<URL> urls) {
        this.urls = urls;
    }

    private final AnnotationDB scan() throws IOException, MojoExecutionException, MojoFailureException {
        return this.scan(this.getURLs());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File outputFile;
        Enumeration<?> propertyNames;
        Properties projectProperties;
        MavenProject project;
        Enumeration<?> propertyNames2;
        AnnotationDB db2;
        Log log = this.getLog();
        if (log == null) {
            throw new MojoExecutionException("this.getLog() == null");
        }
        try {
            this.initialize();
        }
        catch (DependencyResolutionRequiredException kaboom) {
            throw new MojoExecutionException(String.format("Dependencies of the current Maven project could not be downloaded during initialization of the jpa-maven-plugin.", new Object[0]), (Exception)((Object)kaboom));
        }
        catch (NotWritableDirectoryException kaboom) {
            throw new MojoExecutionException(String.format("The output directory path, %s, exists and is a directory, but the current user, %s, cannot write to it.", kaboom.getFile(), System.getProperty("user.name")), (Exception)kaboom);
        }
        catch (NotWritableFileException kaboom) {
            throw new MojoExecutionException(String.format("The outputFile specified, %s, is a regular file, but cannot be written to by Maven running as user %s.  The outputFile parameter must designate either an existing, writable file or a non-existent file.", this.outputFile, System.getProperty("user.name")), (Exception)kaboom);
        }
        catch (NotNormalFileException kaboom) {
            throw new MojoExecutionException(String.format("The outputFile specified, %s, is not a directory, but is also not a normal file.  The outputFile parameter must deisgnate either an existing, writable, normal file or a non-existent file.", this.outputFile), (Exception)kaboom);
        }
        catch (NotDirectoryException kaboom) {
            throw new MojoExecutionException(String.format("The output directory path, %s, exists but is not a directory.", kaboom.getFile()), (Exception)kaboom);
        }
        catch (PathCreationFailedException kaboom) {
            throw new MojoExecutionException(String.format("Some portion of the output directory path, %s, could not be created.", kaboom.getFile()), (Exception)kaboom);
        }
        catch (FileException other) {
            throw new MojoExecutionException("An unexpected FileException occurred during initialization.", (Exception)other);
        }
        AnnotationDB tempDb = null;
        try {
            tempDb = this.scan();
        }
        catch (IOException kaboom) {
            throw new MojoExecutionException("Execution failed because an IOException was encountered during URL scanning.", (Exception)kaboom);
        }
        finally {
            AnnotationDB db2 = tempDb;
            tempDb = null;
        }
        assert (db2 != null);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)"Annotation index:");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            db2.outputAnnotationIndex(pw);
            log.debug((CharSequence)sw.toString());
            try {
                sw.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            pw.close();
        }
        Properties properties = new Properties();
        Map ai = db2.getAnnotationIndex();
        if (ai == null) {
            if (log.isWarnEnabled()) {
                log.warn((CharSequence)"After scanning for Entities, a null annotation index was returned by the AnnotationDB.");
            }
        } else if (ai.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn((CharSequence)"After scanning for Entities, no annotated Entities were found.");
            }
        } else {
            HashMap<String, TreeSet<String>> propertyNameIndex = new HashMap<String, TreeSet<String>>();
            for (String jpaAnnotation : JPA_ANNOTATIONS) {
                Set annotatedClassNames = (Set)ai.get(jpaAnnotation);
                if (annotatedClassNames == null || annotatedClassNames.isEmpty()) continue;
                for (String annotatedClassName : annotatedClassNames) {
                    assert (annotatedClassName != null);
                    String propertyName = this.determinePropertyName(annotatedClassName);
                    assert (propertyName != null);
                    TreeSet<String> relevantClassNames = (TreeSet<String>)propertyNameIndex.get(propertyName);
                    if (relevantClassNames == null) {
                        relevantClassNames = new TreeSet<String>();
                        propertyNameIndex.put(propertyName, relevantClassNames);
                    }
                    assert (relevantClassNames != null);
                    relevantClassNames.add(annotatedClassName);
                }
            }
            Set entrySet = propertyNameIndex.entrySet();
            assert (entrySet != null);
            if (!entrySet.isEmpty()) {
                String firstItemPrefix = this.getFirstItemPrefix();
                String prefix = this.getPrefix();
                String suffix = this.getSuffix();
                String lastItemSuffix = this.getLastItemSuffix();
                for (Map.Entry entry : entrySet) {
                    assert (entry != null);
                    StringBuilder sb = new StringBuilder();
                    String propertyName = (String)entry.getKey();
                    assert (propertyName != null);
                    Set classNames = (Set)entry.getValue();
                    assert (classNames != null);
                    assert (!classNames.isEmpty());
                    Iterator classNamesIterator = classNames.iterator();
                    assert (classNamesIterator != null);
                    assert (classNamesIterator.hasNext());
                    while (classNamesIterator.hasNext()) {
                        sb.append(this.decorate((String)classNamesIterator.next(), sb.length() <= 0 ? firstItemPrefix : prefix, classNamesIterator.hasNext() ? suffix : lastItemSuffix));
                    }
                    properties.setProperty(propertyName, sb.toString());
                }
            }
        }
        if (log.isDebugEnabled() && (propertyNames2 = properties.propertyNames()) != null) {
            while (propertyNames2.hasMoreElements()) {
                Object nextElement = propertyNames2.nextElement();
                if (nextElement == null) continue;
                String key = nextElement.toString();
                assert (key != null);
                String value = properties.getProperty(key);
                log.debug((CharSequence)String.format("%s = %s", key, value));
            }
        }
        if ((project = this.getProject()) != null && (projectProperties = project.getProperties()) != null && (propertyNames = properties.propertyNames()) != null && propertyNames.hasMoreElements()) {
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                if (propertyName == null) continue;
                projectProperties.setProperty(propertyName, properties.getProperty(propertyName));
            }
        }
        if (this.getUseOutputFile() && (outputFile = this.getOutputFile()) != null) {
            assert (!outputFile.exists() || outputFile.isFile());
            assert (outputFile.getParentFile() != null);
            assert (outputFile.getParentFile().isDirectory());
            assert (outputFile.getParentFile().canWrite());
            assert (outputFile.exists() || outputFile.getParentFile().canWrite());
            String encoding = this.getEncoding();
            encoding = encoding == null ? "" : encoding.trim();
            if (encoding.isEmpty()) {
                encoding = "UTF8";
            }
            Writer writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding));
                properties.store(writer, "Generated by " + ((Object)((Object)this)).getClass().getName());
                writer.flush();
            }
            catch (IOException kaboom) {
                throw new MojoExecutionException(String.format("While attempting to write to the outputFile parameter (%s), an IOException was encountered.", outputFile), (Exception)kaboom);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
    }

    public String getDefaultPropertyName() {
        return this.defaultPropertyName;
    }

    public void setDefaultPropertyName(String defaultPropertyName) {
        if ((defaultPropertyName = defaultPropertyName == null ? "" : defaultPropertyName.trim()).isEmpty()) {
            defaultPropertyName = DEFAULT_DEFAULT_PROPERTY_NAME;
        }
        this.defaultPropertyName = defaultPropertyName;
    }

    public String determinePropertyName(String className) {
        String propertyName = this.getDefaultPropertyName();
        if (className != null && !(className = className.trim()).isEmpty()) {
            Map<String, String> propertyNames;
            Log log = this.getLog();
            assert (log != null);
            int index = Math.max(0, className.lastIndexOf(46));
            String packageName = className.substring(0, index);
            assert (packageName != null);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Package: " + packageName));
            }
            if ((propertyNames = this.getPropertyNames()) == null) {
                if (log.isWarnEnabled()) {
                    log.warn((CharSequence)String.format("Property names were never initialized; assigning default property name (%s) to class name %s.", propertyName, className));
                }
            } else if (propertyNames.isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn((CharSequence)String.format("Property names were initialized to the empty set; assigning default property name (%s) to class name %s.", propertyName, className));
                }
            } else {
                propertyName = propertyNames.get(packageName);
                while (propertyName == null && packageName != null && !packageName.isEmpty()) {
                    int dotIndex = Math.max(0, packageName.lastIndexOf(46));
                    packageName = packageName.substring(0, dotIndex);
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Package: " + packageName));
                    }
                    propertyName = propertyNames.get(packageName);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("propertyName: " + propertyName));
            }
        }
        if (propertyName == null) {
            propertyName = DEFAULT_DEFAULT_PROPERTY_NAME;
        }
        return propertyName;
    }

    protected String decorate(String classname, String prefix, String suffix) {
        String returnValue;
        if (classname == null) {
            returnValue = null;
        } else {
            StringBuilder sb = new StringBuilder();
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(classname);
            if (suffix != null) {
                sb.append(suffix);
            }
            returnValue = sb.toString();
        }
        return returnValue;
    }

    @Override
    protected AnnotationDB createAnnotationDB() {
        AnnotationDB db = new AnnotationDB();
        db.setScanClassAnnotations(true);
        db.setScanMethodAnnotations(false);
        db.setScanParameterAnnotations(false);
        db.setScanFieldAnnotations(false);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Pattern temp = null;
        try {
            temp = Pattern.compile("(?s)^(['\"])(.+)\\1$");
        }
        catch (PatternSyntaxException kaboom) {
            kaboom.printStackTrace();
        }
        finally {
            quotePattern = temp;
        }
        DEFAULT_OUTPUT_FILENAME = String.format("%s.properties", DEFAULT_DEFAULT_PROPERTY_NAME);
        DEFAULT_SUBDIR_PREFIX = String.format("generated-test-sources%1$sjpa-maven-plugin", File.separator);
        JPA_ANNOTATIONS = Arrays.asList(Entity.class.getName(), MappedSuperclass.class.getName(), Embeddable.class.getName(), IdClass.class.getName());
    }
}

