/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.ec.graph;

import com.eduworks.ec.array.EcArray;
import com.eduworks.ec.graph.Graph;
import com.eduworks.ec.graph.Triple;
import org.stjs.javascript.Array;

public abstract class EcDirectedGraph<V, E>
implements Graph<V, E> {
    Array<Triple<V, V, E>> edges = new Array();
    Array<V> verticies = new Array();

    @Override
    public Array<E> getEdges() {
        Array results = new Array();
        for (int i = 0; i < this.edges.$length(); ++i) {
            results.$set(i, ((Triple)this.edges.$get((int)i)).edge);
        }
        return results;
    }

    @Override
    public Array<V> getVertices() {
        Array results = new Array();
        for (int i = 0; i < this.verticies.$length(); ++i) {
            results.$set(i, this.verticies.$get(i));
        }
        return results;
    }

    @Override
    public boolean containsVertex(V vertex) {
        for (int i = 0; i < this.verticies.$length(); ++i) {
            if (!vertex.equals(this.verticies.$get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEdge(E edge) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!edge.equals(((Triple)this.edges.$get((int)i)).edge)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEdgeCount() {
        return this.edges.$length();
    }

    @Override
    public int getVertexCount() {
        return this.verticies.$length();
    }

    @Override
    public Array<V> getNeighbors(V vertex) {
        Array results = new Array();
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (vertex.equals(((Triple)this.edges.$get((int)i)).source)) {
                results.push(new Object[]{((Triple)this.edges.$get((int)i)).destination});
                continue;
            }
            if (!vertex.equals(((Triple)this.edges.$get((int)i)).destination)) continue;
            results.push(new Object[]{((Triple)this.edges.$get((int)i)).source});
        }
        EcArray.removeDuplicates(results);
        return results;
    }

    @Override
    public Array<E> getIncidentEdges(V vertex) {
        Array results = new Array();
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (vertex.equals(((Triple)this.edges.$get((int)i)).source)) {
                results.push(new Object[]{((Triple)this.edges.$get((int)i)).edge});
                continue;
            }
            if (!vertex.equals(((Triple)this.edges.$get((int)i)).destination)) continue;
            results.push(new Object[]{((Triple)this.edges.$get((int)i)).edge});
        }
        EcArray.removeDuplicates(results);
        return results;
    }

    @Override
    public Array<V> getIncidentVertices(E edge) {
        Array results = new Array();
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!edge.equals(((Triple)this.edges.$get((int)i)).edge)) continue;
            results.push(new Object[]{((Triple)this.edges.$get((int)i)).source});
            results.push(new Object[]{((Triple)this.edges.$get((int)i)).destination});
        }
        EcArray.removeDuplicates(results);
        return results;
    }

    @Override
    public E findEdge(V v1, V v2) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (v1.equals(((Triple)this.edges.$get((int)i)).source) && v2.equals(((Triple)this.edges.$get((int)i)).destination)) {
                return (E)((Triple)this.edges.$get((int)i)).edge;
            }
            if (!v1.equals(((Triple)this.edges.$get((int)i)).destination) || !v2.equals(((Triple)this.edges.$get((int)i)).source)) continue;
            return (E)((Triple)this.edges.$get((int)i)).edge;
        }
        return null;
    }

    @Override
    public Array<E> findEdgeSet(V v1, V v2) {
        Array results = new Array();
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (v1.equals(((Triple)this.edges.$get((int)i)).source) && v2.equals(((Triple)this.edges.$get((int)i)).destination)) {
                results.push(new Object[]{((Triple)this.edges.$get((int)i)).edge});
            }
            if (!v1.equals(((Triple)this.edges.$get((int)i)).destination) || !v2.equals(((Triple)this.edges.$get((int)i)).source)) continue;
            results.push(new Object[]{((Triple)this.edges.$get((int)i)).edge});
        }
        return results;
    }

    @Override
    public boolean addVertex(V vertex) {
        this.verticies.push(new Object[]{vertex});
        return true;
    }

    public boolean addVertexSafely(V vertex) {
        if (EcArray.has(this.verticies, vertex)) {
            return false;
        }
        this.verticies.push(new Object[]{vertex});
        return true;
    }

    @Override
    public boolean removeVertex(V vertex) {
        int indexOf = EcArray.indexOf(this.verticies, vertex);
        if (indexOf != -1) {
            for (int i = 0; i < this.edges.$length(); ++i) {
                if (!((Triple)this.edges.$get((int)i)).source.equals(vertex) && !((Triple)this.edges.$get((int)i)).destination.equals(vertex)) continue;
                this.edges.splice(i, 1);
                --i;
            }
            this.verticies.splice(indexOf, 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEdge(E edge) {
        boolean success = false;
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!((Triple)this.edges.$get((int)i)).edge.equals(edge)) continue;
            this.edges.splice(i, 1);
            --i;
            success = true;
        }
        return success;
    }

    @Override
    public boolean isNeighbor(V v1, V v2) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (v1.equals(((Triple)this.edges.$get((int)i)).source) && v2.equals(((Triple)this.edges.$get((int)i)).destination)) {
                return true;
            }
            if (!v1.equals(((Triple)this.edges.$get((int)i)).destination) || !v2.equals(((Triple)this.edges.$get((int)i)).source)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIncident(V vertex, E edge) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!vertex.equals(((Triple)this.edges.$get((int)i)).source) && !vertex.equals(((Triple)this.edges.$get((int)i)).destination) || !edge.equals(((Triple)this.edges.$get((int)i)).edge)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int degree(V vertex) {
        int count = 0;
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!vertex.equals(((Triple)this.edges.$get((int)i)).source) && !vertex.equals(((Triple)this.edges.$get((int)i)).destination)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getNeighborCount(V vertex) {
        return this.getNeighbors(vertex).$length();
    }

    @Override
    public int getIncidentCount(E edge) {
        return this.getIncidentVertices(edge).$length();
    }

    @Override
    public abstract String getEdgeType(E var1);

    @Override
    public abstract String getDefaultEdgeType();

    @Override
    public Array<E> getEdgesOfType(String edge_type) {
        Array results = new Array();
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (this.getEdgeType(((Triple)this.edges.$get((int)i)).edge) != edge_type) continue;
            results.push(new Object[]{((Triple)this.edges.$get((int)i)).edge});
        }
        return results;
    }

    @Override
    public int getEdgeCountOfType(String edge_type) {
        return this.getEdgesOfType(edge_type).$length();
    }

    @Override
    public Array<E> getInEdges(V vertex) {
        Array results = new Array();
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!vertex.equals(((Triple)this.edges.$get((int)i)).destination)) continue;
            results.push(new Object[]{((Triple)this.edges.$get((int)i)).edge});
        }
        EcArray.removeDuplicates(results);
        return results;
    }

    @Override
    public Array<E> getOutEdges(V vertex) {
        Array results = new Array();
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!vertex.equals(((Triple)this.edges.$get((int)i)).source)) continue;
            results.push(new Object[]{((Triple)this.edges.$get((int)i)).edge});
        }
        EcArray.removeDuplicates(results);
        return results;
    }

    @Override
    public int inDegree(V vertex) {
        return this.getInEdges(vertex).$length();
    }

    @Override
    public int outDegree(V vertex) {
        return this.getOutEdges(vertex).$length();
    }

    @Override
    public V getSource(E directed_edge) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!directed_edge.equals(((Triple)this.edges.$get((int)i)).edge)) continue;
            return (V)((Triple)this.edges.$get((int)i)).source;
        }
        return null;
    }

    @Override
    public V getDest(E directed_edge) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!directed_edge.equals(((Triple)this.edges.$get((int)i)).edge)) continue;
            return (V)((Triple)this.edges.$get((int)i)).destination;
        }
        return null;
    }

    @Override
    public Array<V> getPredecessors(V vertex) {
        Array results = new Array();
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!vertex.equals(((Triple)this.edges.$get((int)i)).destination)) continue;
            results.push(new Object[]{((Triple)this.edges.$get((int)i)).source});
        }
        EcArray.removeDuplicates(results);
        return results;
    }

    @Override
    public Array<V> getSuccessors(V vertex) {
        Array results = new Array();
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!vertex.equals(((Triple)this.edges.$get((int)i)).source)) continue;
            results.push(new Object[]{((Triple)this.edges.$get((int)i)).destination});
        }
        EcArray.removeDuplicates(results);
        return results;
    }

    @Override
    public boolean isPredecessor(V v1, V v2) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!v1.equals(((Triple)this.edges.$get((int)i)).destination) || !v2.equals(((Triple)this.edges.$get((int)i)).source)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuccessor(V v1, V v2) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!v2.equals(((Triple)this.edges.$get((int)i)).destination) || !v1.equals(((Triple)this.edges.$get((int)i)).source)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPredecessorCount(V vertex) {
        return this.getPredecessors(vertex).$length();
    }

    @Override
    public int getSuccessorCount(V vertex) {
        return this.getSuccessors(vertex).$length();
    }

    @Override
    public boolean isSource(V vertex, E edge) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!edge.equals(((Triple)this.edges.$get((int)i)).edge) || !vertex.equals(((Triple)this.edges.$get((int)i)).source)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDest(V vertex, E edge) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!edge.equals(((Triple)this.edges.$get((int)i)).edge) || !vertex.equals(((Triple)this.edges.$get((int)i)).destination)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addEdge(E e, V v1, V v2) {
        this.addVertexSafely(v1);
        this.addVertexSafely(v2);
        Triple t = new Triple();
        t.source = v1;
        t.destination = v2;
        t.edge = e;
        this.edges.push((Object[])new Triple[]{t});
        return true;
    }

    public boolean addEdgeUnsafely(E e, V v1, V v2) {
        Triple t = new Triple();
        t.source = v1;
        t.destination = v2;
        t.edge = e;
        this.edges.push((Object[])new Triple[]{t});
        return true;
    }

    public boolean addEdgeSafely(E e, V v1, V v2) {
        this.addVertexSafely(v1);
        this.addVertexSafely(v2);
        Triple t = new Triple();
        t.source = v1;
        t.destination = v2;
        t.edge = e;
        if (EcArray.has(this.edges, t)) {
            return false;
        }
        this.edges.push((Object[])new Triple[]{t});
        return true;
    }

    @Override
    public V getOpposite(V vertex, E edge) {
        for (int i = 0; i < this.edges.$length(); ++i) {
            if (!edge.equals(((Triple)this.edges.$get((int)i)).edge)) continue;
            if (vertex.equals(((Triple)this.edges.$get((int)i)).destination)) {
                return (V)((Triple)this.edges.$get((int)i)).source;
            }
            if (!vertex.equals(((Triple)this.edges.$get((int)i)).source)) continue;
            return (V)((Triple)this.edges.$get((int)i)).destination;
        }
        return null;
    }
}

