var EcLoginCredentials = function(username, password) {
    this.userId = username;
    this.password = password;
};
EcLoginCredentials = stjs.extend(EcLoginCredentials, null, [], function(constructor, prototype) {
    prototype.userId = null;
    prototype.password = null;
}, {}, {});
var UserManager = function() {};
UserManager = stjs.extend(UserManager, null, [], function(constructor, prototype) {
    constructor.CREATE = "create";
    constructor.selectedServer = "http://localhost:9722/api";
    constructor.setServer = function(server) {
        UserManager.selectedServer = server;
    };
    constructor.createUser = function(username, password, success, fail) {
        var data = {"userId": username, "password": password};
        var fd = new FormData();
        fd.append("user", JSON.stringify(data));
        EcRemote.postExpectingObject(UserManager.selectedServer, UserManager.CREATE, fd, success, fail);
    };
}, {}, {});
var User = function(id, loginDate, ip) {
    this.userId = id;
    this.lastLogin = new Date(parseInt(loginDate));
    this.lastIp = ip;
};
User = stjs.extend(User, null, [], function(constructor, prototype) {
    prototype.userId = null;
    prototype.lastLogin = null;
    prototype.lastIp = null;
    constructor._parse = function(obj) {
        if (obj == null) 
            return null;
        var userId, loginDate, lastIp;
        userId = (obj)["userId"];
        loginDate = (obj)["lastLogin"];
        lastIp = (obj)["lastIp"];
        return new User(userId, loginDate, lastIp);
    };
    constructor.createUser = function(username, password, success, failure) {
        UserManager.createUser(username, password, function(p1) {
            if (success != null) 
                success(p1);
        }, failure);
    };
    prototype.getUserId = function() {
        return this.userId;
    };
    prototype.getLastLogin = function() {
        return this.lastLogin;
    };
    prototype.getLastIp = function() {
        return this.lastIp;
    };
}, {lastLogin: "Date"}, {});
/**
 *  Manages the Current User and SessionId information, stores the sessionId in the browser session storage
 *  for now (we could change this or try setting it on startup later).
 * 
 *  @author djunker
 */
var SessionManager = function() {};
SessionManager = stjs.extend(SessionManager, null, [], function(constructor, prototype) {
    constructor.LOGIN = "login";
    constructor.selectedServer = "http://localhost:9722/api";
    constructor.sessionId = "";
    constructor.isLoggedIn = false;
    constructor.currentUser = null;
    constructor.setServer = function(server) {
        SessionManager.selectedServer = server;
    };
    constructor.getSessionId = function() {
        if (SessionManager.sessionId == null) {
            SessionManager.sessionId = sessionStorage["ecSessionId"];
        }
        return SessionManager.sessionId;
    };
    constructor.setSessionId = function(id) {
        SessionManager.sessionId = id;
        sessionStorage["ecSessionId"] = SessionManager.sessionId;
    };
    constructor.clearSessionId = function() {
        delete sessionStorage["ecSessionId"];
    };
    constructor.getLoggedIn = function() {
        return SessionManager.isLoggedIn;
    };
    constructor.getCurrentUser = function() {
        if (SessionManager.currentUser == null) {
            var userObj = sessionStorage["currentUser"];
            if (userObj != null) 
                SessionManager.currentUser = User._parse(JSON.parse(userObj));
        }
        return SessionManager.currentUser;
    };
    constructor.setCurrentUser = function(user) {
        SessionManager.currentUser = user;
        sessionStorage["currentUser"] = JSON.stringify(SessionManager.currentUser);
    };
    constructor.clearCurrentUser = function() {
        SessionManager.currentUser = null;
        delete sessionStorage["currentUser"];
    };
    constructor.login = function(username, password, success, fail) {
        var c = new EcLoginCredentials(username, password);
        var fd = new FormData();
        fd.append("user", JSON.stringify(c));
        EcRemote.postExpectingObject(SessionManager.selectedServer, SessionManager.LOGIN, fd, function(object) {
            SessionManager.setSessionId((object)["sessionId"]);
            SessionManager.setCurrentUser(User._parse(object));
            SessionManager.isLoggedIn = true;
            if (success != null) 
                success(object);
        }, function(p1) {
            SessionManager.clearSessionId();
            SessionManager.clearCurrentUser();
            SessionManager.isLoggedIn = false;
            if (fail != null) 
                fail(p1);
        });
    };
    constructor.logout = function(success, fail) {
        SessionManager.clearCurrentUser();
        if (success != null) 
            success(null);
    };
}, {currentUser: "User"}, {});
(function() {
    SessionManager.sessionId = sessionStorage["ecSessionId"];
    var userObj = sessionStorage["currentUser"];
    if (userObj != null && SessionManager.sessionId != null) {
        SessionManager.isLoggedIn = true;
        SessionManager.currentUser = User._parse(JSON.parse(userObj));
    }
})();
/**
 *  Session
 * 
 *  @author djunker
 */
var Session = function() {};
Session = stjs.extend(Session, null, [], function(constructor, prototype) {
    constructor.login = function(username, password, success, failure) {
        SessionManager.login(username, password, success, failure);
    };
    constructor.logout = function(success, failure) {
        SessionManager.logout(success, failure);
    };
}, {}, {});
