/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jsat.ARFFLoader;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.calibration.BinaryCalibration;
import jsat.classifiers.calibration.PlattCalibration;
import jsat.classifiers.svm.PlattSMO;
import jsat.datatransform.Imputer;

public class ARffLoadTest {
    private static String __tfidf_scaler_name;
    private static String __cal_name;
    private static PlattCalibration __cal;

    public static void loadClassifiers(String pickle_dir) {
        try {
            FileInputStream fileIn3 = new FileInputStream(__cal_name);
            ObjectInputStream in3 = new ObjectInputStream(fileIn3);
            __cal = (PlattCalibration)in3.readObject();
            in3.close();
            fileIn3.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        String path = "/Users/eman7613/Dropbox/ARFF DataSets/uci/nominal/";
        String train = "breast-w.arff";
        ClassificationDataSet trainSet = new ClassificationDataSet(ARFFLoader.loadArffFile(new File(path, train)), 0);
        System.out.println(trainSet.countMissingValues());
        trainSet.applyTransform(new Imputer(trainSet));
        double C = 1.0;
        PlattSMO svc = new PlattSMO();
        svc.setC(C);
        __cal = new PlattCalibration(svc, BinaryCalibration.CalibrationMode.CV);
        __cal.setCalibrationFolds(2);
        __cal.trainC(trainSet);
        try {
            FileOutputStream fout1 = new FileOutputStream(__cal_name);
            ObjectOutputStream oos1 = new ObjectOutputStream(fout1);
            oos1.writeObject(__cal);
            oos1.close();
            fout1.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ARffLoadTest.loadClassifiers(__cal_name);
        for (int i = 0; i < trainSet.getSampleSize(); ++i) {
            __cal.classify(trainSet.getDataPoint(i));
        }
    }

    static {
        __cal_name = "cal.pkl";
    }
}

