/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashSet;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.classifiers.DataPoint;
import jsat.io.CSV;

public class LoadingDataSetExample {
    public static void main(String[] args) throws IOException {
        int i;
        Path chemin = FileSystems.getDefault().getPath("codes.csv", new String[0]);
        HashSet<Integer> cat_cols = new HashSet<Integer>();
        cat_cols.add(0);
        cat_cols.add(1);
        SimpleDataSet dataSet = CSV.read(chemin, 1, cat_cols);
        System.out.println("There are " + dataSet.getNumFeatures() + " features for this data set.");
        System.out.println(dataSet.getNumCategoricalVars() + " categorical features");
        System.out.println("They are:");
        for (i = 0; i < dataSet.getNumCategoricalVars(); ++i) {
            System.out.println("\t" + dataSet.getCategoryName(i));
        }
        System.out.println(dataSet.getNumNumericalVars() + " numerical features");
        System.out.println("They are:");
        for (i = 0; i < dataSet.getNumNumericalVars(); ++i) {
            System.out.println("\t" + dataSet.getNumericName(i));
        }
        System.out.println("\nThe whole data set");
        for (i = 0; i < ((DataSet)dataSet).getSampleSize(); ++i) {
            DataPoint dataPoint = ((DataSet)dataSet).getDataPoint(i);
            System.out.println(dataPoint);
        }
    }
}

