/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.boosting;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.MajorityVote;
import jsat.classifiers.boosting.AdaBoostM1;
import jsat.exceptions.FailedToFitException;
import jsat.utils.DoubleList;
import jsat.utils.IndexTable;
import jsat.utils.SystemInfo;

public class AdaBoostM1PL
extends AdaBoostM1 {
    private static final long serialVersionUID = 1027211688101553766L;

    public AdaBoostM1PL(Classifier weakLearner, int maxIterations) {
        super(weakLearner, maxIterations);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trainC(ClassificationDataSet dataSet, ExecutorService threadPool) {
        this.predicting = dataSet.getPredicting();
        ArrayList<Future<AdaBoostM1>> futureBoostings = new ArrayList<Future<AdaBoostM1>>(SystemInfo.LogicalCores);
        List subSets = dataSet.cvSet(SystemInfo.LogicalCores);
        for (int i = 0; i < SystemInfo.LogicalCores; ++i) {
            final AdaBoostM1 learner = new AdaBoostM1(this.getWeakLearner().clone(), this.getMaxIterations());
            final ClassificationDataSet subDataSet = (ClassificationDataSet)subSets.get(i);
            futureBoostings.add(threadPool.submit(new Callable<AdaBoostM1>(){

                @Override
                public AdaBoostM1 call() throws Exception {
                    learner.trainC(subDataSet);
                    return learner;
                }
            }));
        }
        try {
            void var10_15;
            ArrayList<AdaBoostM1> boosts = new ArrayList<AdaBoostM1>(SystemInfo.LogicalCores);
            ArrayList<List<Double>> boostWeights = new ArrayList<List<Double>>(SystemInfo.LogicalCores);
            ArrayList<List<Classifier>> boostWeakLearners = new ArrayList<List<Classifier>>(SystemInfo.LogicalCores);
            ArrayList<IndexTable> sortedViews = new ArrayList<IndexTable>(SystemInfo.LogicalCores);
            for (Future future : futureBoostings) {
                AdaBoostM1 boost = (AdaBoostM1)future.get();
                boosts.add(boost);
                sortedViews.add(new IndexTable(boost.hypWeights));
                boostWeights.add(boost.hypWeights);
                boostWeakLearners.add(boost.hypoths);
            }
            int T = ((AdaBoostM1)boosts.get(0)).getMaxIterations();
            this.hypoths = new ArrayList(T);
            this.hypWeights = new DoubleList(T);
            boolean bl = false;
            while (var10_15 < T) {
                Classifier[] toMerge = new Classifier[SystemInfo.LogicalCores];
                double weight = 0.0;
                for (int m = 0; m < SystemInfo.LogicalCores; ++m) {
                    int mSortedIndex = ((IndexTable)sortedViews.get(m)).index((int)var10_15);
                    toMerge[m] = (Classifier)((List)boostWeakLearners.get(m)).get(mSortedIndex);
                    weight += ((Double)((List)boostWeights.get(m)).get(mSortedIndex)).doubleValue();
                }
                this.hypWeights.add(weight /= (double)SystemInfo.LogicalCores);
                this.hypoths.add(new MajorityVote(toMerge));
                ++var10_15;
            }
        }
        catch (Exception ex) {
            throw new FailedToFitException(ex);
        }
    }

    @Override
    public void trainC(ClassificationDataSet dataSet) {
        super.trainC(dataSet, null);
    }

    @Override
    public AdaBoostM1PL clone() {
        AdaBoostM1PL copy = new AdaBoostM1PL(this.getWeakLearner().clone(), this.getMaxIterations());
        if (this.hypWeights != null) {
            copy.hypWeights = new DoubleList(this.hypWeights);
        }
        if (this.hypoths != null) {
            copy.hypoths = new ArrayList(this.hypoths.size());
            for (int i = 0; i < this.hypoths.size(); ++i) {
                copy.hypoths.add(((Classifier)this.hypoths.get(i)).clone());
            }
        }
        if (this.predicting != null) {
            copy.predicting = this.predicting.clone();
        }
        return copy;
    }
}

