/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.boosting;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.boosting.LogitBoost;
import jsat.exceptions.FailedToFitException;
import jsat.regression.Regressor;
import jsat.utils.SystemInfo;

public class LogitBoostPL
extends LogitBoost {
    private static final long serialVersionUID = -7932049860430324903L;

    public LogitBoostPL(Regressor baseLearner, int M) {
        super(baseLearner, M);
    }

    public LogitBoostPL(int M) {
        super(M);
    }

    @Override
    public void trainC(ClassificationDataSet dataSet, ExecutorService threadPool) {
        List subSets = dataSet.cvSet(SystemInfo.LogicalCores);
        ArrayList<Future<LogitBoost>> futuerBoosts = new ArrayList<Future<LogitBoost>>(SystemInfo.LogicalCores);
        for (int i = 0; i < SystemInfo.LogicalCores; ++i) {
            final ClassificationDataSet classificationDataSet = (ClassificationDataSet)subSets.get(i);
            futuerBoosts.add(threadPool.submit(new Callable<LogitBoost>(){

                @Override
                public LogitBoost call() throws Exception {
                    LogitBoost boost = new LogitBoost(LogitBoostPL.this.baseLearner.clone(), LogitBoostPL.this.getMaxIterations());
                    boost.trainC(classificationDataSet);
                    return boost;
                }
            }));
        }
        try {
            this.baseLearners = new ArrayList(SystemInfo.LogicalCores * this.getMaxIterations());
            this.fScaleConstant = 1.0 / (double)SystemInfo.LogicalCores;
            for (Future future : futuerBoosts) {
                this.baseLearners.addAll(((LogitBoost)future.get()).baseLearners);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new FailedToFitException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new FailedToFitException(executionException);
        }
    }

    @Override
    public LogitBoostPL clone() {
        LogitBoostPL clone = new LogitBoostPL(this.getMaxIterations());
        clone.setzMax(this.getzMax());
        if (this.baseLearner != null) {
            clone.baseLearner = this.baseLearner.clone();
        }
        if (this.baseLearners != null) {
            clone.baseLearners = new ArrayList(this.baseLearners.size());
            for (Regressor r : this.baseLearners) {
                clone.baseLearners.add(r.clone());
            }
        }
        return clone;
    }
}

