/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.neuralnetwork.initializers;

import java.util.Random;
import jsat.classifiers.neuralnetwork.initializers.BiastInitializer;
import jsat.linear.ConstantVector;
import jsat.linear.Vec;

public class ConstantInit
implements BiastInitializer {
    private static final long serialVersionUID = 2638413936718283757L;
    private double c;

    public ConstantInit(double c) {
        this.c = c;
    }

    public void setConstant(double c) {
        if (Double.isNaN(c) || Double.isInfinite(c)) {
            throw new IllegalArgumentException("Constant must be a real value, not " + c);
        }
        this.c = c;
    }

    public double getConstant() {
        return this.c;
    }

    @Override
    public void init(Vec b, int fanIn, Random rand) {
        new ConstantVector(this.c, b.length()).copyTo(b);
    }

    @Override
    public ConstantInit clone() {
        return new ConstantInit(this.c);
    }
}

