/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import jsat.DataSet;
import jsat.clustering.ClustererBase;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.VPTreeMV;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.linear.vectorcollection.VectorCollectionUtils;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;
import jsat.utils.DoubleList;
import jsat.utils.FakeExecutor;
import jsat.utils.IntList;
import jsat.utils.Pair;
import jsat.utils.UnionFind;

public class HDBSCAN_dev
extends ClustererBase
implements Parameterized {
    private DistanceMetric dm;
    private int m_pts;
    private int m_clSize;
    private VectorCollectionFactory<Vec> vcf;

    public HDBSCAN_dev() {
        this(15);
    }

    public HDBSCAN_dev(int m_pts) {
        this(new EuclideanDistance(), m_pts);
    }

    public HDBSCAN_dev(DistanceMetric dm, int m_pts) {
        this(dm, m_pts, m_pts, new VPTreeMV.VPTreeMVFactory<Vec>());
    }

    public HDBSCAN_dev(DistanceMetric dm, int m_pts, VectorCollectionFactory<Vec> vcf) {
        this(dm, m_pts, m_pts, vcf);
    }

    public HDBSCAN_dev(DistanceMetric dm, int m_pts, int m_clSize, VectorCollectionFactory<Vec> vcf) {
        this.dm = dm;
        this.m_pts = m_pts;
        this.m_clSize = m_clSize;
        this.vcf = vcf;
    }

    public HDBSCAN_dev(HDBSCAN_dev toCopy) {
        this.dm = this.dm.clone();
        this.m_pts = toCopy.m_pts;
        this.m_clSize = toCopy.m_clSize;
        this.vcf = toCopy.vcf.clone();
    }

    public void setMinClusterSize(int m_clSize) {
        this.m_clSize = m_clSize;
    }

    public int getMinClusterSize() {
        return this.m_clSize;
    }

    public void setDistanceMetrics(DistanceMetric dm) {
        this.dm = dm;
    }

    public DistanceMetric getDistanceMetrics() {
        return this.dm;
    }

    public void setMinPoints(int m_pts) {
        this.m_pts = m_pts;
    }

    public int getMinPoints() {
        return this.m_pts;
    }

    @Override
    public HDBSCAN_dev clone() {
        return new HDBSCAN_dev(this);
    }

    @Override
    public int[] cluster(DataSet dataSet, int[] designations) {
        return this.cluster(dataSet, new FakeExecutor(), designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, ExecutorService threadpool, int[] designations) {
        int i;
        if (designations == null) {
            designations = new int[dataSet.getSampleSize()];
        }
        List<Vec> X = dataSet.getDataVectors();
        int N = X.size();
        List<Double> cache = this.dm.getAccelerationCache(X, threadpool);
        VectorCollection<Vec> X_vc = this.vcf.getVectorCollection(X, this.dm, threadpool);
        List<List<VecPaired<Vec, Double>>> allNearestNeighbors = VectorCollectionUtils.allNearestNeighbors(X_vc, X, this.m_pts, threadpool);
        double[] core = new double[N];
        for (int i2 = 0; i2 < N; ++i2) {
            core[i2] = allNearestNeighbors.get(i2).get(this.m_pts - 1).getPair();
        }
        int[] componentID = new int[N];
        for (int i3 = 0; i3 < N; ++i3) {
            componentID[i3] = i3;
        }
        ArrayList<IntList> componentMembers = new ArrayList<IntList>(N);
        for (int i4 = 0; i4 < N; ++i4) {
            componentMembers.add(new IntList(Arrays.asList(i4)));
        }
        ArrayList<UnionFind<Integer>> components = new ArrayList<UnionFind<Integer>>(N);
        for (int i5 = 0; i5 < N; ++i5) {
            components.add(new UnionFind<Integer>(i5));
        }
        boolean[] toSkip = new boolean[N];
        Arrays.fill(toSkip, false);
        boolean mst_done = false;
        MRTDist mrt_dist = new MRTDist(this.dm, core, X, cache);
        HashSet<Edge> mst_edges = new HashSet<Edge>(N);
        while (!mst_done) {
            for (IntList C : componentMembers) {
                if (C.isEmpty()) continue;
                Iterator iterator = C.iterator();
                while (iterator.hasNext()) {
                    int member = (Integer)iterator.next();
                    toSkip[member] = true;
                }
                double minDist = Double.POSITIVE_INFINITY;
                int min_id = -1;
                int member_winner = -1;
                Iterator iterator2 = C.iterator();
                while (iterator2.hasNext()) {
                    int member = (Integer)iterator2.next();
                }
                if (min_id == member_winner) {
                    System.out.println("WAT");
                }
                UnionFind otherComponentUnion = (UnionFind)components.get(min_id);
                ((UnionFind)components.get(C.get(0))).union(otherComponentUnion);
                mst_edges.add(new Edge(min_id, member_winner, minDist));
                Iterator member = C.iterator();
                while (member.hasNext()) {
                    int member2 = (Integer)member.next();
                    toSkip[member2] = false;
                }
            }
            HashSet<Integer> uniqRemainingComponents = new HashSet<Integer>();
            for (i = 0; i < N; ++i) {
                componentID[i] = (Integer)((UnionFind)components.get(i)).find().getItem();
                uniqRemainingComponents.add(componentID[i]);
                if (componentMembers.get(i) == null) continue;
                ((IntList)componentMembers.get(i)).clear();
            }
            for (i = 0; i < N; ++i) {
                ((IntList)componentMembers.get(componentID[i])).add(i);
            }
            mst_done = uniqRemainingComponents.size() == 1;
            System.out.println(uniqRemainingComponents.size());
        }
        ArrayList<UnionFind<Integer>> ufs = new ArrayList<UnionFind<Integer>>(N);
        for (i = 0; i < N; ++i) {
            ufs.add(new UnionFind<Integer>(i));
        }
        PriorityQueue<Edge> edgeQ = new PriorityQueue<Edge>(2 * N, new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                return Double.compare(o1.weight, o2.weight);
            }
        });
        edgeQ.addAll(mst_edges);
        ArrayList<IntList> currentGroups = new ArrayList<IntList>();
        for (int i6 = 0; i6 < N; ++i6) {
            IntList il = new IntList(1);
            il.add(i6);
            currentGroups.add(il);
        }
        int next_cluster_label = 0;
        ArrayList cluster_options = new ArrayList();
        ArrayList<DoubleList> entry_size = new ArrayList<DoubleList>();
        DoubleList birthSize = new DoubleList();
        DoubleList deathSize = new DoubleList();
        ArrayList<Pair<Integer, Integer>> children = new ArrayList<Pair<Integer, Integer>>();
        int[] map_to_cluster_label = new int[N];
        Arrays.fill(map_to_cluster_label, -1);
        while (!edgeQ.isEmpty()) {
            int i7;
            DoubleList dl;
            int otherClust;
            int mergedClust;
            Edge edge = edgeQ.poll();
            double weight = edge.weight;
            int from = edge.getX();
            int to = edge.getY();
            if (to == from) continue;
            UnionFind union_from = (UnionFind)ufs.get(from);
            UnionFind union_to = (UnionFind)ufs.get(to);
            int clust_A = (Integer)union_from.find().getItem();
            int clust_B = (Integer)union_to.find().getItem();
            UnionFind clust_A_tmp = union_from.find();
            UnionFind clust_B_tmp = union_to.find();
            union_from.union(union_to);
            int a_size = ((List)currentGroups.get(clust_A)).size();
            int b_size = ((List)currentGroups.get(clust_B)).size();
            int new_size = a_size + b_size;
            if ((Integer)union_from.find().getItem() == clust_A) {
                mergedClust = clust_A;
                otherClust = clust_B;
            } else {
                mergedClust = clust_B;
                otherClust = clust_A;
            }
            if (mergedClust == otherClust) continue;
            if (new_size >= this.m_clSize && a_size < this.m_clSize && b_size < this.m_clSize) {
                cluster_options.add(currentGroups.get(mergedClust));
                dl = new DoubleList(new_size);
                for (i7 = 0; i7 < new_size; ++i7) {
                    dl.add(weight);
                }
                entry_size.add(dl);
                children.add(null);
                birthSize.add(weight);
                deathSize.add(Double.MAX_VALUE);
                map_to_cluster_label[mergedClust] = next_cluster_label++;
            } else if (new_size >= this.m_clSize && a_size >= this.m_clSize && b_size >= this.m_clSize) {
                deathSize.set(map_to_cluster_label[mergedClust], weight);
                deathSize.set(map_to_cluster_label[otherClust], weight);
                currentGroups.set(mergedClust, new IntList((Collection)currentGroups.get(mergedClust)));
                cluster_options.add(currentGroups.get(mergedClust));
                dl = new DoubleList(new_size);
                for (i7 = 0; i7 < new_size; ++i7) {
                    dl.add(weight);
                }
                entry_size.add(dl);
                children.add(new Pair<Integer, Integer>(map_to_cluster_label[mergedClust], map_to_cluster_label[otherClust]));
                birthSize.add(weight);
                deathSize.add(Double.MAX_VALUE);
                map_to_cluster_label[mergedClust] = next_cluster_label++;
            } else if (new_size >= this.m_clSize) {
                if (map_to_cluster_label[mergedClust] == -1) {
                    int c = map_to_cluster_label[mergedClust] = map_to_cluster_label[otherClust];
                    cluster_options.set(c, currentGroups.get(mergedClust));
                    map_to_cluster_label[otherClust] = -1;
                }
                Iterator iterator = ((List)currentGroups.get(otherClust)).iterator();
                while (iterator.hasNext()) {
                    int indx = (Integer)iterator.next();
                    try {
                        ((DoubleList)entry_size.get(map_to_cluster_label[mergedClust])).add(weight);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            ((List)currentGroups.get(mergedClust)).addAll((Collection)currentGroups.get(otherClust));
            currentGroups.set(otherClust, null);
        }
        cluster_options.remove(cluster_options.size() - 1);
        entry_size.remove(entry_size.size() - 1);
        birthSize.remove(birthSize.size() - 1);
        deathSize.remove(deathSize.size() - 1);
        children.remove(children.size() - 1);
        double[] S = new double[cluster_options.size()];
        for (int c = 0; c < S.length; ++c) {
            double lambda_min = birthSize.getD(c);
            double lambda_max = deathSize.getD(c);
            double s = 0.0;
            Iterator clust_B = ((DoubleList)entry_size.get(c)).iterator();
            while (clust_B.hasNext()) {
                double f_x = (Double)clust_B.next();
                s += Math.min(f_x, lambda_max) - lambda_min;
            }
            S[c] = s;
        }
        boolean[] toKeep = new boolean[S.length];
        double[] S_hat = new double[cluster_options.size()];
        Arrays.fill(toKeep, true);
        ArrayDeque<Integer> notKeeping = new ArrayDeque<Integer>();
        for (int i8 = 0; i8 < S.length; ++i8) {
            int ir;
            Pair child = (Pair)children.get(i8);
            if (child == null) {
                S_hat[i8] = S[i8];
                continue;
            }
            int il = (Integer)child.getFirstItem();
            if (S[i8] < S_hat[il] + S_hat[ir = ((Integer)child.getSecondItem()).intValue()]) {
                S_hat[i8] = S_hat[il] + S_hat[ir];
                toKeep[i8] = false;
                continue;
            }
            S_hat[i8] = S[i8];
            notKeeping.add(il);
            notKeeping.add(ir);
            while (!notKeeping.isEmpty()) {
                int c = (Integer)notKeeping.poll();
                toKeep[c] = false;
                Pair c_children = (Pair)children.get(c);
                if (c_children == null) continue;
                notKeeping.add((Integer)c_children.getFirstItem());
                notKeeping.add((Integer)c_children.getSecondItem());
            }
        }
        Arrays.fill(designations, 0, N, -1);
        int clusters = 0;
        for (int c = 0; c < toKeep.length; ++c) {
            if (!toKeep[c]) continue;
            Iterator iterator = ((List)cluster_options.get(c)).iterator();
            while (iterator.hasNext()) {
                int indx = (Integer)iterator.next();
                designations[indx] = clusters;
            }
            ++clusters;
        }
        return designations;
    }

    @Override
    public List<Parameter> getParameters() {
        return Parameter.getParamsFromMethods(this);
    }

    @Override
    public Parameter getParameter(String paramName) {
        return Parameter.toParameterMap(this.getParameters()).get(paramName);
    }

    private static class Edge {
        public int x;
        public int y;
        public double weight;

        public Edge() {
        }

        public Edge(int x, int y, double weight) {
            this.x = x;
            this.y = y;
            this.weight = weight;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Edge) {
                Edge other = (Edge)obj;
                if (this.x == other.x && this.y == other.y) {
                    return true;
                }
                if (this.x == other.y && this.y == other.x) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.x ^ this.y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.weight + ")";
        }
    }

    private static class MRTDist
    implements DistanceMetric {
        private final DistanceMetric baseD;
        private final double[] core;
        private List<? extends Vec> vecs;
        private List<Double> cache;
        public IdentityHashMap<Vec, Integer> vecToId;

        public MRTDist(DistanceMetric baseD, double[] coreDists, List<? extends Vec> vecs, List<Double> cache) {
            this.baseD = baseD;
            this.core = coreDists;
            this.vecs = vecs;
            this.cache = cache;
            this.vecToId = new IdentityHashMap(coreDists.length);
            for (int i = 0; i < vecs.size(); ++i) {
                this.vecToId.put(vecs.get(i), i);
            }
        }

        public MRTDist(MRTDist toCopy) {
            this.baseD = toCopy.baseD;
            this.core = toCopy.core;
            this.vecToId = toCopy.vecToId;
        }

        @Override
        public double dist(Vec a, Vec b) {
            int a_indx = this.vecToId.get(a);
            int b_indx = this.vecToId.get(b);
            return this.dist(a_indx, b_indx, this.vecs, this.cache);
        }

        @Override
        public boolean isSymmetric() {
            return this.baseD.isSymmetric();
        }

        @Override
        public boolean isSubadditive() {
            return this.baseD.isSubadditive();
        }

        @Override
        public boolean isIndiscemible() {
            return this.baseD.isIndiscemible();
        }

        @Override
        public double metricBound() {
            return this.baseD.metricBound();
        }

        @Override
        public boolean supportsAcceleration() {
            return this.baseD.supportsAcceleration();
        }

        @Override
        public List<Double> getAccelerationCache(List<? extends Vec> vecs) {
            return this.baseD.getAccelerationCache(vecs);
        }

        @Override
        public List<Double> getAccelerationCache(List<? extends Vec> vecs, ExecutorService threadpool) {
            return this.baseD.getAccelerationCache(vecs, threadpool);
        }

        @Override
        public double dist(int a, int b, List<? extends Vec> vecs, List<Double> cache) {
            return Math.max(this.core[a], Math.max(this.core[b], this.baseD.dist(a, b, vecs, cache)));
        }

        @Override
        public double dist(int a, Vec b, List<? extends Vec> vecs, List<Double> cache) {
            int b_indx = this.vecToId.get(b);
            return this.dist(a, b_indx, vecs, cache);
        }

        @Override
        public List<Double> getQueryInfo(Vec q) {
            return this.baseD.getQueryInfo(q);
        }

        @Override
        public double dist(int a, Vec b, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
            int b_indx = this.vecToId.get(b);
            return this.dist(a, b_indx, vecs, cache);
        }

        @Override
        public MRTDist clone() {
            return new MRTDist(this);
        }
    }
}

