/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.DataSet;
import jsat.clustering.KClustererBase;
import jsat.clustering.SeedSelectionMethods;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.distancemetrics.TrainableDistanceMetric;
import jsat.math.OnLineStatistics;
import jsat.utils.FakeExecutor;
import jsat.utils.SystemInfo;
import jsat.utils.random.RandomUtil;

public class PAM
extends KClustererBase {
    private static final long serialVersionUID = 4787649180692115514L;
    protected DistanceMetric dm;
    protected Random rand;
    protected SeedSelectionMethods.SeedSelection seedSelection;
    protected int repeats = 1;
    protected int iterLimit = 100;
    protected int[] medoids;
    protected boolean storeMedoids = true;

    public PAM(DistanceMetric dm, Random rand, SeedSelectionMethods.SeedSelection seedSelection) {
        this.dm = dm;
        this.rand = rand;
        this.seedSelection = seedSelection;
    }

    public PAM(DistanceMetric dm, Random rand) {
        this(dm, rand, SeedSelectionMethods.SeedSelection.KPP);
    }

    public PAM(DistanceMetric dm) {
        this(dm, RandomUtil.getRandom());
    }

    public PAM() {
        this(new EuclideanDistance());
    }

    public void setMaxIterations(int iterLimit) {
        this.iterLimit = iterLimit;
    }

    public int getMaxIterations() {
        return this.iterLimit;
    }

    public PAM(PAM toCopy) {
        this.dm = toCopy.dm.clone();
        this.rand = RandomUtil.getRandom();
        this.seedSelection = toCopy.seedSelection;
        if (toCopy.medoids != null) {
            this.medoids = Arrays.copyOf(toCopy.medoids, toCopy.medoids.length);
        }
        this.storeMedoids = toCopy.storeMedoids;
        this.iterLimit = toCopy.iterLimit;
        this.repeats = toCopy.repeats;
    }

    public void setStoreMedoids(boolean storeMedoids) {
        this.storeMedoids = storeMedoids;
    }

    public int[] getMedoids() {
        return this.medoids;
    }

    public void setSeedSelection(SeedSelectionMethods.SeedSelection seedSelection) {
        this.seedSelection = seedSelection;
    }

    public SeedSelectionMethods.SeedSelection getSeedSelection() {
        return this.seedSelection;
    }

    protected double cluster(DataSet data, boolean doInit, int[] medioids, int[] assignments, List<Double> cacheAccel) {
        double totalDistance = 0.0;
        int changes = -1;
        Arrays.fill(assignments, -1);
        int[] bestMedCand = new int[medioids.length];
        double[] bestMedCandDist = new double[medioids.length];
        List<Vec> X = data.getDataVectors();
        if (doInit) {
            TrainableDistanceMetric.trainIfNeeded(this.dm, data);
            cacheAccel = this.dm.getAccelerationCache(X);
            SeedSelectionMethods.selectIntialPoints(data, this.medoids, this.dm, cacheAccel, this.rand, this.seedSelection);
        }
        int iter = 0;
        do {
            int i;
            changes = 0;
            totalDistance = 0.0;
            for (i = 0; i < data.getSampleSize(); ++i) {
                Vec dpVec = data.getDataPoint(i).getNumericalValues();
                int assignment = 0;
                double minDist = this.dm.dist(medioids[0], i, X, cacheAccel);
                for (int k = 1; k < medioids.length; ++k) {
                    double dist = this.dm.dist(medioids[k], i, X, cacheAccel);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    assignment = k;
                }
                if (assignments[i] != assignment) {
                    ++changes;
                    assignments[i] = assignment;
                }
                totalDistance += minDist * minDist;
            }
            Arrays.fill(bestMedCandDist, Double.MAX_VALUE);
            for (i = 0; i < data.getSampleSize(); ++i) {
                double thisCandidateDistance = 0.0;
                int clusterID = assignments[i];
                int medCandadate = i;
                for (int j = 0; j < data.getSampleSize(); ++j) {
                    if (j == i || assignments[j] != clusterID) continue;
                    thisCandidateDistance += Math.pow(this.dm.dist(medCandadate, j, X, cacheAccel), 2.0);
                }
                if (!(thisCandidateDistance < bestMedCandDist[clusterID])) continue;
                bestMedCand[clusterID] = i;
                bestMedCandDist[clusterID] = thisCandidateDistance;
            }
            System.arraycopy(bestMedCand, 0, medioids, 0, medioids.length);
        } while (changes > 0 && iter++ < this.iterLimit);
        return totalDistance;
    }

    @Override
    public int[] cluster(DataSet dataSet, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.getSampleSize() / 2), designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.getSampleSize() / 2), threadpool, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, clusters, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, int[] designations) {
        if (designations == null) {
            designations = new int[dataSet.getSampleSize()];
        }
        this.medoids = new int[clusters];
        this.cluster(dataSet, true, this.medoids, designations, null);
        if (!this.storeMedoids) {
            this.medoids = null;
        }
        return designations;
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, int[] designations) {
        return this.cluster(dataSet, lowK, highK, new FakeExecutor(), designations);
    }

    @Override
    public PAM clone() {
        return new PAM(this);
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, ExecutorService threadpool, int[] designations) {
        double[] totDistances = new double[highK - lowK + 1];
        ArrayBlockingQueue<ClusterWorker> workerQue = new ArrayBlockingQueue<ClusterWorker>(SystemInfo.LogicalCores);
        for (int i = 0; i < SystemInfo.LogicalCores; ++i) {
            workerQue.add(new ClusterWorker(dataSet, workerQue));
        }
        int k = lowK;
        int received = 0;
        while (received < totDistances.length) {
            try {
                ClusterWorker worker = (ClusterWorker)workerQue.take();
                if (worker.getResult() != -1.0) {
                    totDistances[worker.getK() - lowK] = worker.getResult();
                    ++received;
                }
                if (k > highK) continue;
                worker.setMedioids(new int[k++]);
                threadpool.submit(worker);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PAM.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        OnLineStatistics stats = new OnLineStatistics();
        double maxChange = Double.MIN_VALUE;
        int maxChangeK = lowK;
        for (int i = 1; i < totDistances.length; ++i) {
            double change = Math.abs(totDistances[i] - totDistances[i - 1]);
            stats.add(change);
            if (!(change > maxChange)) continue;
            maxChange = change;
            maxChangeK = i + lowK;
        }
        if (maxChange < stats.getStandardDeviation() * 2.0 + stats.getMean()) {
            maxChangeK = lowK;
        }
        return this.cluster(dataSet, maxChangeK, designations);
    }

    private class ClusterWorker
    implements Runnable {
        private DataSet dataSet;
        private int[] assignments;
        private int[] medioids;
        private volatile double result = -1.0;
        private volatile BlockingQueue<ClusterWorker> putSelf;

        public ClusterWorker(DataSet dataSet, BlockingQueue<ClusterWorker> putSelf) {
            this.dataSet = dataSet;
            this.assignments = new int[dataSet.getSampleSize()];
            this.putSelf = putSelf;
        }

        public void setAssignments(int[] assignments) {
            this.assignments = assignments;
        }

        public void setMedioids(int[] medioids) {
            this.medioids = medioids;
        }

        public int getK() {
            return this.medioids.length;
        }

        public double getResult() {
            return this.result;
        }

        @Override
        public void run() {
            this.result = PAM.this.cluster(this.dataSet, true, this.medioids, this.assignments, null);
            this.putSelf.add(this);
        }
    }
}

