/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.evaluation.intra;

import java.util.List;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.evaluation.intra.IntraClusterEvaluation;
import jsat.linear.DenseVector;
import jsat.linear.MatrixStatistics;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;

public class MeanCentroidDistance
implements IntraClusterEvaluation {
    private DistanceMetric dm;

    public MeanCentroidDistance() {
        this(new EuclideanDistance());
    }

    public MeanCentroidDistance(DistanceMetric dm) {
        this.dm = dm;
    }

    public MeanCentroidDistance(MeanCentroidDistance toCopy) {
        this(toCopy.dm.clone());
    }

    @Override
    public double evaluate(int[] designations, DataSet dataSet, int clusterID) {
        DenseVector mean = new DenseVector(dataSet.getNumNumericalVars());
        int clusterSize = 0;
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            if (designations[i] != clusterID) continue;
            ++clusterSize;
            mean.mutableAdd(dataSet.getDataPoint(i).getNumericalValues());
        }
        ((Vec)mean).mutableDivide(clusterSize);
        double dists = 0.0;
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            if (designations[i] != clusterID) continue;
            dists += this.dm.dist(dataSet.getDataPoint(i).getNumericalValues(), mean);
        }
        return dists / (double)dataSet.getSampleSize();
    }

    @Override
    public double evaluate(List<DataPoint> dataPoints) {
        Vec mean = MatrixStatistics.meanVector(new SimpleDataSet(dataPoints));
        double dists = 0.0;
        for (DataPoint dp : dataPoints) {
            dists += this.dm.dist(dp.getNumericalValues(), mean);
        }
        return dists / (double)dataPoints.size();
    }

    @Override
    public MeanCentroidDistance clone() {
        return new MeanCentroidDistance(this);
    }
}

