/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;
import jsat.math.SpecialMath;

public class StudentT
extends ContinuousDistribution {
    private static final long serialVersionUID = -3157525461647767831L;
    double df;
    double mu;
    double sig;

    public StudentT(double df) {
        this(df, 0.0, 1.0);
    }

    public StudentT(double df, double mu, double sig) {
        this.df = df;
        this.mu = mu;
        this.sig = sig;
    }

    public void setDf(double df) {
        this.df = df;
    }

    @Override
    public double pdf(double t) {
        double leftSide = SpecialMath.lnGamma((this.df + 1.0) / 2.0) - SpecialMath.lnGamma(this.df / 2.0) - SpecialMath.lnGamma(this.df * Math.PI) / 2.0 - Math.log(this.sig);
        double rightSide = -(this.df + 1.0) / 2.0 * Math.log(1.0 + Math.pow((t - this.mu) / this.sig, 2.0) / this.df);
        return Math.exp(leftSide + rightSide);
    }

    @Override
    public double cdf(double t) {
        double x = this.df / (this.df + Math.pow((t - this.mu) / this.sig, 2.0));
        double p = SpecialMath.betaIncReg(x, this.df / 2.0, 0.5) / 2.0;
        if (t > this.mu) {
            return 1.0 - p;
        }
        return p;
    }

    @Override
    public double invCdf(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Probability must be in the range [0,1], not " + p);
        }
        double x = SpecialMath.invBetaIncReg(2.0 * Math.min(p, 1.0 - p), this.df / 2.0, 0.5);
        x = this.sig * Math.sqrt(this.df * (1.0 - x) / x);
        if (p >= 0.5) {
            return this.mu + x;
        }
        return this.mu - x;
    }

    @Override
    public double min() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDescriptiveName() {
        return "Student-T(df=" + this.df + ", \u03bc=" + this.mu + ", \u03c3=" + this.sig + ")";
    }

    @Override
    public String getDistributionName() {
        return "Student-T";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"df", "\u03bc", "\u03c3"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.df, this.mu, this.sig};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVariable(String var, double value) {
        if (var.equals("df")) {
            if (!(value > 0.0)) throw new ArithmeticException("Degrees of Fredom must be greater than 0");
            this.df = value;
            return;
        } else if (var.equals("\u03bc")) {
            this.mu = value;
            return;
        } else {
            if (!var.equals("\u03c3")) return;
            if (!(value > 0.0)) throw new ArithmeticException("Standard deviation must be greater than zero");
            this.sig = value;
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new StudentT(this.df, this.mu, this.sig);
    }

    @Override
    public void setUsingData(Vec data) {
        this.df = data.length() - 1;
        this.mu = data.mean();
        this.sig = Math.sqrt(data.variance() * this.df / (this.df - 2.0));
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double median() {
        return this.mu;
    }

    @Override
    public double mode() {
        return this.mu;
    }

    @Override
    public double variance() {
        if (this.df <= 1.0) {
            return Double.NaN;
        }
        if (1.0 < this.df && this.df <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.df / (this.df - 2.0) * this.sig * this.sig;
    }

    @Override
    public double skewness() {
        if (this.df <= 3.0) {
            return Double.NaN;
        }
        return 0.0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.df);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mu);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.sig);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StudentT other = (StudentT)obj;
        if (Double.doubleToLongBits(this.df) != Double.doubleToLongBits(other.df)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mu) != Double.doubleToLongBits(other.mu)) {
            return false;
        }
        return Double.doubleToLongBits(this.sig) == Double.doubleToLongBits(other.sig);
    }
}

