/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.kernels;

import java.util.Arrays;
import java.util.List;
import jsat.distributions.kernels.BaseKernelTrick;
import jsat.linear.Vec;
import jsat.parameters.DoubleParameter;
import jsat.parameters.Parameter;

public class LinearKernel
extends BaseKernelTrick {
    private static final long serialVersionUID = -1870181048970135367L;
    private double c;
    private Parameter param = new DoubleParameter(){
        private static final long serialVersionUID = -3811777805710374813L;

        @Override
        public double getValue() {
            return LinearKernel.this.getC();
        }

        @Override
        public boolean setValue(double val) {
            if (val < 0.0 || Double.isInfinite(val)) {
                return false;
            }
            LinearKernel.this.setC(val);
            return true;
        }

        @Override
        public String getASCIIName() {
            return "LinearKernel_c";
        }
    };

    public LinearKernel(double c) {
        this.c = c;
    }

    public LinearKernel() {
        this(1.0);
    }

    public void setC(double c) {
        if (c < 0.0 || Double.isInfinite(c) || Double.isNaN(c)) {
            throw new IllegalArgumentException("C must be a positive constant, not " + c);
        }
        this.c = c;
    }

    public double getC() {
        return this.c;
    }

    @Override
    public double eval(Vec a, Vec b) {
        return a.dot(b) + this.c;
    }

    @Override
    public String toString() {
        return "Linear Kernel (c=" + this.c + ")";
    }

    @Override
    public List<Parameter> getParameters() {
        return Arrays.asList(this.param);
    }

    @Override
    public Parameter getParameter(String paramName) {
        if (paramName.equals(this.param.getASCIIName())) {
            return this.param;
        }
        return null;
    }

    @Override
    public LinearKernel clone() {
        return new LinearKernel(this.c);
    }
}

