/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jsat.linear.IndexValue;
import jsat.linear.SubVector;
import jsat.linear.Vec;

public class ConcatenatedVec
extends Vec {
    private static final long serialVersionUID = -1412322616974470550L;
    private Vec[] vecs;
    private int[] lengthSums;
    private int totalLength;

    public ConcatenatedVec(List<Vec> vecs) {
        this.vecs = new Vec[vecs.size()];
        this.lengthSums = new int[vecs.size()];
        this.totalLength = 0;
        for (int i = 0; i < vecs.size(); ++i) {
            this.lengthSums[i] = this.totalLength;
            this.vecs[i] = vecs.get(i);
            this.totalLength += vecs.get(i).length();
        }
    }

    public ConcatenatedVec(Vec ... vecs) {
        this(Arrays.asList(vecs));
    }

    @Override
    public int length() {
        return this.totalLength;
    }

    @Override
    public double get(int index) {
        int baseIndex = this.getBaseIndex(index);
        return this.vecs[baseIndex].get(index - this.lengthSums[baseIndex]);
    }

    @Override
    public void set(int index, double val) {
        int baseIndex = this.getBaseIndex(index);
        this.vecs[baseIndex].set(index - this.lengthSums[baseIndex], val);
    }

    @Override
    public void increment(int index, double val) {
        int baseIndex = this.getBaseIndex(index);
        this.vecs[baseIndex].increment(index - this.lengthSums[baseIndex], val);
    }

    @Override
    public int nnz() {
        int nnz = 0;
        for (Vec v : this.vecs) {
            nnz += v.nnz();
        }
        return nnz;
    }

    @Override
    public void mutableAdd(double c, Vec b) {
        for (int i = 0; i < this.vecs.length; ++i) {
            this.vecs[i].mutableAdd(c, new SubVector(this.lengthSums[i], this.vecs[i].length(), b));
        }
    }

    @Override
    public Iterator<IndexValue> getNonZeroIterator(final int start) {
        return new Iterator<IndexValue>(){
            int baseIndex = -1;
            IndexValue valToSend = new IndexValue(0, 0.0);
            Iterator<IndexValue> curIter = null;
            IndexValue nextValue = null;

            @Override
            public boolean hasNext() {
                if (this.baseIndex == -1) {
                    this.baseIndex = ConcatenatedVec.this.getBaseIndex(start);
                    int curIndexConsidering = start;
                    while (this.baseIndex < ConcatenatedVec.this.vecs.length && !ConcatenatedVec.this.vecs[this.baseIndex].getNonZeroIterator(curIndexConsidering - ConcatenatedVec.this.lengthSums[this.baseIndex]).hasNext()) {
                        ++this.baseIndex;
                        if (this.baseIndex >= ConcatenatedVec.this.vecs.length) continue;
                        curIndexConsidering = ConcatenatedVec.this.lengthSums[this.baseIndex];
                    }
                    if (this.baseIndex >= ConcatenatedVec.this.vecs.length) {
                        return false;
                    }
                    this.curIter = ConcatenatedVec.this.vecs[this.baseIndex].getNonZeroIterator(curIndexConsidering - ConcatenatedVec.this.lengthSums[this.baseIndex]);
                    this.nextValue = this.curIter.next();
                    return true;
                }
                return this.nextValue != null;
            }

            @Override
            public IndexValue next() {
                if (this.nextValue == null) {
                    throw new NoSuchElementException();
                }
                this.valToSend.setIndex(this.nextValue.getIndex() + ConcatenatedVec.this.lengthSums[this.baseIndex]);
                this.valToSend.setValue(this.nextValue.getValue());
                if (this.curIter.hasNext()) {
                    this.nextValue = this.curIter.next();
                } else {
                    ++this.baseIndex;
                    while (this.baseIndex < ConcatenatedVec.this.vecs.length && !(this.curIter = ConcatenatedVec.this.vecs[this.baseIndex].getNonZeroIterator()).hasNext()) {
                        ++this.baseIndex;
                    }
                    if (this.baseIndex >= ConcatenatedVec.this.vecs.length) {
                        this.nextValue = null;
                        this.curIter = null;
                    } else {
                        this.nextValue = this.curIter.next();
                    }
                }
                return this.valToSend;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    @Override
    public boolean isSparse() {
        for (Vec v : this.vecs) {
            if (!v.isSparse()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConcatenatedVec clone() {
        Vec[] newVecs = new Vec[this.vecs.length];
        for (int i = 0; i < this.vecs.length; ++i) {
            newVecs[i] = this.vecs[i].clone();
        }
        return new ConcatenatedVec(Arrays.asList(newVecs));
    }

    private int getBaseIndex(int index) {
        int basIndex = Arrays.binarySearch(this.lengthSums, index);
        if (basIndex < 0) {
            basIndex = -basIndex - 2;
        }
        return basIndex;
    }
}

