/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.distancemetrics;

import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.DataSet;
import jsat.classifiers.ClassificationDataSet;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.regression.RegressionDataSet;
import jsat.utils.FakeExecutor;

public abstract class TrainableDistanceMetric
implements DistanceMetric {
    private static final long serialVersionUID = 6356276953152869105L;

    public abstract <V extends Vec> void train(List<V> var1);

    public abstract <V extends Vec> void train(List<V> var1, ExecutorService var2);

    public abstract void train(DataSet var1);

    public abstract void train(DataSet var1, ExecutorService var2);

    public abstract void train(ClassificationDataSet var1);

    public abstract void train(ClassificationDataSet var1, ExecutorService var2);

    public abstract boolean supportsClassificationTraining();

    public abstract void train(RegressionDataSet var1);

    public abstract void train(RegressionDataSet var1, ExecutorService var2);

    public abstract boolean supportsRegressionTraining();

    public abstract boolean needsTraining();

    @Override
    public abstract TrainableDistanceMetric clone();

    public static void trainIfNeeded(DistanceMetric dm, DataSet dataset) {
        if (!(dm instanceof TrainableDistanceMetric)) {
            return;
        }
        TrainableDistanceMetric tdm = (TrainableDistanceMetric)dm;
        if (!tdm.needsTraining()) {
            return;
        }
        if (dataset instanceof RegressionDataSet) {
            tdm.train((RegressionDataSet)dataset);
        } else if (dataset instanceof ClassificationDataSet) {
            tdm.train((ClassificationDataSet)dataset);
        } else {
            tdm.train(dataset);
        }
    }

    public static void trainIfNeeded(DistanceMetric dm, DataSet dataset, ExecutorService threadpool) {
        if (threadpool == null || threadpool instanceof FakeExecutor) {
            TrainableDistanceMetric.trainIfNeeded(dm, dataset);
            return;
        }
        if (!(dm instanceof TrainableDistanceMetric)) {
            return;
        }
        TrainableDistanceMetric tdm = (TrainableDistanceMetric)dm;
        if (!tdm.needsTraining()) {
            return;
        }
        if (dataset instanceof RegressionDataSet) {
            tdm.train((RegressionDataSet)dataset, threadpool);
        } else if (dataset instanceof ClassificationDataSet) {
            tdm.train((ClassificationDataSet)dataset, threadpool);
        } else {
            tdm.train(dataset, threadpool);
        }
    }

    public static <V extends Vec> void trainIfNeeded(DistanceMetric dm, List<V> dataset) {
        if (!(dm instanceof TrainableDistanceMetric)) {
            return;
        }
        TrainableDistanceMetric tdm = (TrainableDistanceMetric)dm;
        if (!tdm.needsTraining()) {
            return;
        }
        if (dataset instanceof RegressionDataSet) {
            tdm.train((RegressionDataSet)((Object)dataset));
        } else if (dataset instanceof ClassificationDataSet) {
            tdm.train((ClassificationDataSet)((Object)dataset));
        } else {
            tdm.train(dataset);
        }
    }

    public static <V extends Vec> void trainIfNeeded(DistanceMetric dm, List<V> dataset, ExecutorService threadpool) {
        if (threadpool == null || threadpool instanceof FakeExecutor) {
            TrainableDistanceMetric.trainIfNeeded(dm, dataset);
            return;
        }
        if (!(dm instanceof TrainableDistanceMetric)) {
            return;
        }
        TrainableDistanceMetric tdm = (TrainableDistanceMetric)dm;
        if (!tdm.needsTraining()) {
            return;
        }
        if (dataset instanceof RegressionDataSet) {
            tdm.train((RegressionDataSet)((Object)dataset), threadpool);
        } else if (dataset instanceof ClassificationDataSet) {
            tdm.train((ClassificationDataSet)((Object)dataset), threadpool);
        } else {
            tdm.train(dataset, threadpool);
        }
    }
}

