/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.VecPairedComparable;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.vectorcollection.IncrementalCollection;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.FakeExecutor;
import jsat.utils.IntList;
import jsat.utils.ModifiableCountDownLatch;
import jsat.utils.Pair;
import jsat.utils.ProbailityMatch;
import jsat.utils.SimpleList;
import jsat.utils.random.RandomUtil;

public class VPTree<V extends Vec>
implements IncrementalCollection<V> {
    private static final long serialVersionUID = -7271540108746353762L;
    private DistanceMetric dm;
    private List<Double> distCache;
    private List<V> allVecs;
    private Random rand;
    private int sampleSize;
    private int searchIterations;
    private volatile TreeNode root;
    private VPSelection vpSelection;
    private int size;
    private int maxLeafSize = 5;

    public VPTree(List<V> list, DistanceMetric dm, VPSelection vpSelection, Random rand, int sampleSize, int searchIterations, ExecutorService threadpool) {
        this.dm = dm;
        if (!dm.isSubadditive()) {
            throw new RuntimeException("VPTree only supports metrics that support the triangle inequality");
        }
        this.rand = rand;
        this.sampleSize = sampleSize;
        this.searchIterations = searchIterations;
        this.size = list.size();
        this.vpSelection = vpSelection;
        this.allVecs = list;
        this.distCache = threadpool == null || threadpool instanceof FakeExecutor ? dm.getAccelerationCache(this.allVecs) : dm.getAccelerationCache(this.allVecs, threadpool);
        SimpleList<Pair<Double, Integer>> tmpList = new SimpleList<Pair<Double, Integer>>(list.size());
        for (int i = 0; i < this.allVecs.size(); ++i) {
            tmpList.add(new Pair<Double, Integer>(-1.0, i));
        }
        if (threadpool == null) {
            this.root = this.makeVPTree(tmpList);
        } else {
            ModifiableCountDownLatch mcdl = new ModifiableCountDownLatch(1);
            this.root = this.makeVPTree(tmpList, threadpool, mcdl);
            mcdl.countDown();
            try {
                mcdl.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(VPTree.class.getName()).log(Level.SEVERE, null, ex);
                System.err.println("Falling back to single threaded VPTree constructor");
                tmpList.clear();
                for (int i = 0; i < list.size(); ++i) {
                    tmpList.add(new Pair<Double, Integer>(-1.0, i));
                }
                this.root = this.makeVPTree(tmpList);
            }
        }
    }

    public VPTree(List<V> list, DistanceMetric dm, VPSelection vpSelection, Random rand, int sampleSize, int searchIterations) {
        this(list, dm, vpSelection, rand, sampleSize, searchIterations, null);
    }

    public VPTree(List<V> list, DistanceMetric dm, VPSelection vpSelection) {
        this(list, dm, vpSelection, RandomUtil.getRandom(), 80, 40);
    }

    public VPTree(List<V> list, DistanceMetric dm, ExecutorService threadpool) {
        this(list, dm, VPSelection.Random, RandomUtil.getRandom(), 80, 40, threadpool);
    }

    public VPTree(List<V> list, DistanceMetric dm) {
        this(list, dm, VPSelection.Random);
    }

    public VPTree(DistanceMetric dm) {
        this.dm = dm;
        if (!dm.isSubadditive()) {
            throw new RuntimeException("VPTree only supports metrics that support the triangle inequality");
        }
        this.rand = RandomUtil.getRandom();
        this.sampleSize = 80;
        this.searchIterations = 40;
        this.size = 0;
        this.vpSelection = VPSelection.Random;
        this.allVecs = new ArrayList<V>();
        if (dm.supportsAcceleration()) {
            this.distCache = new DoubleList();
        }
    }

    protected VPTree(VPTree<V> toClone) {
        this.dm = toClone.dm.clone();
        this.rand = toClone.rand == null ? null : new Random(toClone.rand.nextInt());
        this.sampleSize = toClone.sampleSize;
        this.searchIterations = toClone.searchIterations;
        this.root = this.cloneChangeContext(toClone.root);
        this.vpSelection = toClone.vpSelection;
        this.size = toClone.size;
        this.maxLeafSize = toClone.maxLeafSize;
        if (toClone.allVecs != null) {
            this.allVecs = new ArrayList<V>(toClone.allVecs);
        }
        if (toClone.distCache != null) {
            this.distCache = new DoubleList(toClone.distCache);
        }
    }

    private TreeNode cloneChangeContext(TreeNode toClone) {
        if (toClone != null) {
            if (toClone instanceof VPLeaf) {
                return new VPLeaf((VPLeaf)toClone);
            }
            return new VPNode((VPNode)toClone);
        }
        return null;
    }

    protected VPTree() {
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void insert(V x) {
        int indx = this.size++;
        this.allVecs.add(x);
        if (this.distCache != null) {
            this.distCache.addAll(this.dm.getQueryInfo((Vec)x));
        }
        if (this.root == null) {
            ArrayList<Pair<Double, Integer>> list = new ArrayList<Pair<Double, Integer>>();
            list.add(new Pair<Double, Integer>((Double)Double.MAX_VALUE, indx));
            this.root = new VPLeaf(list);
            return;
        }
        this.root.insert(indx, Double.MAX_VALUE);
        if (this.root instanceof VPLeaf) {
            VPLeaf leaf = (VPLeaf)this.root;
            if (leaf.points.size() > this.maxLeafSize * this.maxLeafSize) {
                int orig_leaf_isze = this.maxLeafSize;
                this.maxLeafSize *= this.maxLeafSize;
                ArrayList<Pair<Double, Integer>> S = new ArrayList<Pair<Double, Integer>>();
                for (int i = 0; i < leaf.points.size(); ++i) {
                    S.add(new Pair<Double, Integer>((Double)Double.MAX_VALUE, leaf.points.getI(i)));
                }
                this.root = this.makeVPTree(S);
                this.maxLeafSize = orig_leaf_isze;
            }
        }
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, double range) {
        if (range <= 0.0) {
            throw new RuntimeException("Range must be a positive number");
        }
        ArrayList returnList = new ArrayList();
        List<Double> qi = this.dm.getQueryInfo(query);
        this.root.searchRange(VecPaired.extractTrueVec(query), range, returnList, 0.0, qi);
        Collections.sort(returnList);
        return returnList;
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, int neighbors) {
        BoundedSortedList boundedList = new BoundedSortedList(neighbors, neighbors);
        List<Double> qi = this.dm.getQueryInfo(query);
        this.root.searchKNN(VecPaired.extractTrueVec(query), neighbors, boundedList, 0.0, qi);
        ArrayList<VecPaired<Vec, Double>> list = new ArrayList<VecPaired<Vec, Double>>(boundedList.size());
        for (ProbailityMatch probailityMatch : boundedList) {
            list.add(new VecPaired<Vec, Double>((Vec)probailityMatch.getMatch(), probailityMatch.getProbability()));
        }
        return list;
    }

    private int sortSplitSet(List<Pair<Double, Integer>> S, VPNode node) {
        for (Pair<Double, Integer> S1 : S) {
            S1.setFirstItem(this.dm.dist(node.p, S1.getSecondItem(), this.allVecs, this.distCache));
        }
        Collections.sort(S, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return Double.compare(o1.getFirstItem(), o2.getFirstItem());
            }
        });
        int splitIndex = this.splitListIndex(S);
        node.left_low = S.get(0).getFirstItem();
        node.left_high = S.get(splitIndex).getFirstItem();
        node.right_low = S.get(splitIndex + 1).getFirstItem();
        node.right_high = S.get(S.size() - 1).getFirstItem();
        return splitIndex;
    }

    protected int splitListIndex(List<Pair<Double, Integer>> S) {
        return S.size() / 2;
    }

    public int getMaxLeafSize() {
        return this.maxLeafSize;
    }

    public void setMaxLeafSize(int maxLeafSize) {
        this.maxLeafSize = Math.max(5, maxLeafSize);
    }

    private TreeNode makeVPTree(List<Pair<Double, Integer>> S) {
        if (S.isEmpty()) {
            return null;
        }
        if (S.size() <= this.maxLeafSize) {
            VPLeaf leaf = new VPLeaf(S);
            return leaf;
        }
        int vpIndex = this.selectVantagePointIndex(S);
        VPNode node = new VPNode(S.get(vpIndex).getSecondItem());
        Collections.swap(S, 0, vpIndex);
        int splitIndex = this.sortSplitSet(S.subList(1, S.size()), node) + 1;
        node.right = this.makeVPTree(S.subList(splitIndex + 1, S.size()));
        node.left = this.makeVPTree(S.subList(1, splitIndex + 1));
        return node;
    }

    private TreeNode makeVPTree(List<Pair<Double, Integer>> S, final ExecutorService threadpool, final ModifiableCountDownLatch mcdl) {
        if (S.isEmpty()) {
            return null;
        }
        if (S.size() <= this.maxLeafSize) {
            VPLeaf leaf = new VPLeaf(S);
            return leaf;
        }
        int vpIndex = this.selectVantagePointIndex(S);
        final VPNode node = new VPNode(S.get(vpIndex).getSecondItem());
        Collections.swap(S, 0, vpIndex);
        int splitIndex = this.sortSplitSet(S.subList(1, S.size()), node) + 1;
        mcdl.countUp();
        final List<Pair<Double, Integer>> rightS = S.subList(splitIndex + 1, S.size());
        List<Pair<Double, Integer>> leftS = S.subList(1, splitIndex + 1);
        threadpool.submit(new Runnable(){

            @Override
            public void run() {
                node.right = VPTree.this.makeVPTree(rightS, threadpool, mcdl);
                mcdl.countDown();
            }
        });
        node.left = this.makeVPTree(leftS, threadpool, mcdl);
        return node;
    }

    private int selectVantagePointIndex(List<Pair<Double, Integer>> S) {
        int vpIndex;
        if (this.vpSelection == VPSelection.Random) {
            vpIndex = this.rand.nextInt(S.size());
        } else {
            int i;
            IntList samples = new IntList(this.sampleSize);
            if (this.sampleSize <= S.size()) {
                for (i = 0; i < this.sampleSize; ++i) {
                    samples.add(S.get(i).getSecondItem());
                }
            } else {
                for (i = 0; i < this.sampleSize; ++i) {
                    samples.add(S.get(this.rand.nextInt(S.size())).getSecondItem());
                }
            }
            double[] distances = new double[this.sampleSize];
            int bestVP = -1;
            double bestSpread = Double.NEGATIVE_INFINITY;
            for (int i2 = 0; i2 < Math.min(this.searchIterations, S.size()); ++i2) {
                int candIndx = this.searchIterations <= S.size() ? i2 : this.rand.nextInt(S.size());
                int candV = S.get(candIndx).getSecondItem();
                for (int j = 0; j < samples.size(); ++j) {
                    distances[j] = this.dm.dist(candV, (Integer)samples.get(j), this.allVecs, this.distCache);
                }
                Arrays.sort(distances);
                double median = distances[distances.length / 2];
                double spread = 0.0;
                for (double distance : distances) {
                    spread += Math.abs(distance - median);
                }
                if (!(spread > bestSpread)) continue;
                bestSpread = spread;
                bestVP = candIndx;
            }
            vpIndex = bestVP;
        }
        return vpIndex;
    }

    private int selectVantagePoint(List<Pair<Double, Integer>> S) {
        int vpIndex = this.selectVantagePointIndex(S);
        return S.get(vpIndex).getSecondItem();
    }

    @Override
    public VPTree<V> clone() {
        return new VPTree<V>(this);
    }

    public static class VPTreeFactory<V extends Vec>
    implements VectorCollectionFactory<V> {
        private static final long serialVersionUID = -2739851193676265510L;
        private VPSelection vpSelectionMethod;

        public VPTreeFactory(VPSelection vpSelectionMethod) {
            this.vpSelectionMethod = vpSelectionMethod;
        }

        public VPTreeFactory() {
            this(VPSelection.Random);
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric) {
            return new VPTree<V>(source, distanceMetric, this.vpSelectionMethod);
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric, ExecutorService threadpool) {
            return new VPTree<V>(source, distanceMetric, this.vpSelectionMethod, new Random(10L), 80, 40, threadpool);
        }

        @Override
        public VectorCollectionFactory<V> clone() {
            return new VPTreeFactory<V>(this.vpSelectionMethod);
        }
    }

    private class VPLeaf
    extends TreeNode {
        IntList points;
        DoubleList bounds;

        public VPLeaf(List<Pair<Double, Integer>> points) {
            this.points = new IntList(points.size());
            this.bounds = new DoubleList(points.size());
            for (int i = 0; i < points.size(); ++i) {
                this.points.add(points.get(i).getSecondItem());
                this.bounds.add(points.get(i).getFirstItem());
            }
        }

        public VPLeaf(VPLeaf toCopy) {
            this.bounds = new DoubleList(toCopy.bounds);
            this.points = new IntList(toCopy.points);
        }

        @Override
        public void insert(int x_indx, double dist_to_parent) {
            this.points.add(x_indx);
            this.bounds.add(dist_to_parent);
        }

        @Override
        public void searchKNN(Vec query, int k, BoundedSortedList<ProbailityMatch<V>> list, double x, List<Double> qi) {
            double dist = -1.0;
            double tau = list.size() == 0 ? Double.MAX_VALUE : ((ProbailityMatch)list.get(list.size() - 1)).getProbability();
            for (int i = 0; i < this.points.size(); ++i) {
                double d;
                int point_i = this.points.getI(i);
                double bound_i = this.bounds.getD(i);
                if (list.size() < k) {
                    list.add(new ProbailityMatch(VPTree.this.dm.dist(point_i, query, qi, VPTree.this.allVecs, VPTree.this.distCache), VPTree.this.allVecs.get(point_i)));
                    tau = ((ProbailityMatch)list.get(list.size() - 1)).getProbability();
                    continue;
                }
                if (!(bound_i - tau <= x) || !(x <= bound_i + tau)) continue;
                dist = VPTree.this.dm.dist(point_i, query, qi, VPTree.this.allVecs, VPTree.this.distCache);
                if (!(d < tau)) continue;
                list.add(new ProbailityMatch(dist, VPTree.this.allVecs.get(point_i)));
                tau = ((ProbailityMatch)list.get(list.size() - 1)).getProbability();
            }
        }

        @Override
        public void searchRange(Vec query, double range, List<VecPaired<V, Double>> list, double x, List<Double> qi) {
            double dist = Double.MAX_VALUE;
            for (int i = 0; i < this.points.size(); ++i) {
                double d;
                int point_i = this.points.getI(i);
                double bound_i = this.bounds.getD(i);
                if (!(bound_i - range <= x) || !(x <= bound_i + range)) continue;
                dist = VPTree.this.dm.dist(point_i, query, qi, VPTree.this.allVecs, VPTree.this.distCache);
                if (!(d < range)) continue;
                list.add(new VecPairedComparable<Vec, Double>((Vec)VPTree.this.allVecs.get(point_i), dist));
            }
        }

        @Override
        public TreeNode clone() {
            return new VPLeaf(this);
        }
    }

    private class VPNode
    extends TreeNode {
        int p;
        double left_low;
        double left_high;
        double right_low;
        double right_high;
        TreeNode right;
        TreeNode left;

        public VPNode(int p) {
            this.p = p;
        }

        public VPNode(VPNode toCopy) {
            this(toCopy.p);
            this.left_low = toCopy.left_low;
            this.left_high = toCopy.left_high;
            this.right_low = toCopy.right_low;
            this.right_high = toCopy.right_high;
            this.left = vPTree.cloneChangeContext(toCopy.left);
            this.right = vPTree.cloneChangeContext(toCopy.right);
        }

        @Override
        public void insert(int x_indx, double dist_to_parent) {
            TreeNode child;
            double dist = VPTree.this.dm.dist(this.p, x_indx, (List<? extends Vec>)VPTree.this.allVecs, (List<Double>)VPTree.this.distCache);
            if (dist * 2.0 < this.left_high + this.right_low) {
                this.left_high = Math.max(this.left_high, dist);
                this.left_low = Math.min(this.left_low, dist);
                child = this.left = this.maybeExpandChild(this.left);
            } else {
                this.right_high = Math.max(this.right_high, dist);
                this.right_low = Math.min(this.right_low, dist);
                child = this.right = this.maybeExpandChild(this.right);
            }
            child.insert(x_indx, dist);
        }

        private TreeNode maybeExpandChild(TreeNode child) {
            if (child instanceof VPLeaf) {
                IntList childs_children = ((VPLeaf)child).points;
                if (childs_children.size() <= VPTree.this.maxLeafSize * VPTree.this.maxLeafSize) {
                    return child;
                }
                ArrayList<Pair<Double, Integer>> S = new ArrayList<Pair<Double, Integer>>(childs_children.size());
                Iterator iterator = childs_children.iterator();
                while (iterator.hasNext()) {
                    int indx = (Integer)iterator.next();
                    S.add(new Pair<Double, Integer>((Double)Double.MAX_VALUE, indx));
                }
                int vpIndex = VPTree.this.selectVantagePointIndex(S);
                VPNode node = new VPNode((Integer)((Pair)S.get(vpIndex)).getSecondItem());
                Collections.swap(S, 0, vpIndex);
                int splitIndex = VPTree.this.sortSplitSet(S.subList(1, S.size()), node) + 1;
                node.right = new VPLeaf(S.subList(splitIndex + 1, S.size()));
                node.left = new VPLeaf(S.subList(1, splitIndex + 1));
                return node;
            }
            return child;
        }

        private boolean searchInLeft(double x, double tau) {
            if (this.left == null) {
                return false;
            }
            return this.left_low - tau <= x && x <= this.left_high + tau;
        }

        private boolean searchInRight(double x, double tau) {
            if (this.right == null) {
                return false;
            }
            return this.right_low - tau <= x && x <= this.right_high + tau;
        }

        @Override
        public void searchKNN(Vec query, int k, BoundedSortedList<ProbailityMatch<V>> list, double x, List<Double> qi) {
            x = VPTree.this.dm.dist(this.p, query, qi, VPTree.this.allVecs, VPTree.this.distCache);
            if (list.size() < k || x < ((ProbailityMatch)list.get(k - 1)).getProbability()) {
                list.add(new ProbailityMatch(x, VPTree.this.allVecs.get(this.p)));
            }
            double tau = ((ProbailityMatch)list.get(list.size() - 1)).getProbability();
            double middle = (this.left_high + this.right_low) * 0.5;
            if (x < middle) {
                if (this.searchInLeft(x, tau) || list.size() < k) {
                    this.left.searchKNN(query, k, list, x, qi);
                }
                if (this.searchInRight(x, tau = ((ProbailityMatch)list.get(list.size() - 1)).getProbability()) || list.size() < k) {
                    this.right.searchKNN(query, k, list, x, qi);
                }
            } else {
                if (this.searchInRight(x, tau) || list.size() < k) {
                    this.right.searchKNN(query, k, list, x, qi);
                }
                if (this.searchInLeft(x, tau = ((ProbailityMatch)list.get(list.size() - 1)).getProbability()) || list.size() < k) {
                    this.left.searchKNN(query, k, list, x, qi);
                }
            }
        }

        @Override
        public void searchRange(Vec query, double range, List<VecPaired<V, Double>> list, double x, List<Double> qi) {
            x = VPTree.this.dm.dist(this.p, query, qi, VPTree.this.allVecs, VPTree.this.distCache);
            if (x <= range) {
                list.add(new VecPairedComparable<Vec, Double>((Vec)VPTree.this.allVecs.get(this.p), x));
            }
            if (this.searchInLeft(x, range)) {
                this.left.searchRange(query, range, list, x, qi);
            }
            if (this.searchInRight(x, range)) {
                this.right.searchRange(query, range, list, x, qi);
            }
        }

        @Override
        public TreeNode clone() {
            return new VPNode(this);
        }
    }

    private abstract class TreeNode
    implements Cloneable,
    Serializable {
        private TreeNode() {
        }

        public abstract void insert(int var1, double var2);

        public abstract void searchKNN(Vec var1, int var2, BoundedSortedList<ProbailityMatch<V>> var3, double var4, List<Double> var6);

        public abstract void searchRange(Vec var1, double var2, List<VecPaired<V, Double>> var4, double var5, List<Double> var7);

        public abstract TreeNode clone();
    }

    public static enum VPSelection {
        Sampling,
        Random;

    }
}

