/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.vectorcollection.VPTree;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.math.OnLineStatistics;
import jsat.utils.Pair;

public class VPTreeMV<V extends Vec>
extends VPTree<V> {
    private static final long serialVersionUID = 6668184445206226077L;

    public VPTreeMV(List<V> list, DistanceMetric dm, VPTree.VPSelection vpSelection, Random rand, int sampleSize, int searchIterations, ExecutorService threadpool) {
        super(list, dm, vpSelection, rand, sampleSize, searchIterations, threadpool);
    }

    public VPTreeMV(List<V> list, DistanceMetric dm, VPTree.VPSelection vpSelection, Random rand, int sampleSize, int searchIterations) {
        super(list, dm, vpSelection, rand, sampleSize, searchIterations);
    }

    public VPTreeMV(List<V> list, DistanceMetric dm, VPTree.VPSelection vpSelection) {
        super(list, dm, vpSelection);
    }

    public VPTreeMV(List<V> list, DistanceMetric dm) {
        super(list, dm);
    }

    public VPTreeMV(List<V> list, DistanceMetric dm, ExecutorService threadpool) {
        super(list, dm, threadpool);
    }

    public VPTreeMV(DistanceMetric dm) {
        super(dm);
    }

    @Override
    protected int splitListIndex(List<Pair<Double, Integer>> S) {
        int splitIndex = S.size() / 2;
        int maxLeafSize = this.getMaxLeafSize();
        if (S.size() >= maxLeafSize * 4) {
            int i;
            int minSplitSize = Math.max(maxLeafSize, S.size() / 20);
            OnLineStatistics rightV = new OnLineStatistics();
            OnLineStatistics leftV = new OnLineStatistics();
            for (i = 0; i < minSplitSize; ++i) {
                leftV.add(S.get(i).getFirstItem());
            }
            for (i = minSplitSize; i < S.size(); ++i) {
                rightV.add(S.get(i).getFirstItem());
            }
            splitIndex = minSplitSize;
            double bestVar = leftV.getVarance() * (double)minSplitSize + rightV.getVarance() * (double)(S.size() - minSplitSize);
            for (int i2 = minSplitSize + 1; i2 < S.size() - minSplitSize; ++i2) {
                double tmp = S.get(i2).getFirstItem();
                leftV.add(tmp);
                rightV.remove(tmp, 1.0);
                double testVar = leftV.getVarance() * (double)i2 + rightV.getVarance() * (double)(S.size() - i2);
                if (!(testVar < bestVar)) continue;
                splitIndex = i2;
                bestVar = testVar;
            }
        }
        return splitIndex;
    }

    public static class VPTreeMVFactory<V extends Vec>
    implements VectorCollectionFactory<V> {
        private static final long serialVersionUID = 4265451324896792148L;
        private VPTree.VPSelection vpSelectionMethod;

        public VPTreeMVFactory(VPTree.VPSelection vpSelectionMethod) {
            this.vpSelectionMethod = vpSelectionMethod;
        }

        public VPTreeMVFactory() {
            this(VPTree.VPSelection.Random);
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric) {
            return new VPTreeMV<V>(source, distanceMetric, this.vpSelectionMethod);
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric, ExecutorService threadpool) {
            return new VPTreeMV<V>(source, distanceMetric, this.vpSelectionMethod, new Random(10L), 80, 40, threadpool);
        }

        @Override
        public VectorCollectionFactory<V> clone() {
            return new VPTreeMVFactory<V>(this.vpSelectionMethod);
        }
    }
}

