/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.math.OnLineStatistics;
import jsat.utils.ListUtils;
import jsat.utils.SystemInfo;

public class VectorCollectionUtils1 {
    public static <V0 extends Vec, V1 extends Vec> List<List<? extends VecPaired<V0, Double>>> allNearestNeighbors(VectorCollection<V0> collection, List<V1> search, int k) {
        ArrayList<List<VecPaired<V0, Double>>> results = new ArrayList<List<VecPaired<V0, Double>>>(search.size());
        for (Vec v : search) {
            results.add(collection.search(v, k));
        }
        return results;
    }

    public static <V0 extends Vec, V1 extends Vec> List<List<? extends VecPaired<V0, Double>>> allNearestNeighbors(VectorCollection<V0> collection, V1[] search, int k) {
        return VectorCollectionUtils1.allNearestNeighbors(collection, Arrays.asList(search), k);
    }

    public static <V0 extends Vec, V1 extends Vec> List<List<? extends VecPaired<V0, Double>>> allNearestNeighbors(final VectorCollection<V0> collection, List<V1> search, final int k, ExecutorService threadpool) {
        ArrayList<List<VecPaired<V0, Double>>> results = new ArrayList<List<VecPaired<V0, Double>>>(search.size());
        ArrayList subResults = new ArrayList(SystemInfo.LogicalCores);
        for (final List<V1> subSearch : ListUtils.splitList(search, SystemInfo.LogicalCores)) {
            subResults.add(threadpool.submit(new Callable<List<List<? extends VecPaired<V0, Double>>>>(){

                @Override
                public List<List<? extends VecPaired<V0, Double>>> call() throws Exception {
                    ArrayList subResult = new ArrayList(subSearch.size());
                    for (Vec v : subSearch) {
                        subResult.add(collection.search(v, k));
                    }
                    return subResult;
                }
            }));
        }
        try {
            for (List<Object> subResult : ListUtils.collectFutures(subResults)) {
                results.addAll(subResult);
            }
        }
        catch (ExecutionException ex) {
            Logger.getLogger(VectorCollectionUtils1.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(VectorCollectionUtils1.class.getName()).log(Level.SEVERE, null, ex);
        }
        return results;
    }

    public static <V0 extends Vec, V1 extends Vec> List<List<? extends VecPaired<V0, Double>>> allEpsNeighbors(final VectorCollection<V0> collection, List<V1> search, final double radius, ExecutorService threadpool) {
        ArrayList<List<VecPaired<V0, Double>>> results = new ArrayList<List<VecPaired<V0, Double>>>(search.size());
        ArrayList subResults = new ArrayList(SystemInfo.LogicalCores);
        for (final List<V1> subSearch : ListUtils.splitList(search, SystemInfo.LogicalCores)) {
            subResults.add(threadpool.submit(new Callable<List<List<? extends VecPaired<V0, Double>>>>(){

                @Override
                public List<List<? extends VecPaired<V0, Double>>> call() throws Exception {
                    ArrayList subResult = new ArrayList(subSearch.size());
                    for (Vec v : subSearch) {
                        subResult.add(collection.search(v, radius));
                    }
                    return subResult;
                }
            }));
        }
        try {
            for (List<Object> subResult : ListUtils.collectFutures(subResults)) {
                results.addAll(subResult);
            }
        }
        catch (ExecutionException ex) {
            Logger.getLogger(VectorCollectionUtils1.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(VectorCollectionUtils1.class.getName()).log(Level.SEVERE, null, ex);
        }
        return results;
    }

    public static <V0 extends Vec, V1 extends Vec> List<List<? extends VecPaired<V0, Double>>> allNearestNeighbors(VectorCollection<V0> collection, V1[] search, int k, ExecutorService threadpool) {
        return VectorCollectionUtils1.allNearestNeighbors(collection, Arrays.asList(search), k, threadpool);
    }

    public static <V0 extends Vec, V1 extends Vec> OnLineStatistics getKthNeighborStats(VectorCollection<V0> collection, List<V1> search, int k) {
        OnLineStatistics stats = new OnLineStatistics();
        for (Vec v : search) {
            stats.add(collection.search(v, k).get(k - 1).getPair());
        }
        return stats;
    }

    public static <V0 extends Vec, V1 extends Vec> OnLineStatistics getKthNeighborStats(VectorCollection<V0> collection, V1[] search, int k) {
        return VectorCollectionUtils1.getKthNeighborStats(collection, Arrays.asList(search), k);
    }

    public static <V0 extends Vec, V1 extends Vec> OnLineStatistics getKthNeighborStats(final VectorCollection<V0> collection, List<V1> search, final int k, ExecutorService threadpool) {
        ArrayList futureStats = new ArrayList(SystemInfo.LogicalCores);
        for (final List<V1> list : ListUtils.splitList(search, SystemInfo.LogicalCores)) {
            futureStats.add(threadpool.submit(new Callable<OnLineStatistics>(){

                @Override
                public OnLineStatistics call() throws Exception {
                    OnLineStatistics stats = new OnLineStatistics();
                    for (Vec v : list) {
                        stats.add(collection.search(v, k).get(k - 1).getPair());
                    }
                    return stats;
                }
            }));
        }
        OnLineStatistics stats = new OnLineStatistics();
        try {
            for (OnLineStatistics subResult : ListUtils.collectFutures(futureStats)) {
                stats = OnLineStatistics.add(stats, subResult);
            }
        }
        catch (ExecutionException executionException) {
            Logger.getLogger(VectorCollectionUtils1.class.getName()).log(Level.SEVERE, null, executionException);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(VectorCollectionUtils1.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        return stats;
    }

    public static <V0 extends Vec, V1 extends Vec> OnLineStatistics getKthNeighborStats(VectorCollection<V0> collection, V1[] search, int k, ExecutorService threadpool) {
        return VectorCollectionUtils1.getKthNeighborStats(collection, Arrays.asList(search), k, threadpool);
    }
}

