/*
 * Decompiled with CFR 0.152.
 */
package jsat.math;

import java.io.Serializable;

public class OnLineStatistics
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4286295481362462983L;
    private double mean;
    private double n;
    private double m2;
    private double m3;
    private double m4;
    private Double min;
    private Double max;

    public OnLineStatistics() {
        this(0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public OnLineStatistics(double n, double mean, double variance, double skew, double kurt) {
        if (n < 0.0) {
            throw new ArithmeticException("Can not have a negative set of weights");
        }
        this.n = n;
        if (n != 0.0) {
            this.mean = mean;
            this.m2 = variance * (n - 1.0);
            this.m3 = Math.pow(this.m2, 1.5) * skew / Math.sqrt(n);
            this.m4 = (3.0 + kurt) * this.m2 * this.m2 / n;
        } else {
            this.m4 = 0.0;
            this.m3 = 0.0;
            this.m2 = 0.0;
            this.mean = 0.0;
        }
        this.max = null;
        this.min = null;
    }

    private OnLineStatistics(double n, double mean, double m2, double m3, double m4, Double min, Double max) {
        this.n = n;
        this.mean = mean;
        this.m2 = m2;
        this.m3 = m3;
        this.m4 = m4;
        this.min = min;
        this.max = max;
    }

    public OnLineStatistics(OnLineStatistics other) {
        this(other.n, other.mean, other.m2, other.m3, other.m4, other.min, other.max);
    }

    public void add(double x) {
        this.add(x, 1.0);
    }

    public void add(double x, double weight) {
        if (weight < 0.0) {
            throw new ArithmeticException("Can not add a negative weight");
        }
        if (weight == 0.0) {
            return;
        }
        double n1 = this.n;
        this.n += weight;
        double delta = x - this.mean;
        double delta_n = delta * weight / this.n;
        double delta_n2 = delta_n * delta_n;
        double term1 = delta * delta_n * n1;
        this.mean += delta_n;
        this.m4 += term1 * delta_n2 * (this.n * this.n - 3.0 * this.n + 3.0) + 6.0 * delta_n2 * this.m2 - 4.0 * delta_n * this.m3;
        this.m3 += term1 * delta_n * (this.n - 2.0) - 3.0 * delta_n * this.m2;
        this.m2 += weight * delta * (x - this.mean);
        if (this.min == null) {
            this.min = this.max = Double.valueOf(x);
        } else {
            this.min = Math.min(this.min, x);
            this.max = Math.max(this.max, x);
        }
    }

    public void remove(double x, double weight) {
        if (weight < 0.0) {
            throw new ArithmeticException("Can not remove a negative weight");
        }
        if (weight == 0.0) {
            return;
        }
        double n1 = this.n;
        this.n -= weight;
        double delta = x - this.mean;
        double delta_n = delta * weight / this.n;
        double delta_n2 = delta_n * delta_n;
        double term1 = delta * delta_n * n1;
        this.mean -= delta_n;
        this.m2 -= weight * delta * (x - this.mean);
        this.m3 -= term1 * delta_n * (this.n - 2.0 + weight) - 3.0 * delta_n * this.m2;
        this.m4 -= term1 * delta_n2 * (this.n * this.n - 3.0 * this.n + 3.0) + 6.0 * delta_n2 * this.m2 - 4.0 * delta_n * this.m3;
    }

    public static OnLineStatistics remove(OnLineStatistics A, OnLineStatistics B) {
        OnLineStatistics toRet = A.clone();
        toRet.remove(B);
        return toRet;
    }

    public void remove(OnLineStatistics B) {
        OnLineStatistics A = this;
        if (A.n == B.n) {
            this.m4 = 0.0;
            this.m3 = 0.0;
            this.m2 = 0.0;
            this.mean = 0.0;
            this.n = 0.0;
            this.max = null;
            this.min = null;
            return;
        }
        if (B.n == 0.0) {
            return;
        }
        if (A.n < B.n) {
            throw new ArithmeticException("Can not have negative samples");
        }
        double nX = A.n - B.n;
        double nXsqrd = nX * nX;
        double nAnB = B.n * A.n;
        double AnSqrd = A.n * A.n;
        double BnSqrd = B.n * B.n;
        double delta = B.mean - A.mean;
        double deltaSqrd = delta * delta;
        double deltaCbd = deltaSqrd * delta;
        double deltaQad = deltaSqrd * deltaSqrd;
        double newMean = (A.n * A.mean - B.n * B.mean) / (A.n - B.n);
        double newM2 = A.m2 - B.m2 - deltaSqrd / nX * nAnB;
        double newM3 = A.m3 - B.m3 - deltaCbd * nAnB * (A.n - B.n) / nXsqrd - 3.0 * delta * (A.n * B.m2 - B.n * A.m2) / nX;
        double newM4 = A.m4 - B.m4 - deltaQad * (nAnB * (AnSqrd - nAnB + BnSqrd) / (nXsqrd * nX)) - 6.0 * deltaSqrd * (AnSqrd * B.m2 - BnSqrd * A.m2) / nXsqrd - 4.0 * delta * (A.n * B.m3 - B.n * A.m3) / nX;
        this.n = nX;
        this.mean = newMean;
        this.m2 = newM2;
        this.m3 = newM3;
        this.m4 = newM4;
    }

    public static OnLineStatistics add(OnLineStatistics A, OnLineStatistics B) {
        OnLineStatistics toRet = A.clone();
        toRet.add(B);
        return toRet;
    }

    public void add(OnLineStatistics B) {
        OnLineStatistics A = this;
        if (A.n == B.n && B.n == 0.0) {
            return;
        }
        if (B.n == 0.0) {
            return;
        }
        if (A.n == 0.0) {
            this.n = B.n;
            this.mean = B.mean;
            this.m2 = B.m2;
            this.m3 = B.m3;
            this.m4 = B.m4;
            this.min = B.min;
            this.max = B.max;
            return;
        }
        double nX = B.n + A.n;
        double nXsqrd = nX * nX;
        double nAnB = B.n * A.n;
        double AnSqrd = A.n * A.n;
        double BnSqrd = B.n * B.n;
        double delta = B.mean - A.mean;
        double deltaSqrd = delta * delta;
        double deltaCbd = deltaSqrd * delta;
        double deltaQad = deltaSqrd * deltaSqrd;
        double newMean = (A.n * A.mean + B.n * B.mean) / (A.n + B.n);
        double newM2 = A.m2 + B.m2 + deltaSqrd / nX * nAnB;
        double newM3 = A.m3 + B.m3 + deltaCbd * nAnB * (A.n - B.n) / nXsqrd + 3.0 * delta * (A.n * B.m2 - B.n * A.m2) / nX;
        double newM4 = A.m4 + B.m4 + deltaQad * (nAnB * (AnSqrd - nAnB + BnSqrd) / (nXsqrd * nX)) + 6.0 * deltaSqrd * (AnSqrd * B.m2 + BnSqrd * A.m2) / nXsqrd + 4.0 * delta * (A.n * B.m3 - B.n * A.m3) / nX;
        this.n = nX;
        this.mean = newMean;
        this.m2 = newM2;
        this.m3 = newM3;
        this.m4 = newM4;
        this.min = Math.min(A.min, B.min);
        this.max = Math.max(A.max, B.max);
    }

    public OnLineStatistics clone() {
        return new OnLineStatistics(this.n, this.mean, this.m2, this.m3, this.m4, this.min, this.max);
    }

    public double getSumOfWeights() {
        return this.n;
    }

    public double getMean() {
        return this.mean;
    }

    public double getVarance() {
        return this.m2 / (this.n + 1.0E-15);
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVarance());
    }

    public double getSkewness() {
        return Math.sqrt(this.n) * this.m3 / Math.pow(this.m2, 1.5);
    }

    public double getKurtosis() {
        return this.n * this.m4 / (this.m2 * this.m2) - 3.0;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

