/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.optimization;

import jsat.math.Function;

public class GoldenSearch {
    private static final double tau = (Math.sqrt(5.0) - 1.0) / 2.0;
    private static final double om_tau = 1.0 - tau;

    public static double minimize(double eps, int maxIterations, double a, double b, int pos, Function f, double ... args) {
        double x2;
        double x1;
        if (a > b) {
            double tmp = b;
            b = a;
            a = tmp;
        }
        args[pos] = x1 = a + om_tau * (b - a);
        double f1 = f.f(args);
        args[pos] = x2 = a + tau * (b - a);
        double f2 = f.f(args);
        for (int iter = 0; b - a > 2.0 * eps && iter < maxIterations; ++iter) {
            if (f1 > f2) {
                a = x1;
                x1 = x2;
                f1 = f2;
                args[pos] = x2 = a + tau * (b - a);
                f2 = f.f(args);
                continue;
            }
            b = x2;
            x2 = x1;
            f2 = f1;
            args[pos] = x1 = a + om_tau * (b - a);
            f1 = f.f(args);
        }
        return (a + b) / 2.0;
    }
}

