/*
 * Decompiled with CFR 0.152.
 */
package jsat.regression.evaluation;

import jsat.regression.evaluation.RegressionScore;
import jsat.utils.DoubleList;

public abstract class TotalHistoryRegressionScore
implements RegressionScore {
    private static final long serialVersionUID = -5262934560490160236L;
    protected DoubleList truths;
    protected DoubleList predictions;
    protected DoubleList weights;

    public TotalHistoryRegressionScore() {
    }

    public TotalHistoryRegressionScore(TotalHistoryRegressionScore toCopy) {
        if (toCopy.truths != null) {
            this.truths = new DoubleList(toCopy.truths);
            this.predictions = new DoubleList(toCopy.predictions);
            this.weights = new DoubleList(toCopy.weights);
        }
    }

    @Override
    public void prepare() {
        this.truths = new DoubleList();
        this.predictions = new DoubleList();
        this.weights = new DoubleList();
    }

    @Override
    public void addResult(double prediction, double trueValue, double weight) {
        this.truths.add(trueValue);
        this.predictions.add(prediction);
        this.weights.add(weight);
    }

    @Override
    public void addResults(RegressionScore other) {
        TotalHistoryRegressionScore otherObj = (TotalHistoryRegressionScore)other;
        this.truths.addAll(otherObj.truths);
        this.predictions.addAll(otherObj.predictions);
        this.weights.addAll(otherObj.weights);
    }

    @Override
    public abstract TotalHistoryRegressionScore clone();
}

