/*
 * Decompiled with CFR 0.152.
 */
package jsat.testing.goodnessoffit;

import jsat.distributions.ContinuousDistribution;
import jsat.distributions.Kolmogorov;
import jsat.linear.Vec;

public class KSTest {
    private static final Kolmogorov k = new Kolmogorov();
    private Vec v;

    public KSTest(Vec v) {
        this.v = v.sortedCopy();
    }

    public void setBaseData(Vec v) {
        this.v = v;
    }

    protected double dCalc(ContinuousDistribution cd) {
        double max = 0.0;
        for (int i = 0; i < this.v.length(); ++i) {
            if (this.v.get(i) >= cd.min() && this.v.get(i) <= cd.max()) {
                double tmp = ((double)i + 1.0) / (double)this.v.length() - cd.cdf(this.v.get(i));
                max = Math.max(max, Math.abs(tmp));
                continue;
            }
            max = Math.max(max, Math.abs(((double)i + 1.0) / (double)this.v.length()));
        }
        return max;
    }

    private static double ECDF(Vec s, double x) {
        int min = 0;
        int max = s.length() - 1;
        int mid = (min + max) / 2;
        do {
            if (x > s.get(mid)) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        } while (s.get(mid) != x && min <= max);
        return ((double)mid + 1.0) / (double)s.length();
    }

    protected double dCaldO(Vec o) {
        double tmp;
        int i;
        double max = 0.0;
        for (i = 0; i < this.v.length(); ++i) {
            tmp = ((double)i + 1.0) / (double)this.v.length() - KSTest.ECDF(o, this.v.get(i));
            max = Math.max(max, Math.abs(tmp));
        }
        for (i = 0; i < o.length(); ++i) {
            tmp = ((double)i + 1.0) / (double)o.length() - KSTest.ECDF(this.v, o.get(i));
            max = Math.max(max, Math.abs(tmp));
        }
        return max;
    }

    public double testDist(ContinuousDistribution cd) {
        double d = this.dCalc(cd);
        double n = this.v.length();
        return this.pValue(n, d);
    }

    public double testData(Vec data) {
        double d = this.dCaldO(data);
        double n = (double)(this.v.length() * data.length()) / ((double)this.v.length() + (double)data.length());
        return this.pValue(n, d);
    }

    private double pValue(double n, double d) {
        return 1.0 - k.cdf((Math.sqrt(n) + 0.12 + 0.11 / Math.sqrt(n)) * d);
    }
}

