/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.expecty;

import com.eed3si9n.expecty.RecordedExpression;
import com.eed3si9n.expecty.RecordedValue;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

public class ExpressionRenderer {
    private final boolean showTypes;
    private final boolean shortString;

    public ExpressionRenderer(boolean showTypes, boolean shortString) {
        this.showTypes = showTypes;
        this.shortString = shortString;
    }

    public String render(RecordedExpression<?> recordedExpr) {
        int offset = Predef$.MODULE$.wrapString(recordedExpr.text()).segmentLength((Function1 & Serializable)_$1 -> RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$1))), 0);
        scala.collection.mutable.StringBuilder intro = new scala.collection.mutable.StringBuilder().append(recordedExpr.text().trim());
        ListBuffer lines = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.collection.mutable.StringBuilder[]{new scala.collection.mutable.StringBuilder()}));
        Iterable<RecordedValue> rightToLeft = this.filterAndSortByAnchor(recordedExpr.recordedValues());
        rightToLeft.foreach((Function1)(JProcedure1 & Serializable)recordedValue -> this.placeValue((ListBuffer<scala.collection.mutable.StringBuilder>)lines, recordedValue.value(), package$.MODULE$.max(recordedValue.anchor() - offset, 0)));
        lines.prepend((Object)intro);
        lines.append((Object)new scala.collection.mutable.StringBuilder());
        return lines.mkString("\n");
    }

    private Iterable<RecordedValue> filterAndSortByAnchor(List<RecordedValue> recordedValues) {
        ObjectRef map = ObjectRef.create((Object)((TreeMap)TreeMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), scala.package$.MODULE$.Ordering().by((Function1)(JFunction1.mcII.sp & Serializable)_$2 -> -_$2, (Ordering)Ordering.Int$.MODULE$))));
        recordedValues.foreach((Function1)(JProcedure1 & Serializable)value -> {
            if (!((TreeMap)map$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)value.anchor()))) {
                Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)value.anchor()));
                TreeMap treeMap = (TreeMap)((TreeMap)map$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, value));
                map$1.elem = treeMap;
                treeMap = null;
            }
        });
        return ((TreeMap)map.elem).values();
    }

    private void placeValue(ListBuffer<scala.collection.mutable.StringBuilder> lines, Object value, int col) {
        String str = this.renderValue(value);
        this.placeString((scala.collection.mutable.StringBuilder)lines.apply(0), "|", col);
        Breaks$.MODULE$.breakable((Function0)((JFunction0.mcV.sp & Serializable)() -> this.placeValue$$anonfun$1(lines, col, str)));
    }

    /*
     * WARNING - void declaration
     */
    private String renderValue(Object value) {
        void var3_3;
        String str0;
        String string = str0 = value == null ? "null" : value.toString();
        String str = !this.shortString ? str0 : (str0.contains("\n") ? new StringBuilder(3).append((String)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(str0)).toList().headOption().getOrElse(ExpressionRenderer::$anonfun$3)).append("...").toString() : str0);
        return this.showTypes ? new StringBuilder(3).append(str).append(" (").append(value.getClass().getName()).append(")").toString() : var3_3;
    }

    private void placeString(scala.collection.mutable.StringBuilder line, String str, int anchor) {
        int diff = anchor - line.length();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), diff).foreach((Function1 & Serializable)i -> line.append(' '));
        line.replace(anchor, anchor + str.length(), str);
    }

    private boolean fits(scala.collection.mutable.StringBuilder line, String str, int anchor) {
        return ((IterableOnceOps)line.slice(anchor, anchor + str.length() + 1)).forall((Function1 & Serializable)_$3 -> RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$3))));
    }

    private final void placeValue$$anonfun$1(ListBuffer lines$2, int col$1, String str$1) {
        ((IterableOnceOps)lines$2.drop(1)).foreach((Function1)(JProcedure1 & Serializable)line -> {
            if (this.fits((scala.collection.mutable.StringBuilder)line, str$1, col$1)) {
                this.placeString((scala.collection.mutable.StringBuilder)line, str$1, col$1);
                throw Breaks$.MODULE$.break();
            }
            this.placeString((scala.collection.mutable.StringBuilder)line, "|", col$1);
        });
        scala.collection.mutable.StringBuilder newLine = new scala.collection.mutable.StringBuilder();
        this.placeString(newLine, str$1, col$1);
        lines$2.append((Object)newLine);
    }

    private static final String $anonfun$3() {
        return "";
    }
}

