/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.support.apachehttp;

import gigahorse.AuthScheme;
import gigahorse.Body;
import gigahorse.Config;
import gigahorse.EmptyBody;
import gigahorse.FileBody;
import gigahorse.FullResponse;
import gigahorse.FutureLifter;
import gigahorse.HttpClient;
import gigahorse.HttpVerbs$;
import gigahorse.InMemoryBody;
import gigahorse.Realm;
import gigahorse.Request;
import gigahorse.SignatureCalculator;
import gigahorse.WebSocket;
import gigahorse.WebSocketEvent;
import gigahorse.shaded.apache.org.apache.http.HttpEntity;
import gigahorse.shaded.apache.org.apache.http.HttpEntityEnclosingRequest;
import gigahorse.shaded.apache.org.apache.http.HttpHost;
import gigahorse.shaded.apache.org.apache.http.HttpRequest;
import gigahorse.shaded.apache.org.apache.http.HttpRequestInterceptor;
import gigahorse.shaded.apache.org.apache.http.HttpResponse;
import gigahorse.shaded.apache.org.apache.http.auth.AuthScope;
import gigahorse.shaded.apache.org.apache.http.auth.Credentials;
import gigahorse.shaded.apache.org.apache.http.auth.UsernamePasswordCredentials;
import gigahorse.shaded.apache.org.apache.http.client.CredentialsProvider;
import gigahorse.shaded.apache.org.apache.http.client.methods.HttpRequestWrapper;
import gigahorse.shaded.apache.org.apache.http.client.methods.HttpUriRequest;
import gigahorse.shaded.apache.org.apache.http.concurrent.FutureCallback;
import gigahorse.shaded.apache.org.apache.http.entity.ContentType;
import gigahorse.shaded.apache.org.apache.http.impl.client.BasicCredentialsProvider;
import gigahorse.shaded.apache.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import gigahorse.shaded.apache.org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import gigahorse.shaded.apache.org.apache.http.impl.nio.client.HttpAsyncClients;
import gigahorse.shaded.apache.org.apache.http.nio.IOControl;
import gigahorse.shaded.apache.org.apache.http.nio.client.methods.AsyncByteConsumer;
import gigahorse.shaded.apache.org.apache.http.nio.client.methods.HttpAsyncMethods;
import gigahorse.shaded.apache.org.apache.http.nio.client.methods.ZeroCopyConsumer;
import gigahorse.shaded.apache.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import gigahorse.shaded.apache.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import gigahorse.shaded.apache.org.apache.http.protocol.HttpContext;
import gigahorse.shaded.apache.org.apache.http.util.EntityUtils;
import gigahorse.support.apachehttp.ApacheByteStreamHandler;
import gigahorse.support.apachehttp.ApacheCompletionHandler;
import gigahorse.support.apachehttp.ApacheFullResponse;
import gigahorse.support.apachehttp.ApacheFullResponse$;
import gigahorse.support.apachehttp.ApacheZeroCopyHandler;
import gigahorse.support.apachehttp.FunctionHandler$;
import gigahorse.support.apachehttp.OkHandler$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.control.NonFatal$;

public class ApacheHttpClient
extends HttpClient {
    private final Config config;
    private final TrieMap<Tuple3<Option<String>, Option<Realm>, Option<SignatureCalculator>>, CloseableHttpAsyncClient> clients;

    public ApacheHttpClient(Config config) {
        this.config = config;
        this.clients = (TrieMap)TrieMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public <A> A underlying() {
        return (A)this.buildClient((Option<Realm>)None$.MODULE$, (Option<SignatureCalculator>)None$.MODULE$, (Option<HttpHost>)None$.MODULE$);
    }

    public void close() {
        this.clients.values().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.close());
    }

    public Future<FullResponse> run(Request request) {
        return this.processFull(request, OkHandler$.MODULE$.apply((Function1 & Serializable)x -> (FullResponse)Predef$.MODULE$.identity(x)));
    }

    public <A> Future<A> run(Request request, Function1<FullResponse, A> f) {
        return this.processFull(request, OkHandler$.MODULE$.apply(f));
    }

    public <A> Future<Either<Throwable, A>> run(Request request, FutureLifter<A> lifter, ExecutionContext ec) {
        return lifter.run(this.run(request), ec);
    }

    public Tuple2<HttpRequest, CloseableHttpAsyncClient> buildRequest(Request request) {
        Tuple2<HttpAsyncRequestProducer, CloseableHttpAsyncClient> tuple2 = this.buildRequestProducer(request);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HttpAsyncRequestProducer producer = (HttpAsyncRequestProducer)tuple2._1();
        CloseableHttpAsyncClient client = (CloseableHttpAsyncClient)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)producer, (Object)client);
        HttpAsyncRequestProducer producer2 = (HttpAsyncRequestProducer)tuple22._1();
        CloseableHttpAsyncClient client2 = (CloseableHttpAsyncClient)tuple22._2();
        HttpRequest r = producer2.generateRequest();
        if (request.headers().nonEmpty()) {
            request.headers().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                List vs = (List)tuple2._2();
                vs.foreach((Function1)(JProcedure1 & Serializable)v -> r.setHeader(k, v));
            });
        }
        return Tuple2$.MODULE$.apply((Object)r, (Object)client2);
    }

    public Tuple2<HttpAsyncRequestProducer, CloseableHttpAsyncClient> buildRequestProducer(Request request) {
        HttpAsyncRequestProducer httpAsyncRequestProducer;
        String string;
        if (request.queryString().isEmpty()) {
            string = request.url();
        } else {
            String q = ((IterableOnceOps)request.queryString().toSeq().flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                List vs = (List)tuple2._2();
                return vs.map((Function1 & Serializable)v -> {
                    String ek = URLEncoder.encode(k, "UTF-8");
                    String ev = URLEncoder.encode(v, "UTF-8");
                    return new StringBuilder(1).append(ek).append("=").append(ev).toString();
                });
            })).mkString("&");
            string = new StringBuilder(1).append(request.url()).append("?").append(q).toString();
        }
        String u = string;
        String string2 = request.method();
        String string3 = HttpVerbs$.MODULE$.GET();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            httpAsyncRequestProducer = HttpAsyncMethods.createGet((String)u);
        } else {
            String string5 = HttpVerbs$.MODULE$.POST();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                httpAsyncRequestProducer = ApacheHttpClient.buildProducer$1(request, u, (Function3 & Serializable)(x$0, x$1, x$2) -> HttpAsyncMethods.createPost((String)x$0, (byte[])x$1, (ContentType)x$2), (Function3 & Serializable)(x$0, x$1, x$2) -> HttpAsyncMethods.createZeroCopyPost((String)x$0, (File)x$1, (ContentType)x$2));
            } else {
                String string7 = HttpVerbs$.MODULE$.PUT();
                String string8 = string2;
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    httpAsyncRequestProducer = ApacheHttpClient.buildProducer$1(request, u, (Function3 & Serializable)(x$0, x$1, x$2) -> HttpAsyncMethods.createPut((String)x$0, (byte[])x$1, (ContentType)x$2), (Function3 & Serializable)(x$0, x$1, x$2) -> HttpAsyncMethods.createZeroCopyPut((String)x$0, (File)x$1, (ContentType)x$2));
                } else {
                    String string9 = HttpVerbs$.MODULE$.DELETE();
                    String string10 = string2;
                    if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                        httpAsyncRequestProducer = HttpAsyncMethods.createDelete((String)u);
                    } else {
                        String string11 = HttpVerbs$.MODULE$.HEAD();
                        String string12 = string2;
                        if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                            httpAsyncRequestProducer = HttpAsyncMethods.createHead((String)u);
                        } else {
                            String string13 = HttpVerbs$.MODULE$.PATCH();
                            String string14 = string2;
                            if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                                throw scala.sys.package$.MODULE$.error("PATCH method is not supported");
                            }
                            throw new MatchError((Object)string2);
                        }
                    }
                }
            }
        }
        HttpAsyncRequestProducer producer = httpAsyncRequestProducer;
        CloseableHttpAsyncClient client = request.authOpt().isDefined() || request.signatureOpt().isDefined() ? this.buildClient((Option<Realm>)request.authOpt(), (Option<SignatureCalculator>)request.signatureOpt(), (Option<HttpHost>)Option$.MODULE$.apply((Object)producer.getTarget())) : this.buildClient((Option<Realm>)request.authOpt(), (Option<SignatureCalculator>)request.signatureOpt(), (Option<HttpHost>)None$.MODULE$);
        return Tuple2$.MODULE$.apply((Object)producer, (Object)client);
    }

    public Future<File> download(Request request, File file) {
        return this.processFile(request, file, OkHandler$.MODULE$.zeroCopy((Function2<File, ContentType, BoxedUnit>)(JProcedure2 & Serializable)(_$2, _$3) -> {}));
    }

    public Future<FullResponse> processFull(Request request) {
        return this.processFull(request, FunctionHandler$.MODULE$.apply((Function1 & Serializable)x -> (FullResponse)Predef$.MODULE$.identity(x)));
    }

    public <A> Future<A> processFull(Request request, Function1<FullResponse, A> f) {
        return this.processFull(request, FunctionHandler$.MODULE$.apply(f));
    }

    public <A> Future<Either<Throwable, A>> processFull(Request request, FutureLifter<A> lifter, ExecutionContext ec) {
        return lifter.run(this.processFull(request), ec);
    }

    public <A> Future<A> processFull(Request request, ApacheCompletionHandler<A> handler) {
        Promise result = Promise$.MODULE$.apply();
        Tuple2<HttpRequest, CloseableHttpAsyncClient> tuple2 = this.buildRequest(request);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HttpRequest r = (HttpRequest)tuple2._1();
        CloseableHttpAsyncClient client = (CloseableHttpAsyncClient)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)r, (Object)client);
        HttpRequest r2 = (HttpRequest)tuple22._1();
        CloseableHttpAsyncClient client2 = (CloseableHttpAsyncClient)tuple22._2();
        client2.start();
        client2.execute((HttpUriRequest)HttpRequestWrapper.wrap((HttpRequest)r2), (FutureCallback)new FutureCallback<HttpResponse>(handler, result, this){
            private final ApacheCompletionHandler handler$1;
            private final Promise result$1;
            private final ApacheHttpClient $outer;
            {
                this.handler$1 = handler$5;
                this.result$1 = result$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void completed(HttpResponse response) {
                this.$outer.attempt(this.result$1, (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> this.completed$$anonfun$1(response)));
            }

            public void cancelled() {
                this.result$1.failure((Throwable)new RuntimeException("cancelled"));
            }

            public void failed(Exception e) {
                this.result$1.failure((Throwable)e);
            }

            private final void completed$$anonfun$1(HttpResponse response$1) {
                this.handler$1.onStatusReceived(ApacheFullResponse$.MODULE$.status(response$1));
                this.handler$1.onHeadersReceived(ApacheFullResponse$.MODULE$.headers(response$1));
                this.result$1.success(this.handler$1.onCompleted(new ApacheFullResponse(response$1)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{completed$$anonfun$1(gigahorse.shaded.apache.org.apache.http.HttpResponse )}, serializedLambda);
            }
        });
        return result.future();
    }

    public <A> void attempt(Promise<A> result, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                result.failure(e);
            }
            throw throwable;
        }
    }

    public Future<File> processFile(Request request, File file, ApacheZeroCopyHandler handler) {
        Promise result = Promise$.MODULE$.apply();
        Tuple2<HttpAsyncRequestProducer, CloseableHttpAsyncClient> tuple2 = this.buildRequestProducer(request);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HttpAsyncRequestProducer r = (HttpAsyncRequestProducer)tuple2._1();
        CloseableHttpAsyncClient client = (CloseableHttpAsyncClient)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)r, (Object)client);
        HttpAsyncRequestProducer r2 = (HttpAsyncRequestProducer)tuple22._1();
        CloseableHttpAsyncClient client2 = (CloseableHttpAsyncClient)tuple22._2();
        client2.start();
        client2.execute(r2, (HttpAsyncResponseConsumer)new ZeroCopyConsumer<File>(file, handler, result, this){
            private final ApacheZeroCopyHandler handler$1;
            private final Promise result$1;
            private final ApacheHttpClient $outer;
            {
                this.handler$1 = handler$2;
                this.result$1 = result$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(file$1);
            }

            public File process(HttpResponse response, File file, ContentType contentType) {
                this.$outer.attempt(this.result$1, (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> this.process$$anonfun$1(response, file, contentType)));
                return file;
            }

            private final void process$$anonfun$1(HttpResponse response$2, File file$2, ContentType contentType$1) {
                this.handler$1.onStatusReceived(ApacheFullResponse$.MODULE$.status(response$2));
                this.handler$1.onHeadersReceived(ApacheFullResponse$.MODULE$.headers(response$2));
                this.handler$1.onFileReceived(file$2, contentType$1);
                this.result$1.success((Object)file$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{process$$anonfun$1(gigahorse.shaded.apache.org.apache.http.HttpResponse java.io.File gigahorse.shaded.apache.org.apache.http.entity.ContentType )}, serializedLambda);
            }
        }, (FutureCallback)None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return result.future();
    }

    public <A> Future<A> processByteStream(Request request, ApacheByteStreamHandler<A> handler) {
        Promise result = Promise$.MODULE$.apply();
        Tuple2<HttpAsyncRequestProducer, CloseableHttpAsyncClient> tuple2 = this.buildRequestProducer(request);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HttpAsyncRequestProducer r = (HttpAsyncRequestProducer)tuple2._1();
        CloseableHttpAsyncClient client = (CloseableHttpAsyncClient)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)r, (Object)client);
        HttpAsyncRequestProducer r2 = (HttpAsyncRequestProducer)tuple22._1();
        CloseableHttpAsyncClient client2 = (CloseableHttpAsyncClient)tuple22._2();
        client2.start();
        client2.execute(r2, (HttpAsyncResponseConsumer)new AsyncByteConsumer<BoxedUnit>(handler, result, this){
            private final ApacheByteStreamHandler handler$1;
            private final Promise result$1;
            private final ApacheHttpClient $outer;
            {
                this.handler$1 = handler$6;
                this.result$1 = result$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onResponseReceived(HttpResponse response) {
                this.$outer.attempt(this.result$1, (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> this.onResponseReceived$$anonfun$1(response)));
            }

            public void onByteReceived(ByteBuffer buf, IOControl ioControl) {
                this.$outer.attempt(this.result$1, (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> this.onByteReceived$$anonfun$1(buf, ioControl)));
            }

            public void buildResult(HttpContext ctx) {
                this.$outer.attempt(this.result$1, (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)this::buildResult$$anonfun$1));
            }

            private final void onResponseReceived$$anonfun$1(HttpResponse response$3) {
                this.handler$1.onStatusReceived(ApacheFullResponse$.MODULE$.status(response$3));
                this.handler$1.onHeadersReceived(ApacheFullResponse$.MODULE$.headers(response$3));
            }

            private final void onByteReceived$$anonfun$1(ByteBuffer buf$1, IOControl ioControl$1) {
                this.handler$1.onByteReceived(buf$1, ioControl$1);
            }

            private final void buildResult$$anonfun$1() {
                this.result$1.completeWith(this.handler$1.buildResult());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onResponseReceived$$anonfun$1(gigahorse.shaded.apache.org.apache.http.HttpResponse ), onByteReceived$$anonfun$1(java.nio.ByteBuffer gigahorse.shaded.apache.org.apache.http.nio.IOControl ), buildResult$$anonfun$1()}, serializedLambda);
            }
        }, (FutureCallback)None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return result.future();
    }

    public CloseableHttpAsyncClient buildClient(Option<Realm> authOpt, Option<SignatureCalculator> signatureOpt, Option<HttpHost> targetOpt) {
        return (CloseableHttpAsyncClient)this.clients.getOrElseUpdate((Object)Tuple3$.MODULE$.apply((Object)targetOpt.map((Function1 & Serializable)_$4 -> _$4.toString()), authOpt, signatureOpt), () -> this.buildClient$$anonfun$2(authOpt, signatureOpt, targetOpt));
    }

    /*
     * Unable to fully structure code
     */
    private CloseableHttpAsyncClient buildClient0(HttpAsyncClientBuilder b0, Option<Realm> authOpt, Option<SignatureCalculator> signatureOpt, Option<HttpHost> targetOpt) {
        var6_5 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$6(gigahorse.shaded.apache.org.apache.http.impl.nio.client.HttpAsyncClientBuilder ), (Lgigahorse/shaded/apache/org/apache/http/impl/nio/client/HttpAsyncClientBuilder;)Lgigahorse/shaded/apache/org/apache/http/impl/nio/client/HttpAsyncClientBuilder;)((ApacheHttpClient)this), (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$7(gigahorse.shaded.apache.org.apache.http.impl.nio.client.HttpAsyncClientBuilder ), (Lgigahorse/shaded/apache/org/apache/http/impl/nio/client/HttpAsyncClientBuilder;)Lgigahorse/shaded/apache/org/apache/http/impl/nio/client/HttpAsyncClientBuilder;)((ApacheHttpClient)this)}));
        var8_6 = authOpt;
        if (var8_6 instanceof Some) {
            auth = (Realm)((Some)var8_6).value();
            v0 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$8(gigahorse.Realm gigahorse.shaded.apache.org.apache.http.impl.nio.client.HttpAsyncClientBuilder ), (Lgigahorse/shaded/apache/org/apache/http/impl/nio/client/HttpAsyncClientBuilder;)Lgigahorse/shaded/apache/org/apache/http/impl/nio/client/HttpAsyncClientBuilder;)((ApacheHttpClient)this, (Realm)auth)}));
        } else if (None$.MODULE$.equals(var8_6)) {
            v0 = package$.MODULE$.Nil();
        } else {
            throw new MatchError(var8_6);
        }
        var7_8 = v0;
        var10_9 = Tuple2$.MODULE$.apply(signatureOpt, targetOpt);
        if (var10_9 == null) ** GOTO lbl-1000
        var11_10 = (Option)var10_9._1();
        var12_11 = (Option)var10_9._2();
        if (!(var11_10 instanceof Some)) ** GOTO lbl-1000
        signatureCalculator = (SignatureCalculator)((Some)var11_10).value();
        if (var12_11 instanceof Some) {
            target = (HttpHost)((Some)var12_11).value();
            v1 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$9(gigahorse.SignatureCalculator gigahorse.shaded.apache.org.apache.http.HttpHost gigahorse.shaded.apache.org.apache.http.impl.nio.client.HttpAsyncClientBuilder ), (Lgigahorse/shaded/apache/org/apache/http/impl/nio/client/HttpAsyncClientBuilder;)Lgigahorse/shaded/apache/org/apache/http/impl/nio/client/HttpAsyncClientBuilder;)((ApacheHttpClient)this, (SignatureCalculator)signatureCalculator, (HttpHost)target)}));
        } else lbl-1000:
        // 3 sources

        {
            v1 = package$.MODULE$.Nil();
        }
        clientfs = v1.$colon$colon$colon((List)var7_8).$colon$colon$colon(var6_5);
        b1 = (HttpAsyncClientBuilder)clientfs.foldLeft((Object)b0, (Function2)(Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$10(gigahorse.shaded.apache.org.apache.http.impl.nio.client.HttpAsyncClientBuilder scala.Function1 ), (Lgigahorse/shaded/apache/org/apache/http/impl/nio/client/HttpAsyncClientBuilder;Lscala/Function1;)Lgigahorse/shaded/apache/org/apache/http/impl/nio/client/HttpAsyncClientBuilder;)());
        result = b1.build();
        return result;
    }

    public BasicCredentialsProvider buildCredentialProvider(Realm auth) {
        AuthScope authScope;
        UsernamePasswordCredentials credentials;
        BasicCredentialsProvider p;
        AuthScheme authScheme = auth.scheme();
        if (AuthScheme.Basic$.MODULE$.equals(authScheme)) {
            p = new BasicCredentialsProvider();
            credentials = new UsernamePasswordCredentials(auth.username(), auth.password());
            Option option = auth.realmNameOpt();
            if (option instanceof Some) {
                String realm = (String)((Some)option).value();
                authScope = new AuthScope(AuthScope.ANY_HOST, -1, realm);
            } else {
                authScope = AuthScope.ANY;
            }
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(20).append("unsupported scheme: ").append(auth.scheme()).toString());
        }
        AuthScope scope = authScope;
        p.setCredentials(scope, (Credentials)credentials);
        return p;
    }

    public HttpRequestInterceptor buildInterceptor(SignatureCalculator signatureCalculator, HttpHost target) {
        return (request, context) -> {
            Tuple2 tuple2;
            String uri = new StringBuilder(0).append(target.toString()).append(HttpRequestWrapper.wrap((HttpRequest)request).getURI().toString()).toString();
            HttpRequest httpRequest = request;
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest req = (HttpEntityEnclosingRequest)httpRequest;
                HttpEntity entity = req.getEntity();
                Option contentType = Option$.MODULE$.apply((Object)entity.getContentType()).map((Function1 & Serializable)_$5 -> _$5.getValue());
                tuple2 = Tuple2$.MODULE$.apply((Object)contentType, (Object)EntityUtils.toByteArray((HttpEntity)entity));
            } else {
                tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)new byte[0]);
            }
            Tuple2 tuple22 = tuple2;
            Option contentType = (Option)tuple22._1();
            byte[] content = (byte[])tuple22._2();
            Tuple2 tuple23 = signatureCalculator.sign(uri, contentType, content);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            String name = (String)tuple23._1();
            String value = (String)tuple23._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)name, (Object)value);
            String name2 = (String)tuple24._1();
            String value2 = (String)tuple24._2();
            request.setHeader(name2, value2);
        };
    }

    public Future<WebSocket> websocket(Request request, PartialFunction<WebSocketEvent, BoxedUnit> handler) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private static final ContentType buildContentType$1(Option opt, ContentType fallback) {
        ContentType contentType;
        Option option = opt;
        if (option instanceof Some) {
            String value = (String)((Some)option).value();
            contentType = ContentType.create((String)value);
        } else {
            contentType = fallback;
        }
        return contentType;
    }

    private static final ContentType ct$1(Request request$1) {
        Body body = request$1.body();
        return body instanceof FileBody ? ApacheHttpClient.buildContentType$1(request$1.contentType(), ContentType.MULTIPART_FORM_DATA) : ApacheHttpClient.buildContentType$1(request$1.contentType(), ContentType.create((String)"text/plain", (String)"utf-8"));
    }

    private static final HttpAsyncRequestProducer buildProducer$1(Request request$2, String u$1, Function3 create, Function3 createZero) {
        HttpAsyncRequestProducer httpAsyncRequestProducer;
        Body body = request$2.body();
        if (body instanceof EmptyBody) {
            httpAsyncRequestProducer = (HttpAsyncRequestProducer)create.apply((Object)u$1, (Object)new byte[0], (Object)ApacheHttpClient.ct$1(request$2));
        } else if (body instanceof FileBody) {
            FileBody b = (FileBody)body;
            httpAsyncRequestProducer = (HttpAsyncRequestProducer)createZero.apply((Object)u$1, (Object)b.file(), (Object)ApacheHttpClient.ct$1(request$2));
        } else if (body instanceof InMemoryBody) {
            InMemoryBody b = (InMemoryBody)body;
            httpAsyncRequestProducer = (HttpAsyncRequestProducer)create.apply((Object)u$1, (Object)b.bytes(), (Object)ApacheHttpClient.ct$1(request$2));
        } else {
            throw new MatchError((Object)body);
        }
        return httpAsyncRequestProducer;
    }

    private final CloseableHttpAsyncClient buildClient$$anonfun$2(Option authOpt$1, Option signatureOpt$1, Option targetOpt$1) {
        return this.buildClient0(HttpAsyncClients.custom(), (Option<Realm>)authOpt$1, (Option<SignatureCalculator>)signatureOpt$1, (Option<HttpHost>)targetOpt$1);
    }

    private final /* synthetic */ HttpAsyncClientBuilder $anonfun$6(HttpAsyncClientBuilder b) {
        return this.config.maxConnections() > 0 ? b.setMaxConnTotal(this.config.maxConnections()) : b;
    }

    private final /* synthetic */ HttpAsyncClientBuilder $anonfun$7(HttpAsyncClientBuilder b) {
        return this.config.maxConnectionsPerHost() > 0 ? b.setMaxConnPerRoute(this.config.maxConnectionsPerHost()) : b;
    }

    private final /* synthetic */ HttpAsyncClientBuilder $anonfun$8(Realm auth$1, HttpAsyncClientBuilder x$1) {
        HttpAsyncClientBuilder httpAsyncClientBuilder = x$1;
        if (httpAsyncClientBuilder == null) {
            throw new MatchError((Object)httpAsyncClientBuilder);
        }
        HttpAsyncClientBuilder b = httpAsyncClientBuilder;
        return b.setDefaultCredentialsProvider((CredentialsProvider)this.buildCredentialProvider(auth$1));
    }

    private final /* synthetic */ HttpAsyncClientBuilder $anonfun$9(SignatureCalculator signatureCalculator$1, HttpHost target$1, HttpAsyncClientBuilder x$1) {
        HttpAsyncClientBuilder httpAsyncClientBuilder = x$1;
        if (httpAsyncClientBuilder == null) {
            throw new MatchError((Object)httpAsyncClientBuilder);
        }
        HttpAsyncClientBuilder b = httpAsyncClientBuilder;
        return b.addInterceptorLast(this.buildInterceptor(signatureCalculator$1, target$1));
    }

    private static final /* synthetic */ HttpAsyncClientBuilder $anonfun$10(HttpAsyncClientBuilder b, Function1 f) {
        return (HttpAsyncClientBuilder)f.apply((Object)b);
    }
}

