/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.support.asynchttpclient;

import com.typesafe.sslconfig.ssl.Protocols$;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import gigahorse.Config;
import gigahorse.Realm;
import gigahorse.SSL$;
import gigahorse.shaded.ahc.io.netty.handler.ssl.SslContextBuilder;
import gigahorse.shaded.ahc.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import gigahorse.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import gigahorse.shaded.ahc.org.asynchttpclient.SslEngineFactory;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.ssl.JsseSslEngineFactory;
import gigahorse.support.asynchttpclient.AhcHttpClient$;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AhcConfig$ {
    public static AhcConfig$ MODULE$;

    static {
        new AhcConfig$();
    }

    public AsyncHttpClientConfig buildConfig(Config config) {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();
        builder.setConnectTimeout(this.toMillis((Duration)config.connectTimeout()));
        builder.setRequestTimeout(this.toMillis((Duration)config.requestTimeout()));
        builder.setReadTimeout(this.toMillis(config.readTimeout()));
        builder.setFollowRedirect(config.followRedirects());
        builder.setMaxRedirects(config.maxRedirects());
        builder.setCompressionEnforced(config.compressionEnforced());
        config.userAgentOpt().foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.setUserAgent(x$1));
        config.authOpt().foreach((Function1 & Serializable & scala.Serializable)x -> builder.setRealm(AhcHttpClient$.MODULE$.buildRealm((Realm)x)));
        builder.setMaxRequestRetry(config.maxRequestRetry());
        builder.setDisableUrlEncodingForBoundRequests(config.disableUrlEncoding());
        builder.setUseProxyProperties(config.useProxyProperties());
        builder.setKeepAlive(config.keepAlive());
        builder.setPooledConnectionIdleTimeout(this.toMillis(config.pooledConnectionIdleTimeout()));
        builder.setConnectionTtl(this.toMillis(config.connectionTtl()));
        builder.setMaxConnectionsPerHost(config.maxConnectionsPerHost());
        builder.setMaxConnections(config.maxConnections());
        this.configureSsl(config.ssl(), builder);
        builder.setWebSocketMaxFrameSize((int)config.webSocketMaxFrameSize().bytes());
        return builder.build();
    }

    public int toMillis(Duration duration) {
        return duration.isFinite() ? (int)duration.toMillis() : -1;
    }

    public void configureSsl(SSLConfigSettings sslConfig, DefaultAsyncHttpClientConfig.Builder builder) {
        SSLContext sslContext;
        Tuple2 tuple2 = SSL$.MODULE$.buildContext(sslConfig);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SSLContext sSLContext = sslContext = (SSLContext)tuple2._1();
        SSLContext sslContext2 = sSLContext;
        SSLParameters defaultParams = sslContext2.getDefaultSSLParameters();
        String[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = this.configureProtocols(defaultProtocols, sslConfig);
        defaultParams.setProtocols(protocols);
        builder.setEnabledProtocols(protocols);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        builder.setEnabledCipherSuites(defaultCiphers);
        builder.setAcceptAnyCertificate(sslConfig.loose().acceptAnyCertificate());
        if (sslConfig.loose().acceptAnyCertificate()) {
            builder.setSslContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build());
        } else {
            builder.setSslEngineFactory((SslEngineFactory)new JsseSslEngineFactory(sslContext2));
        }
    }

    public String[] configureProtocols(String[] existingProtocols, SSLConfigSettings sslConfig) {
        String[] stringArray;
        Option option = sslConfig.enabledProtocols();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq configuredProtocols = (Seq)some.value();
            Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
            stringArray = (String[])((TraversableOnce)configuredProtocols.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)AhcConfig$.$anonfun$configureProtocols$1(objectArray, elem)))).toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (None$.MODULE$.equals(option)) {
            Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
            stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Protocols$.MODULE$.recommendedProtocols())).filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)AhcConfig$.$anonfun$configureProtocols$2(objectArray, elem))))).toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)option);
        }
        String[] definedProtocols = stringArray;
        return definedProtocols;
    }

    public static final /* synthetic */ boolean $anonfun$configureProtocols$1(Object[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$1).contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$configureProtocols$2(Object[] eta$0$2$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$2$1).contains(elem);
    }

    private AhcConfig$() {
        MODULE$ = this;
    }
}

