/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar.util;

import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjar.util.IoUtil;
import com.eed3si9n.jarjar.util.JarProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.zip.JarMarker;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipOutputStream;

public abstract class AntJarProcessor
extends Jar {
    private EntryStruct struct = new EntryStruct();
    private JarProcessor proc;
    private byte[] buf = new byte[8192];
    private Set<String> dirs = new HashSet<String>();
    private boolean filesOnly;
    protected boolean verbose;
    private static final ZipExtraField[] JAR_MARKER = new ZipExtraField[]{JarMarker.getInstance()};

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public abstract void execute() throws BuildException;

    public void execute(JarProcessor jarProcessor) throws BuildException {
        this.proc = jarProcessor;
        super.execute();
    }

    public void setFilesonly(boolean bl) {
        super.setFilesonly(bl);
        this.filesOnly = bl;
    }

    protected void zipDir(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
    }

    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l, File file, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IoUtil.pipe((InputStream)inputStream, (OutputStream)byteArrayOutputStream, (byte[])this.buf);
        this.struct.data = byteArrayOutputStream.toByteArray();
        this.struct.name = string;
        this.struct.time = l;
        if (this.proc.process(this.struct)) {
            if (n == 0) {
                n = 33188;
            }
            if (!this.filesOnly) {
                this.addParentDirs(this.struct.name, zipOutputStream);
            }
            super.zipFile((InputStream)new ByteArrayInputStream(this.struct.data), zipOutputStream, this.struct.name, this.struct.time, file, n);
        }
    }

    private void addParentDirs(String string, ZipOutputStream zipOutputStream) throws IOException {
        String string2;
        int n = string.lastIndexOf(47);
        if (n >= 0 && this.dirs.add(string2 = string.substring(0, n))) {
            this.addParentDirs(string2, zipOutputStream);
            super.zipDir((File)null, zipOutputStream, string2 + "/", 16877, JAR_MARKER);
        }
    }

    public void reset() {
        super.reset();
        this.cleanHelper();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.cleanHelper();
    }

    protected void cleanHelper() {
        this.verbose = false;
        this.filesOnly = false;
        this.dirs.clear();
    }
}

