/*
 * Decompiled with CFR 0.152.
 */
package sbtassembly;

import com.eed3si9n.jarjarabrams.ModuleCoordinate$;
import com.eed3si9n.jarjarabrams.ShadeRule;
import com.eed3si9n.jarjarabrams.Shader$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.Set;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sbt.ConcurrentRestrictions;
import sbt.Keys$;
import sbt.Package;
import sbt.Package$;
import sbt.PackageOption;
import sbt.Tags$;
import sbt.Task;
import sbt.TaskKey;
import sbt.internal.util.AList$;
import sbt.internal.util.Attributed;
import sbt.internal.util.HCons;
import sbt.internal.util.HListFormats$;
import sbt.internal.util.HNil;
import sbt.internal.util.HNil$;
import sbt.internal.util.Init;
import sbt.io.RichFile$;
import sbt.io.Using;
import sbt.io.Using$;
import sbt.librarymanagement.VersionNumber;
import sbt.package$;
import sbt.std.FullInstance$;
import sbt.std.TaskStreams;
import sbt.util.FileInfo;
import sbt.util.FilesInfo;
import sbt.util.FilesInfo$;
import sbt.util.Level$;
import sbt.util.Logger;
import sbt.util.ModifiedFileInfo;
import sbt.util.ModifiedFileInfo$;
import sbt.util.SingletonCache$;
import sbt.util.Tracked$;
import sbtassembly.Assembly;
import sbtassembly.AssemblyOption;
import sbtassembly.AssemblyPlugin$autoImport$;
import sbtassembly.MergeStrategy;
import sbtassembly.MergeStrategy$;
import sbtassembly.PluginCompat$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParMap;
import scala.collection.parallel.immutable.ParIterable;
import scala.collection.parallel.immutable.ParIterable$;
import scala.collection.parallel.immutable.ParVector;
import scala.collection.parallel.immutable.ParVector$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Properties$;
import scala.util.matching.Regex;
import sjsonnew.JsonFormat;

public final class Assembly$ {
    public static Assembly$ MODULE$;
    private final Seq<ShadeRule> defaultShadeRules;
    private final String newLine;
    private final String indent;
    private final String newLineIndented;
    private final ConcurrentRestrictions.Tag assemblyTag;
    private final Vector<String> scalaPre213Libraries;
    private final Vector<String> scala213AndLaterLibraries;
    private final Using<URI, FileSystem> jarFileSystemResource;
    private final Using<Assembly.JarEntry, InputStream> jarEntryInputStreamResource;
    private final Using<Path, OutputStream> jarEntryOutputStreamResource;
    private final Using<byte[], ByteArrayInputStream> byteArrayInputStreamResource;
    private final Function1<MergeStrategy, String> strategyDisplayName;

    static {
        new Assembly$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("value", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public Seq<ShadeRule> defaultShadeRules() {
        return this.defaultShadeRules;
    }

    public String newLine() {
        return this.newLine;
    }

    public String indent() {
        return this.indent;
    }

    public String newLineIndented() {
        return this.newLineIndented;
    }

    public ConcurrentRestrictions.Tag assemblyTag() {
        return this.assemblyTag;
    }

    public Vector<String> scalaPre213Libraries() {
        return this.scalaPre213Libraries;
    }

    public Vector<String> scala213AndLaterLibraries() {
        return this.scala213AndLaterLibraries;
    }

    public Using<URI, FileSystem> jarFileSystemResource() {
        return this.jarFileSystemResource;
    }

    public Using<Assembly.JarEntry, InputStream> jarEntryInputStreamResource() {
        return this.jarEntryInputStreamResource;
    }

    public Using<Path, OutputStream> jarEntryOutputStreamResource() {
        return this.jarEntryOutputStreamResource;
    }

    public Using<byte[], ByteArrayInputStream> byteArrayInputStreamResource() {
        return this.byteArrayInputStreamResource;
    }

    public Function1<MergeStrategy, String> strategyDisplayName() {
        return this.strategyDisplayName;
    }

    public Init.Initialize<Task<File>> assemblyTask(TaskKey<File> key) {
        return package$.MODULE$.richInitializeTask((Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple8(Keys$.MODULE$.packageOptions().in(key), AssemblyPlugin$autoImport$.MODULE$.assemblyOption().in(key), Keys$.MODULE$.externalDependencyClasspath().in(AssemblyPlugin$autoImport$.MODULE$.assembly()), Keys$.MODULE$.fullClasspath().in(AssemblyPlugin$autoImport$.MODULE$.assembly()), AssemblyPlugin$autoImport$.MODULE$.assemblyOutputPath().in(key), AssemblyPlugin$autoImport$.MODULE$.assemblyJarName().in(key), Keys$.MODULE$.streams().in(key), Keys$.MODULE$.test().in(key)), (Function1 & Serializable & scala.Serializable)$p$macro$9 -> {
            BoxedUnit boxedUnit;
            Seq seq = (Seq)$p$macro$9._1();
            AssemblyOption assemblyOption = (AssemblyOption)$p$macro$9._2();
            Seq seq2 = (Seq)$p$macro$9._3();
            Seq seq3 = (Seq)$p$macro$9._4();
            File file = (File)$p$macro$9._5();
            String string = (String)$p$macro$9._6();
            TaskStreams taskStreams = (TaskStreams)$p$macro$9._7();
            BoxedUnit t = boxedUnit = (BoxedUnit)$p$macro$9._8();
            TaskStreams s = taskStreams;
            return MODULE$.assemble(string.replaceAll(".jar", ""), file, (Seq<Attributed<File>>)seq3, (Seq<Attributed<File>>)seq2, assemblyOption, (Seq<PackageOption>)seq, s.cacheDirectory(), (Logger)s.log());
        }, AList$.MODULE$.tuple8())).tag((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConcurrentRestrictions.Tag[]{this.assemblyTag()}));
    }

    public File assemble(String targetJarName, File output, Seq<Attributed<File>> classpath, Seq<Attributed<File>> externalDepClasspath, AssemblyOption ao, Seq<PackageOption> po, File cacheDir, Logger log) {
        File file;
        Tuple2 tuple2 = (Tuple2)Assembly$.timed$1(Level$.MODULE$.Debug(), "Separate classpath projects and all dependencies", (Function0 & Serializable & scala.Serializable)() -> ((TraversableLike)classpath.toVector().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> ((File)x$1.data()).getCanonicalPath(), (Ordering)Ordering.String$.MODULE$)).partition((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)Assembly$.$anonfun$assemble$5(c))), log);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector jars = (Vector)tuple2._1();
        Vector dirs = (Vector)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)jars, (Object)dirs);
        Vector jars2 = (Vector)tuple22._1();
        Vector dirs2 = (Vector)tuple22._2();
        scala.collection.immutable.Set externalDeps = (scala.collection.immutable.Set)Assembly$.timed$1(Level$.MODULE$.Debug(), "Collect only external dependencies", (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Set)((TraversableOnce)externalDepClasspath.map((Function1 & Serializable & scala.Serializable)x$3 -> (File)x$3.data(), Seq$.MODULE$.canBuildFrom())).toSet().filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Assembly$.$anonfun$assemble$8(file))), log);
        Seq excludedJars = (Seq)Assembly$.timed$1(Level$.MODULE$.Debug(), "Collect excluded jar names", (Function0 & Serializable & scala.Serializable)() -> (Seq)ao.excludedJars().map((Function1 & Serializable & scala.Serializable)x$4 -> (File)x$4.data(), Seq$.MODULE$.canBuildFrom()), log);
        VersionNumber scalaVersionParts = package$.MODULE$.VersionNumber().apply(ao.scalaVersion());
        boolean isScala213AndLater = scalaVersionParts.numbers().length() >= 2 && BoxesRunTime.unboxToLong((Object)scalaVersionParts._1().get()) >= 2L && BoxesRunTime.unboxToLong((Object)scalaVersionParts._2().get()) >= 13L;
        Vector<String> scalaLibraries = isScala213AndLater ? this.scala213AndLaterLibraries() : this.scalaPre213Libraries();
        Vector filteredJars = (Vector)Assembly$.timed$1(Level$.MODULE$.Debug(), "Filter jars", (Function0 & Serializable & scala.Serializable)() -> (Vector)jars2.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Attributed attributed = x0$1;
            if (excludedJars.contains((Object)package$.MODULE$.fileToRichFile((File)attributed.data()))) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            if (MODULE$.isScalaLibraryFile(scalaLibraries, package$.MODULE$.fileToRichFile((File)attributed.data()))) {
                if (ao.includeScala()) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)attributed));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            if (externalDeps.contains((Object)package$.MODULE$.fileToRichFile((File)attributed.data()))) {
                if (ao.includeDependency()) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)attributed));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            if (ao.includeBin()) {
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)attributed));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Vector$.MODULE$.canBuildFrom()), log);
        Function2<String, Function0<InputStream>, Option<Tuple2<String, Function0<InputStream>>>> classShader = this.shader((Seq<ShadeRule>)((Seq)ao.shadeRules().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isApplicableToCompiling()))), log);
        Vector classByParentDir = !ao.includeBin() ? scala.package$.MODULE$.Vector().empty() : (Vector)dirs2.flatMap((Function1 & Serializable & scala.Serializable)dir -> (Seq)package$.MODULE$.singleFileFinder((File)dir.data()).$times$times(package$.MODULE$.DirectoryFilter().unary_$minus()).get().map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(dir.data()), x$6), Seq$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
        Vector classMappings = (Vector)Assembly$.timed$1(Level$.MODULE$.Debug(), "Collect and shade project classes", (Function0 & Serializable & scala.Serializable)() -> (Vector)classByParentDir.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                File parentDir = (File)tuple2._1();
                File file = (File)tuple2._2();
                String originalTarget = ((Object)((File)RichFile$.MODULE$.relativeTo$extension(package$.MODULE$.fileToRichFile(file), parentDir).get()).toPath()).toString();
                return Option$.MODULE$.option2Iterable(((Option)classShader.apply((Object)originalTarget, (Function0 & Serializable & scala.Serializable)() -> new BufferedInputStream(new FileInputStream(file)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        String shadedName = (String)tuple2._1();
                        Function0 stream = (Function0)tuple2._2();
                        return new Assembly.Project(targetJarName, originalTarget, shadedName, (Function0<InputStream>)stream);
                    }
                    throw new MatchError((Object)tuple2);
                }));
            }
            throw new MatchError((Object)tuple2);
        }, Vector$.MODULE$.canBuildFrom()), log);
        Function1 & Serializable & scala.Serializable jarShader = (Function1 & Serializable & scala.Serializable)module -> MODULE$.shader((Seq<ShadeRule>)((Seq)ao.shadeRules().filter((Function1 & Serializable & scala.Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)Assembly$.$anonfun$assemble$21(module, rule)))), log);
        Tuple2 tuple23 = (Tuple2)Assembly$.timed$1(Level$.MODULE$.Debug(), "Collect and shade dependency entries", (Function0 & Serializable & scala.Serializable)() -> ((GenericTraversableTemplate)filteredJars.par().map((Function1 & Serializable & scala.Serializable)jar -> {
            Assembly.ModuleCoordinate module = (Assembly.ModuleCoordinate)jar.metadata().get(Keys$.MODULE$.moduleID().key()).map((Function1 & Serializable & scala.Serializable)m -> new Assembly.ModuleCoordinate(m.organization(), m.name(), m.revision())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Assembly.ModuleCoordinate("", RichFile$.MODULE$.name$extension(package$.MODULE$.fileToRichFile((File)jar.data())).replaceAll(".jar", ""), ""));
            JarFile jarFile = new JarFile((File)jar.data());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)jarFile), ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(jarFile.entries()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDirectory())).toVector().par().flatMap((Function1 & Serializable & scala.Serializable)entry -> Option$.MODULE$.option2Iterable(((Option)((Function2)jarShader.apply((Object)module)).apply((Object)entry.getName(), (Function0 & Serializable & scala.Serializable)() -> jarFile.getInputStream((ZipEntry)entry))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    String shadedName = (String)tuple2._1();
                    Function0 stream = (Function0)tuple2._2();
                    return new Assembly.Library(module, entry.getName(), shadedName, (Function0<InputStream>)stream);
                }
                throw new MatchError((Object)tuple2);
            })), (CanBuildFrom)ParVector$.MODULE$.canBuildFrom()));
        }, (CanBuildFrom)ParVector$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms()), log);
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        ParVector jarFiles = (ParVector)tuple23._1();
        ParVector jarFileEntries = (ParVector)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)jarFiles, (Object)jarFileEntries);
        ParVector jarFiles2 = (ParVector)tuple24._1();
        ParVector jarFileEntries2 = (ParVector)tuple24._2();
        try {
            Tuple2 tuple25 = (Tuple2)Assembly$.timed$1(Level$.MODULE$.Debug(), "Collect renames", (Function0 & Serializable & scala.Serializable)() -> ((TraversableLike)classMappings.$plus$plus((GenTraversableOnce)jarFileEntries2.flatten((Function1)Predef$.MODULE$.$conforms()), Vector$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)mapping -> BoxesRunTime.boxToBoolean((boolean)Assembly$.$anonfun$assemble$31(ao, mapping))), log);
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            Vector mappingsToRename = (Vector)tuple25._1();
            Vector others = (Vector)tuple25._2();
            Tuple2 tuple26 = new Tuple2((Object)mappingsToRename, (Object)others);
            Vector mappingsToRename2 = (Vector)tuple26._1();
            Vector others2 = (Vector)tuple26._2();
            Vector renamedEntries = (Vector)Assembly$.timed$1(Level$.MODULE$.Debug(), "Process renames", (Function0 & Serializable & scala.Serializable)() -> MODULE$.merge((Vector<Assembly.Dependency>)mappingsToRename2, (Function1<String, Option<MergeStrategy>>)(Function1 & Serializable & scala.Serializable)path -> Option$.MODULE$.apply(ao.mergeStrategy().apply(path)), log), log);
            Vector<Assembly.Dependency> renamedDependencies = this.convertToDependency((Vector<Assembly.MergedEntry>)renamedEntries);
            Tuple2<Manifest, Option<Object>> tuple27 = this.createManifest(po, log);
            if (tuple27 == null) {
                throw new MatchError(tuple27);
            }
            Manifest jarManifest = (Manifest)tuple27._1();
            Option timestamp = (Option)tuple27._2();
            Tuple2 tuple28 = new Tuple2((Object)jarManifest, (Object)timestamp);
            Manifest jarManifest2 = (Manifest)tuple28._1();
            Option timestamp2 = (Option)tuple28._2();
            Function1 & Serializable & scala.Serializable secondPassMergeStrategy = (Function1 & Serializable & scala.Serializable)path -> {
                MergeStrategy mergeStrategy = (MergeStrategy)ao.mergeStrategy().apply(path);
                String string = mergeStrategy.name();
                String string2 = MergeStrategy$.MODULE$.rename().name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return Option$.MODULE$.empty();
                }
                return Option$.MODULE$.apply((Object)mergeStrategy);
            };
            Function0 & Serializable & scala.Serializable buildAssembly = (Function0 & Serializable & scala.Serializable)() -> {
                File file;
                Vector mergedEntries = (Vector)Assembly$.timed$1(Level$.MODULE$.Debug(), "Merge all conflicting jar entries (including those renamed)", (Function0 & Serializable & scala.Serializable)() -> MODULE$.merge((Vector<Assembly.Dependency>)((Vector)renamedDependencies.$plus$plus((GenTraversableOnce)others2, Vector$.MODULE$.canBuildFrom())), (Function1<String, Option<MergeStrategy>>)secondPassMergeStrategy, log), log);
                Assembly$.timed$1(Level$.MODULE$.Debug(), "Report merge results", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    MODULE$.reportMergeResults((Vector<Assembly.MergedEntry>)renamedEntries, log);
                    MODULE$.reportMergeResults((Vector<Assembly.MergedEntry>)mergedEntries, log);
                }, log);
                Assembly$.timed$1(Level$.MODULE$.Debug(), "Finding remaining conflicts that were not merged", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.reportConflictsMissedByTheMerge((Vector<Assembly.MergedEntry>)mergedEntries, log), log);
                GenSeq jarEntriesToWrite = (GenSeq)Assembly$.timed$1(Level$.MODULE$.Debug(), "Sort/Parallelize merged entries", (Function0 & Serializable & scala.Serializable)() -> {
                    if (ao.repeatableBuild()) {
                        return (GenSeq)((IndexedSeq)mergedEntries.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.entries(), Vector$.MODULE$.canBuildFrom())).seq().sortBy((Function1 & Serializable & scala.Serializable)x$12 -> x$12.target(), (Ordering)Ordering.String$.MODULE$);
                    }
                    return ((Vector)mergedEntries.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.entries(), Vector$.MODULE$.canBuildFrom())).par();
                }, log);
                long localTime = BoxesRunTime.unboxToLong((Object)timestamp2.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)t -> t - (long)TimeZone.getDefault().getOffset(t)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis()));
                Assembly$.timed$1(Level$.MODULE$.Debug(), "Create jar", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    package$.MODULE$.IO().delete(output);
                    MODULE$.createJar(output, (GenSeq<Assembly.JarEntry>)jarEntriesToWrite, jarManifest2, localTime);
                }, log);
                String fullSha1 = (String)Assembly$.timed$1(Level$.MODULE$.Debug(), "Hash newly-built Jar", (Function0 & Serializable & scala.Serializable)() -> MODULE$.hash(output), log);
                if (ao.appendContentHash()) {
                    String sha1 = (String)ao.maxHashLength().fold((Function0 & Serializable & scala.Serializable)() -> fullSha1, (Function1 & Serializable & scala.Serializable)length -> Assembly$.$anonfun$assemble$48(fullSha1, BoxesRunTime.unboxToInt((Object)length)));
                    String newName = new StringBuilder(5).append(output.getName().replaceAll("\\.[^.]*$", "")).append("-").append(sha1).append(".jar").toString();
                    File outputWithHash = new File(output.getParentFile(), newName);
                    package$.MODULE$.IO().delete(outputWithHash);
                    Files.move(output.toPath(), outputWithHash.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    file = outputWithHash;
                } else {
                    file = output;
                }
                File builtAssemblyJar = file;
                ao.prependShellScript().foreach((Function1 & Serializable & scala.Serializable)shellScript -> Assembly$.timed$1(Level$.MODULE$.Info(), "Prepend shell script", (Function0 & Serializable & scala.Serializable)() -> {
                    File tmp = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(cacheDir), "assemblyExec.tmp");
                    if (tmp.exists()) {
                        package$.MODULE$.IO().delete(tmp);
                    }
                    Files.move(builtAssemblyJar.toPath(), tmp.toPath(), new CopyOption[0]);
                    File x$1 = builtAssemblyJar;
                    String x$2 = ((TraversableOnce)shellScript.map((Function1 & Serializable & scala.Serializable)x$14 -> new StringBuilder(1).append((String)x$14).append("\n").toString(), Seq$.MODULE$.canBuildFrom())).mkString();
                    boolean x$3 = false;
                    Charset x$4 = package$.MODULE$.IO().write$default$3();
                    package$.MODULE$.IO().write(x$1, x$2, x$4, x$3);
                    ((Using)Using$.MODULE$.fileOutputStream(true)).apply((Object)builtAssemblyJar, (Function1 & Serializable & scala.Serializable)out -> {
                        Assembly$.$anonfun$assemble$52(tmp, out);
                        return BoxedUnit.UNIT;
                    });
                    package$.MODULE$.IO().delete(tmp);
                    if (!Properties$.MODULE$.isWin()) {
                        Set<PosixFilePermission> posixPermissions = Files.getPosixFilePermissions(builtAssemblyJar.toPath(), new LinkOption[0]);
                        posixPermissions.add(PosixFilePermission.OWNER_EXECUTE);
                        posixPermissions.add(PosixFilePermission.GROUP_EXECUTE);
                        posixPermissions.add(PosixFilePermission.OTHERS_EXECUTE);
                        return Files.setPosixFilePermissions(builtAssemblyJar.toPath(), posixPermissions);
                    }
                    return BoxedUnit.UNIT;
                }, log));
                log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("Built: ").append(builtAssemblyJar.toPath()).toString());
                log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Jar hash: ").append(fullSha1).toString());
                return builtAssemblyJar;
            };
            scala.collection.immutable.Map mergeStrategiesByPathList = (scala.collection.immutable.Map)Assembly$.timed$1(Level$.MODULE$.Debug(), "Collect all merge strategies for cache check", (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)((TraversableLike)renamedDependencies.$plus$plus((GenTraversableOnce)others2, Vector$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$15 -> x$15.target()).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    String target = (String)tuple2._1();
                    MergeStrategy mergeStrategy = (MergeStrategy)((Option)secondPassMergeStrategy.apply((Object)target)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MergeStrategy$.MODULE$.deduplicate());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)target), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)mergeStrategy.isBuiltIn())), (Object)mergeStrategy.name()));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom()), log);
            if (ao.cacheOutput() && !mergeStrategiesByPathList.values().exists((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)Assembly$.$anonfun$assemble$59(log, x0$6)))) {
                Tuple2 tuple29 = classByParentDir.unzip((Function1)Predef$.MODULE$.$conforms());
                if (tuple29 == null) {
                    throw new MatchError((Object)tuple29);
                }
                Vector classes = (Vector)tuple29._2();
                Vector classes2 = classes;
                FilesInfo filesInfo = FileInfo.lastModified$.MODULE$.apply((scala.collection.immutable.Set)classes2.toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)filteredJars.map((Function1 & Serializable & scala.Serializable)x$16 -> (File)x$16.data(), Vector$.MODULE$.canBuildFrom())).toSet()));
                scala.collection.immutable.Map map = mergeStrategiesByPathList;
                Manifest manifest = jarManifest2;
                boolean bl = ao.repeatableBuild();
                Option<Seq<String>> option = ao.prependShellScript();
                Option<Object> option2 = ao.maxHashLength();
                boolean bl2 = ao.appendContentHash();
                HCons cacheKey = HNil$.MODULE$.$colon$plus$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl2)).$colon$plus$colon(option2).$colon$plus$colon(option).$colon$plus$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl)).$colon$plus$colon((Object)manifest).$colon$plus$colon((Object)map).$colon$plus$colon((Object)filesInfo);
                file = this.cachedAssembly((HCons<FilesInfo<ModifiedFileInfo>, HCons<scala.collection.immutable.Map<String, Tuple2<Object, String>>, HCons<Manifest, HCons<Object, HCons<Option<Seq<String>>, HCons<Option<Object>, HCons<Object, HNil>>>>>>>)cacheKey, cacheDir, ao.scalaVersion(), log, (Function0<File>)buildAssembly);
            } else {
                file = (File)buildAssembly.apply();
            }
        }
        finally {
            Assembly$.timed$1(Level$.MODULE$.Debug(), "Close library jar references", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> jarFiles2.foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
                x$24.close();
                return BoxedUnit.UNIT;
            }), log);
        }
        return file;
    }

    public boolean isSystemJunkFile(String fileName) {
        String string = fileName.toLowerCase();
        return ".ds_store".equals(string) ? true : "thumbs.db".equals(string);
    }

    public boolean isLicenseFile(String fileName) {
        String string;
        Regex LicenseFile = new StringOps(Predef$.MODULE$.augmentString("(license|licence|notice|copying)([.]\\w+)?$")).r();
        Option option = LicenseFile.unapplySeq((CharSequence)(string = fileName.toLowerCase()));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String ext;
            String string2 = ext = (String)((LinearSeqOptimized)option.get()).apply(1);
            String string3 = ".class";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                return true;
            }
        }
        return false;
    }

    public boolean isReadme(String fileName) {
        String string;
        Regex ReadMe = new StringOps(Predef$.MODULE$.augmentString("(readme|about)([.]\\w+)?$")).r();
        Option option = ReadMe.unapplySeq((CharSequence)(string = fileName.toLowerCase()));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String ext;
            String string2 = ext = (String)((LinearSeqOptimized)option.get()).apply(1);
            String string3 = ".class";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                return true;
            }
        }
        return false;
    }

    public boolean isConfigFile(String fileName) {
        String string = fileName.toLowerCase();
        return "reference.conf".equals(string) ? true : ("reference-overrides.conf".equals(string) ? true : ("application.conf".equals(string) ? true : ("rootdoc.txt".equals(string) ? true : "play.plugins".equals(string))));
    }

    public boolean isScalaLibraryFile(Vector<String> scalaLibraries, File file) {
        return scalaLibraries.exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Assembly$.$anonfun$isScalaLibraryFile$1(file, x)));
    }

    public Function2<String, Function0<InputStream>, Option<Tuple2<String, Function0<InputStream>>>> shader(Seq<ShadeRule> shadeRules, Logger log) {
        if (shadeRules.isEmpty()) {
            return (Function2 & Serializable & scala.Serializable)(name, inputStream) -> new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), inputStream));
        }
        Function2 bytecodeShader = Shader$.MODULE$.bytecodeShader(shadeRules, false, false);
        return (Function2 & Serializable & scala.Serializable)(name, inputStream) -> {
            Option shadeResult;
            InputStream is;
            block0: {
                is = (InputStream)inputStream.apply();
                shadeResult = (Option)bytecodeShader.apply((Object)scala.tools.nsc.io.package$.MODULE$.Streamable().bytes((Function0 & Serializable & scala.Serializable)() -> is), name);
                if (!shadeResult.isEmpty()) break block0;
                log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Shade discarded: ").append((String)name).toString());
            }
            return shadeResult.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    byte[] bytes = (byte[])tuple2._1();
                    String shadedName = (String)tuple2._2();
                    String string = name;
                    String string2 = shadedName;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Shaded: ").append((String)name).append(" -> ").append(shadedName).toString());
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)shadedName), (Function0 & Serializable & scala.Serializable)() -> new ByteArrayInputStream(bytes, is){
                        private final InputStream is$1;

                        public void close() {
                            this.is$1.close();
                        }
                        {
                            this.is$1 = is$1;
                            super(bytes$1);
                        }
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        };
    }

    public File cachedAssembly(HCons<FilesInfo<ModifiedFileInfo>, HCons<scala.collection.immutable.Map<String, Tuple2<Object, String>>, HCons<Manifest, HCons<Object, HCons<Option<Seq<String>>, HCons<Option<Object>, HCons<Object, HNil>>>>>>> inputs, File cacheDir, String scalaVersion, Logger log, Function0<File> buildAssembly) {
        Function1 cacheBlock = Tracked$.MODULE$.inputChanged(RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(cacheDir), new StringBuilder(18).append("assembly-cacheKey-").append(scalaVersion).toString()), (Function2 & Serializable & scala.Serializable)(inputChanged, x$25) -> Tracked$.MODULE$.lastOutput(RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(cacheDir), new StringBuilder(17).append("assembly-outputs-").append(scalaVersion).toString()), (Function2 & Serializable & scala.Serializable)(x$26, previousOutput) -> {
            boolean outputExists = previousOutput.exists((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)x$27.exists()));
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(inputChanged, outputExists);
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl2 = sp2._2$mcZ$sp();
                if (!bl && bl2) {
                    log$3.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Assembly jar up to date: ").append(((File)previousOutput.get()).toPath()).toString());
                    return (File)previousOutput.get();
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl3 = sp2._2$mcZ$sp();
                if (bl && bl3) {
                    log$3.debug((Function0 & Serializable & scala.Serializable)() -> "Building assembly jar due to changed inputs...");
                    package$.MODULE$.IO().delete((File)previousOutput.get());
                    return (File)buildAssembly$1.apply();
                }
            }
            if (sp2 != null) {
                log$3.debug((Function0 & Serializable & scala.Serializable)() -> "Building assembly jar due to missing output...");
                return (File)buildAssembly$1.apply();
            }
            throw new MatchError((Object)sp2);
        }, package$.MODULE$.CacheImplicits().isoStringFormat(package$.MODULE$.CacheImplicits().fileStringIso())), HListFormats$.MODULE$.hconsFormat(FilesInfo$.MODULE$.format(ModifiedFileInfo$.MODULE$.format()), HListFormats$.MODULE$.hconsHListJF((JsonFormat)package$.MODULE$.CacheImplicits().mapFormat(package$.MODULE$.CacheImplicits().StringJsonKeyFormat(), package$.MODULE$.CacheImplicits().tuple2Format((JsonFormat)package$.MODULE$.CacheImplicits().BooleanJsonFormat(), (JsonFormat)package$.MODULE$.CacheImplicits().StringJsonFormat())), HListFormats$.MODULE$.hconsHListJF(Package$.MODULE$.manifestFormat(), HListFormats$.MODULE$.hconsHListJF((JsonFormat)package$.MODULE$.CacheImplicits().BooleanJsonFormat(), HListFormats$.MODULE$.hconsHListJF(package$.MODULE$.CacheImplicits().optionFormat((JsonFormat)package$.MODULE$.CacheImplicits().seqFormat((JsonFormat)package$.MODULE$.CacheImplicits().StringJsonFormat())), HListFormats$.MODULE$.hconsHListJF(package$.MODULE$.CacheImplicits().optionFormat((JsonFormat)package$.MODULE$.CacheImplicits().IntJsonFormat()), HListFormats$.MODULE$.hconsHListJF((JsonFormat)package$.MODULE$.CacheImplicits().BooleanJsonFormat(), HListFormats$.MODULE$.lnilHListJF1()))))))), SingletonCache$.MODULE$.basicSingletonCache(HListFormats$.MODULE$.hconsFormat(FilesInfo$.MODULE$.format(ModifiedFileInfo$.MODULE$.format()), HListFormats$.MODULE$.hconsHListJF((JsonFormat)package$.MODULE$.CacheImplicits().mapFormat(package$.MODULE$.CacheImplicits().StringJsonKeyFormat(), package$.MODULE$.CacheImplicits().tuple2Format((JsonFormat)package$.MODULE$.CacheImplicits().BooleanJsonFormat(), (JsonFormat)package$.MODULE$.CacheImplicits().StringJsonFormat())), HListFormats$.MODULE$.hconsHListJF(Package$.MODULE$.manifestFormat(), HListFormats$.MODULE$.hconsHListJF((JsonFormat)package$.MODULE$.CacheImplicits().BooleanJsonFormat(), HListFormats$.MODULE$.hconsHListJF(package$.MODULE$.CacheImplicits().optionFormat((JsonFormat)package$.MODULE$.CacheImplicits().seqFormat((JsonFormat)package$.MODULE$.CacheImplicits().StringJsonFormat())), HListFormats$.MODULE$.hconsHListJF(package$.MODULE$.CacheImplicits().optionFormat((JsonFormat)package$.MODULE$.CacheImplicits().IntJsonFormat()), HListFormats$.MODULE$.hconsHListJF((JsonFormat)package$.MODULE$.CacheImplicits().BooleanJsonFormat(), HListFormats$.MODULE$.lnilHListJF1())))))))));
        return (File)((Function1)cacheBlock.apply(inputs)).apply((Object)BoxedUnit.UNIT);
    }

    public void createJar(File output, GenSeq<Assembly.JarEntry> entries, Manifest manifest, long localTime) {
        this.jarFileSystemResource().apply((Object)URI.create(new StringBuilder(4).append("jar:").append(output.toURI()).toString()), (Function1 & Serializable & scala.Serializable)jarFs -> {
            Assembly$.$anonfun$createJar$1(manifest, entries, localTime, jarFs);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<Manifest, Option<Object>> createManifest(Seq<PackageOption> po, Logger log) {
        Manifest manifest = new Manifest();
        scala.collection.mutable.Map main = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)manifest.getMainAttributes()).asScala();
        ObjectRef time = ObjectRef.create((Object)None$.MODULE$);
        po.foreach((Function1 & Serializable & scala.Serializable)option -> {
            PackageOption packageOption = option;
            if (packageOption instanceof Package.JarManifest) {
                Package.JarManifest jarManifest = (Package.JarManifest)packageOption;
                Manifest mergeManifest = jarManifest.m();
                Package$.MODULE$.mergeManifests(manifest, mergeManifest);
                return BoxedUnit.UNIT;
            }
            if (packageOption instanceof Package.MainClass) {
                Package.MainClass mainClass = (Package.MainClass)packageOption;
                String mainClassName = mainClass.mainClassName();
                return main.put((Object)Attributes.Name.MAIN_CLASS, (Object)mainClassName);
            }
            if (packageOption instanceof Package.ManifestAttributes) {
                Package.ManifestAttributes manifestAttributes = (Package.ManifestAttributes)packageOption;
                Seq attrs = manifestAttributes.attributes();
                return main.$plus$plus$eq((TraversableOnce)attrs);
            }
            String string = option.getClass().getName();
            String string2 = "sbt.Package$FixedTimestamp";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                BoxedUnit boxedUnit;
                try {
                    Object object;
                    PackageOption qual1 = option;
                    try {
                        object = Assembly$.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, new Object[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getCause();
                    }
                    time$1.elem = (Option)object;
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable e) {
                    log.debug((Function0 & Serializable & scala.Serializable)() -> e.toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Ignored unknown package option ").append(option).toString());
            return BoxedUnit.UNIT;
        });
        Object object = !main.contains((Object)Attributes.Name.MANIFEST_VERSION) ? main.put((Object)Attributes.Name.MANIFEST_VERSION, (Object)"1.0") : BoxedUnit.UNIT;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)manifest), (Object)((Option)time.elem));
    }

    public Vector<Assembly.Dependency> convertToDependency(Vector<Assembly.MergedEntry> renames) {
        return (Vector)renames.flatMap((Function1 & Serializable & scala.Serializable)renamedEntry -> (Vector)((TraversableLike)renamedEntry.entries().zip(renamedEntry.origins(), Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Assembly.JarEntry entry = (Assembly.JarEntry)tuple2._1();
                Assembly.Dependency p = (Assembly.Dependency)tuple2._2();
                if (p instanceof Assembly.Project) {
                    Assembly.Project project = (Assembly.Project)p;
                    String name = project.name();
                    String source = project.source();
                    Function0<InputStream> stream = project.stream();
                    return project.copy(name, source, entry.target(), stream);
                }
            }
            if (tuple2 != null) {
                Assembly.JarEntry entry = (Assembly.JarEntry)tuple2._1();
                Assembly.Dependency l = (Assembly.Dependency)tuple2._2();
                if (l instanceof Assembly.Library) {
                    Assembly.Library library = (Assembly.Library)l;
                    Assembly.ModuleCoordinate moduleCoord = library.moduleCoord();
                    String source = library.source();
                    Function0<InputStream> stream = library.stream();
                    return library.copy(moduleCoord, source, entry.target(), stream);
                }
            }
            throw new MatchError((Object)tuple2);
        }, Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
    }

    public Vector<Assembly.MergedEntry> merge(Vector<Assembly.Dependency> mappings, Function1<String, Option<MergeStrategy>> mergeStrategies, Logger log) {
        Tuple2 tuple2 = ((ParIterableLike)((ParIterableLike)mappings.groupBy((Function1 & Serializable & scala.Serializable)x$29 -> x$29.target()).par()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String target = (String)tuple2._1();
                Vector mappings = (Vector)tuple2._2();
                return (Either)((Option)mergeStrategies.apply((Object)target)).map((Function1 & Serializable & scala.Serializable)x$30 -> MergeStrategy$.MODULE$.merge((MergeStrategy)x$30, (Vector<Assembly.Dependency>)mappings)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MergeStrategy$.MODULE$.merge(MergeStrategy$.MODULE$.deduplicate(), (Vector<Assembly.Dependency>)mappings));
            }
            throw new MatchError((Object)tuple2);
        }, (CanBuildFrom)ParIterable$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)x$31.isRight()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ParIterable successfullyMerged = (ParIterable)tuple2._1();
        ParIterable failures = (ParIterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)successfullyMerged, (Object)failures);
        ParIterable successfullyMerged2 = (ParIterable)tuple22._1();
        ParIterable failures2 = (ParIterable)tuple22._2();
        if (failures2.nonEmpty()) {
            log.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append(failures2.size()).append(" error(s) were encountered during the merge:").toString());
            throw new RuntimeException(((ParIterableLike)failures2.map((Function1 & Serializable & scala.Serializable)x$33 -> (String)x$33.left().get(), (CanBuildFrom)ParIterable$.MODULE$.canBuildFrom())).mkString(this.newLine(), this.newLine(), ""));
        }
        return ((ParIterableLike)successfullyMerged2.map((Function1 & Serializable & scala.Serializable)x$34 -> (Assembly.MergedEntry)x$34.right().get(), (CanBuildFrom)ParIterable$.MODULE$.canBuildFrom())).toVector();
    }

    public void reportMergeResults(Vector<Assembly.MergedEntry> mergedEntries, Logger log) {
        mergedEntries.groupBy((Function1 & Serializable & scala.Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)entry.mergeStrategy().isBuiltIn())), (Object)entry.mergeStrategy().name())).values().seq().foreach((Function1 & Serializable & scala.Serializable)entries -> {
            Assembly$.$anonfun$reportMergeResults$2(log, entries);
            return BoxedUnit.UNIT;
        });
    }

    public void reportConflictsMissedByTheMerge(Vector<Assembly.MergedEntry> mergedEntries, Logger log) {
        Function1 & Serializable & scala.Serializable parentPaths = (Function1 & Serializable & scala.Serializable)entry -> {
            Path target = Paths.get(entry.target(), new String[0]);
            return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), target.getNameCount()).map((Function1 & Serializable & scala.Serializable)i -> Assembly$.$anonfun$reportConflictsMissedByTheMerge$2(target, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        };
        ParMap parentDirToOrigins = ((ParIterableLike)mergedEntries.par().flatMap((Function1 & Serializable & scala.Serializable)mergedEntry -> (Vector)mergedEntry.entries().flatMap((Function1 & Serializable & scala.Serializable)jarEntry -> (IndexedSeq)((TraversableLike)parentPaths.apply(jarEntry)).map((Function1 & Serializable & scala.Serializable)parentPath -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(parentPath), mergedEntry.origins()), IndexedSeq$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom()), (CanBuildFrom)ParVector$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                return path;
            }
            throw new MatchError((Object)tuple2);
        }).mapValues((Function1 & Serializable & scala.Serializable)x$36 -> (ParVector)x$36.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Vector origins = (Vector)tuple2._2();
                return origins;
            }
            throw new MatchError((Object)tuple2);
        }, (CanBuildFrom)ParVector$.MODULE$.canBuildFrom()));
        ParVector filesConflictingWithDirs = (ParVector)((ParIterableLike)mergedEntries.par().flatMap((Function1 & Serializable & scala.Serializable)entry -> (Vector)entry.entries().map((Function1 & Serializable & scala.Serializable)jarEntry -> {
            GenSeq dirConflicts = (GenSeq)parentDirToOrigins.getOrElse((Object)jarEntry.target(), (Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Vector().empty());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)jarEntry.target()), entry.origins())), (Object)dirConflicts);
        }, Vector$.MODULE$.canBuildFrom()), (CanBuildFrom)ParVector$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Assembly$.$anonfun$reportConflictsMissedByTheMerge$12(x0$3))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                GenSeq conflictingDirectories = (GenSeq)tuple2._2();
                if (tuple22 != null) {
                    String target = (String)tuple22._1();
                    Vector conflictingFiles = (Vector)tuple22._2();
                    String sources = conflictingFiles.mkString(MODULE$.newLineIndented());
                    String directories = conflictingDirectories.mkString(MODULE$.newLineIndented());
                    return scala.package$.MODULE$.Left().apply((Object)new StringBuilder(74).append("Files to be written at '").append(target).append("' have the same name as directories to be written:").append(MODULE$.newLineIndented()).append(directories).append(MODULE$.newLineIndented()).append(sources).toString());
                }
            }
            throw new MatchError((Object)tuple2);
        }, (CanBuildFrom)ParVector$.MODULE$.canBuildFrom());
        if (filesConflictingWithDirs.nonEmpty()) {
            log.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append(filesConflictingWithDirs.size()).append(" error(s) were still encountered after the merge:").toString());
            throw new RuntimeException(((ParIterableLike)filesConflictingWithDirs.map((Function1 & Serializable & scala.Serializable)x$37 -> (String)x$37.left().get(), (CanBuildFrom)ParVector$.MODULE$.canBuildFrom())).mkString(this.newLine(), this.newLine(), ""));
        }
    }

    public String hash(File file) {
        return this.bytesToString((Seq<Object>)Predef$.MODULE$.wrapByteArray(this.sha1().digest((byte[])FileInfo.hash$.MODULE$.apply(file).hash().seq().toArray(ClassTag$.MODULE$.Byte()))));
    }

    public MessageDigest sha1() {
        return MessageDigest.getInstance("SHA-1");
    }

    public String sha1Content(byte[] b) {
        return (String)this.byteArrayInputStreamResource().apply((Object)b, (Function1 & Serializable & scala.Serializable)in -> {
            MessageDigest messageDigest = MODULE$.sha1();
            byte[] buffer = new byte[8192];
            this.read$1((ByteArrayInputStream)in, buffer, messageDigest);
            return MODULE$.bytesToString((Seq<Object>)Predef$.MODULE$.wrapByteArray(messageDigest.digest()));
        });
    }

    public String bytesToString(Seq<Object> bytes) {
        return ((TraversableOnce)bytes.map((Function1 & Serializable & scala.Serializable)x$38 -> Assembly$.$anonfun$bytesToString$1(BoxesRunTime.unboxToByte((Object)x$38)), Seq$.MODULE$.canBuildFrom())).mkString();
    }

    private static final Object timed$1(Enumeration.Value level, String desc, Function0 f, Logger log$1) {
        log$1.log(level, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append(desc).append(" start:").toString());
        long start = Instant.now().toEpochMilli();
        Object res = f.apply();
        long end = Instant.now().toEpochMilli();
        log$1.log(level, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append(desc).append(" end. Took ").append(end - start).append(" ms").toString());
        return res;
    }

    public static final /* synthetic */ boolean $anonfun$assemble$5(Attributed c) {
        return PluginCompat$.MODULE$.ClasspathUtilities().isArchive((File)c.data());
    }

    public static final /* synthetic */ boolean $anonfun$assemble$8(File file) {
        return PluginCompat$.MODULE$.ClasspathUtilities().isArchive(file);
    }

    public static final /* synthetic */ boolean $anonfun$assemble$21(Assembly.ModuleCoordinate module$1, ShadeRule rule) {
        return rule.isApplicableToAll() || rule.isApplicableTo(ModuleCoordinate$.MODULE$.apply(module$1.organization(), module$1.name(), module$1.version()));
    }

    public static final /* synthetic */ boolean $anonfun$assemble$31(AssemblyOption ao$1, Product mapping) {
        String string = ((MergeStrategy)ao$1.mergeStrategy().apply((Object)((Assembly.Dependency)mapping).target())).name();
        String string2 = MergeStrategy$.MODULE$.rename().name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$assemble$48(String fullSha1$1, int length) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(fullSha1$1)).take(length);
    }

    public static final /* synthetic */ void $anonfun$assemble$52(File tmp$1, BufferedOutputStream out) {
        package$.MODULE$.IO().transfer(tmp$1, (OutputStream)out);
    }

    public static final /* synthetic */ boolean $anonfun$assemble$59(Logger log$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            boolean isBuiltIn = tuple2._1$mcZ$sp();
            String name = (String)tuple2._2();
            if (!isBuiltIn) {
                log$1.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Caching disabled because of a custom merge strategy: '").append(name).append("'").toString());
            }
            return !isBuiltIn;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isScalaLibraryFile$1(File file$2, String x) {
        return file$2.getName().startsWith(x);
    }

    public static final /* synthetic */ void $anonfun$createJar$4(InputStream inputStream$1, OutputStream outputStream) {
        package$.MODULE$.IO().transfer(inputStream$1, outputStream);
    }

    public static final /* synthetic */ void $anonfun$createJar$3(Path path$1, InputStream inputStream) {
        MODULE$.jarEntryOutputStreamResource().apply((Object)path$1, (Function1 & Serializable & scala.Serializable)outputStream -> {
            Assembly$.$anonfun$createJar$4(inputStream, outputStream);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$createJar$2(FileSystem jarFs$1, Assembly.JarEntry entry) {
        Path path = jarFs$1.getPath(entry.target(), new String[0]);
        Object object = path.getParent() != null && !Files.exists(path.getParent(), new LinkOption[0]) ? Files.createDirectories(path.getParent(), new FileAttribute[0]) : BoxedUnit.UNIT;
        MODULE$.jarEntryInputStreamResource().apply((Object)entry, (Function1 & Serializable & scala.Serializable)inputStream -> {
            Assembly$.$anonfun$createJar$3(path, inputStream);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$createJar$1(Manifest manifest$1, GenSeq entries$1, long localTime$2, FileSystem jarFs) {
        Path manifestPath = jarFs.getPath("META-INF/MANIFEST.MF", new String[0]);
        Files.createDirectories(manifestPath.getParent(), new FileAttribute[0]);
        OutputStream manifestOut = Files.newOutputStream(manifestPath, StandardOpenOption.CREATE);
        manifest$1.write(manifestOut);
        manifestOut.close();
        entries$1.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            Assembly$.$anonfun$createJar$2(jarFs, entry);
            return BoxedUnit.UNIT;
        });
        FileTime fileTime = FileTime.fromMillis(localTime$2);
        Files.walk(jarFs.getPath("/", new String[0]), new FileVisitOption[0]).filter(x$28 -> {
            String string = ((Object)x$28).toString();
            String string2 = "/";
            return string == null ? string2 != null : !string.equals(string2);
        }).forEach(path -> {
            BasicFileAttributeView view = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
            view.setTimes(fileTime, fileTime, fileTime);
        });
    }

    public static final /* synthetic */ boolean $anonfun$reportMergeResults$3(MergeStrategy mergeStrategy$1, Assembly.MergedEntry entry) {
        return entry.origins().size() >= mergeStrategy$1.notifyThreshold();
    }

    public static final /* synthetic */ int $anonfun$reportMergeResults$4(Assembly.MergedEntry x$35) {
        return x$35.origins().size();
    }

    public static final /* synthetic */ void $anonfun$reportMergeResults$2(Logger log$5, Vector entries) {
        MergeStrategy mergeStrategy = ((Assembly.MergedEntry)entries.head()).mergeStrategy();
        Vector entriesToNotify = (Vector)entries.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)Assembly$.$anonfun$reportMergeResults$3(mergeStrategy, entry)));
        int totalMerged = BoxesRunTime.unboxToInt((Object)((TraversableOnce)entriesToNotify.map((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToInteger((int)Assembly$.$anonfun$reportMergeResults$4(x$35)), Vector$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (totalMerged > 0) {
            Enumeration.Value value = mergeStrategy.detailLogLevel();
            Enumeration.Value value2 = Level$.MODULE$.Debug();
            String notifyDetails = !(value != null ? !value.equals(value2) : value2 != null) ? " (Run the task at debug level to see the details)" : "";
            log$5.log(mergeStrategy.summaryLogLevel(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append(totalMerged).append(" file(s) merged using strategy '").append(MODULE$.strategyDisplayName().apply((Object)mergeStrategy)).append("'").append(notifyDetails).toString());
            log$5.log(mergeStrategy.detailLogLevel(), (Function0 & Serializable & scala.Serializable)() -> entriesToNotify.seq().mkString(""));
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$reportConflictsMissedByTheMerge$2(Path target$1, int i) {
        return ((Object)target$1.subpath(0, i)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$reportConflictsMissedByTheMerge$12(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            GenSeq conflictingDirs = (GenSeq)tuple2._2();
            if (tuple22 != null) {
                return conflictingDirs.nonEmpty();
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private final void read$1(ByteArrayInputStream in$1, byte[] buffer$1, MessageDigest messageDigest$1) {
        int byteCount;
        while ((byteCount = in$1.read(buffer$1)) >= 0) {
            messageDigest$1.update(buffer$1, 0, byteCount);
        }
    }

    public static final /* synthetic */ String $anonfun$bytesToString$1(byte x$38) {
        return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$38)}));
    }

    private Assembly$() {
        MODULE$ = this;
        this.defaultShadeRules = Nil$.MODULE$;
        this.newLine = "\n";
        this.indent = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(2);
        this.newLineIndented = new StringBuilder(0).append(this.newLine()).append(this.indent()).toString();
        this.assemblyTag = Tags$.MODULE$.Tag("assembly");
        this.scalaPre213Libraries = (Vector)scala.package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala-actors", "scala-compiler", "scala-continuations", "scala-library", "scala-parser-combinators", "scala-reflect", "scala-swing", "scala-xml"}));
        this.scala213AndLaterLibraries = (Vector)scala.package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala-actors", "scala-compiler", "scala-continuations", "scala-library", "scala-reflect"}));
        this.jarFileSystemResource = Using$.MODULE$.resource((Function1 & Serializable & scala.Serializable)uri -> FileSystems.newFileSystem(uri, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create"), (Object)"true")}))).asJava()));
        this.jarEntryInputStreamResource = Using$.MODULE$.resource((Function1 & Serializable & scala.Serializable)entry -> (InputStream)entry.stream().apply());
        this.jarEntryOutputStreamResource = Using$.MODULE$.resource((Function1 & Serializable & scala.Serializable)path -> Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE));
        this.byteArrayInputStreamResource = Using$.MODULE$.resource((Function1 & Serializable & scala.Serializable)bytes -> new ByteArrayInputStream((byte[])bytes));
        this.strategyDisplayName = (Function1 & Serializable & scala.Serializable)mergeStrategy -> new StringBuilder(0).append(mergeStrategy.name()).append((Object)(mergeStrategy.isBuiltIn() ? "" : " (Custom)")).toString();
    }
}

