/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.hc.client5.http.impl;

import gigahorse.shaded.apache.org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import gigahorse.shaded.apache.org.apache.hc.client5.http.config.RequestConfig;
import gigahorse.shaded.apache.org.apache.hc.client5.http.protocol.HttpClientContext;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Contract;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.ThreadingBehavior;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HeaderElement;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpResponse;
import gigahorse.shaded.apache.org.apache.hc.core5.http.message.MessageSupport;
import gigahorse.shaded.apache.org.apache.hc.core5.http.protocol.HttpContext;
import gigahorse.shaded.apache.org.apache.hc.core5.util.Args;
import gigahorse.shaded.apache.org.apache.hc.core5.util.TimeValue;
import java.util.Iterator;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        Iterator<HeaderElement> it = MessageSupport.iterate(response, "keep-alive");
        while (it.hasNext()) {
            HeaderElement he = it.next();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return TimeValue.ofSeconds(Long.parseLong(value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        HttpClientContext clientContext = HttpClientContext.cast(context);
        RequestConfig requestConfig = clientContext.getRequestConfigOrDefault();
        return requestConfig.getConnectionKeepAlive();
    }
}

