/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.hc.core5.http.impl.nio;

import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Contract;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Internal;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.ThreadingBehavior;
import gigahorse.shaded.apache.org.apache.hc.core5.function.Callback;
import gigahorse.shaded.apache.org.apache.hc.core5.http.ConnectionReuseStrategy;
import gigahorse.shaded.apache.org.apache.hc.core5.http.ContentLengthStrategy;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpRequest;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpResponse;
import gigahorse.shaded.apache.org.apache.hc.core5.http.config.CharCodingConfig;
import gigahorse.shaded.apache.org.apache.hc.core5.http.config.Http1Config;
import gigahorse.shaded.apache.org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import gigahorse.shaded.apache.org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import gigahorse.shaded.apache.org.apache.hc.core5.http.impl.Http1StreamListener;
import gigahorse.shaded.apache.org.apache.hc.core5.http.impl.nio.DefaultHttpRequestParserFactory;
import gigahorse.shaded.apache.org.apache.hc.core5.http.impl.nio.DefaultHttpResponseWriterFactory;
import gigahorse.shaded.apache.org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexer;
import gigahorse.shaded.apache.org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import gigahorse.shaded.apache.org.apache.hc.core5.http.nio.HandlerFactory;
import gigahorse.shaded.apache.org.apache.hc.core5.http.nio.NHttpMessageParserFactory;
import gigahorse.shaded.apache.org.apache.hc.core5.http.nio.NHttpMessageWriterFactory;
import gigahorse.shaded.apache.org.apache.hc.core5.http.protocol.HttpProcessor;
import gigahorse.shaded.apache.org.apache.hc.core5.reactor.ProtocolIOSession;
import gigahorse.shaded.apache.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public final class ServerHttp1StreamDuplexerFactory {
    private final HttpProcessor httpProcessor;
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final Http1Config http1Config;
    private final CharCodingConfig charCodingConfig;
    private final NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private final NHttpMessageWriterFactory<HttpResponse> responseWriterFactory;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final Http1StreamListener streamListener;
    private final Callback<Exception> exceptionCallback;

    public ServerHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, Http1StreamListener streamListener, Callback<Exception> exceptionCallback) {
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.exchangeHandlerFactory = Args.notNull(exchangeHandlerFactory, "Exchange handler factory");
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.connectionReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.requestParserFactory = requestParserFactory != null ? requestParserFactory : new DefaultHttpRequestParserFactory(this.http1Config);
        this.responseWriterFactory = responseWriterFactory != null ? responseWriterFactory : new DefaultHttpResponseWriterFactory(this.http1Config);
        this.incomingContentStrategy = incomingContentStrategy != null ? incomingContentStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = outgoingContentStrategy != null ? outgoingContentStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.streamListener = streamListener;
        this.exceptionCallback = exceptionCallback;
    }

    public ServerHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, Http1StreamListener streamListener, Callback<Exception> exceptionCallback) {
        this(httpProcessor, exchangeHandlerFactory, http1Config, charCodingConfig, connectionReuseStrategy, requestParserFactory, responseWriterFactory, null, null, streamListener, exceptionCallback);
    }

    public ServerHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, Http1Config http1Config, CharCodingConfig charCodingConfig, Http1StreamListener streamListener, Callback<Exception> exceptionCallback) {
        this(httpProcessor, exchangeHandlerFactory, http1Config, charCodingConfig, null, null, null, streamListener, exceptionCallback);
    }

    public ServerHttp1StreamDuplexer create(String scheme, ProtocolIOSession ioSession) {
        return new ServerHttp1StreamDuplexer(ioSession, this.httpProcessor, this.exchangeHandlerFactory, scheme, this.http1Config, this.charCodingConfig, this.connectionReuseStrategy, this.requestParserFactory.create(), this.responseWriterFactory.create(), this.incomingContentStrategy, this.outgoingContentStrategy, this.streamListener, this.exceptionCallback);
    }
}

