/*
 * Decompiled with CFR 0.152.
 */
package sjsonnew.support.scalajson.unsafe;

import java.io.Serializable;
import scala.Char$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import sjsonnew.shaded.scalajson.ast.unsafe.JFalse$;
import sjsonnew.shaded.scalajson.ast.unsafe.JNull$;
import sjsonnew.shaded.scalajson.ast.unsafe.JNumber;
import sjsonnew.shaded.scalajson.ast.unsafe.JNumber$;
import sjsonnew.shaded.scalajson.ast.unsafe.JString;
import sjsonnew.shaded.scalajson.ast.unsafe.JString$;
import sjsonnew.shaded.scalajson.ast.unsafe.JTrue$;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.JsonPrinter$;

public interface JsonPrinter
extends Function1<JValue, String> {
    public static boolean requiresEncoding(char c) {
        return JsonPrinter$.MODULE$.requiresEncoding(c);
    }

    public static String apply$(JsonPrinter $this, JValue x) {
        return $this.apply(x);
    }

    default public String apply(JValue x) {
        return this.apply(x, (Option<String>)None$.MODULE$, this.apply$default$3());
    }

    public static String apply$(JsonPrinter $this, JValue x, Option jsonpCallback, StringBuilder sb) {
        return $this.apply(x, (Option<String>)jsonpCallback, sb);
    }

    default public String apply(JValue x, Option<String> jsonpCallback, StringBuilder sb) {
        Object object;
        Option<String> option = jsonpCallback;
        if (option instanceof Some) {
            String callback = (String)((Some)option).value();
            sb.append(callback).append('(');
            this.print(x, sb);
            object = sb.append(')');
        } else if (None$.MODULE$.equals(option)) {
            this.print(x, sb);
            object = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return sb.toString();
    }

    public static Option apply$default$2$(JsonPrinter $this) {
        return $this.apply$default$2();
    }

    default public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    public static StringBuilder apply$default$3$(JsonPrinter $this) {
        return $this.apply$default$3();
    }

    default public StringBuilder apply$default$3() {
        return new StringBuilder(256);
    }

    public void print(JValue var1, Appendable var2);

    public static void printLeaf$(JsonPrinter $this, JValue x, Appendable sb) {
        $this.printLeaf(x, sb);
    }

    default public void printLeaf(JValue x, Appendable sb) {
        JValue jValue = x;
        if (JNull$.MODULE$.equals(jValue)) {
            sb.append("null");
            return;
        }
        if (JTrue$.MODULE$.equals(jValue)) {
            sb.append("true");
            return;
        }
        if (JFalse$.MODULE$.equals(jValue)) {
            sb.append("false");
            return;
        }
        if (jValue instanceof JNumber) {
            String string;
            JNumber jNumber = JNumber$.MODULE$.unapply((JNumber)jValue);
            String x2 = string = jNumber._1();
            sb.append(x2);
            return;
        }
        if (jValue instanceof JString) {
            String string;
            JString jString = JString$.MODULE$.unapply((JString)jValue);
            String x3 = string = jString._1();
            this.printString(x3, sb);
            return;
        }
        throw new IllegalStateException();
    }

    public static void printString$(JsonPrinter $this, String s, Appendable sb) {
        $this.printString(s, sb);
    }

    default public void printString(String s, Appendable sb) {
        Appendable appendable;
        sb.append('\"');
        int n = JsonPrinter.firstToBeEncoded$1(s, JsonPrinter.firstToBeEncoded$default$1$1());
        if (-1 == n) {
            appendable = sb.append(s);
        } else {
            int first = n;
            sb.append(s, 0, first);
            JsonPrinter.append$1(s, sb, first);
            appendable = BoxedUnit.UNIT;
        }
        sb.append('\"');
    }

    public static void printArray$(JsonPrinter $this, Object iterable, Function0 printSeparator, Function1 f) {
        $this.printArray(iterable, (Function0<BoxedUnit>)printSeparator, f);
    }

    default public <A> void printArray(Object iterable, Function0<BoxedUnit> printSeparator, Function1<A, BoxedUnit> f) {
        BooleanRef first = BooleanRef.create((boolean)true);
        Object object = Predef$.MODULE$.genericArrayOps(iterable);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)a -> {
            if (first$1.elem) {
                boolean bl;
                first$1.elem = bl = false;
            } else {
                printSeparator.apply$mcV$sp();
            }
            f.apply(a);
        });
    }

    private static int firstToBeEncoded$1(String s$1, int ix) {
        while (ix != s$1.length()) {
            if (JsonPrinter$.MODULE$.requiresEncoding(s$1.charAt(ix))) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    private static int firstToBeEncoded$default$1$1() {
        return 0;
    }

    private static void append$1(String s$2, Appendable sb$1, int ix) {
        while (ix < s$2.length()) {
            Appendable appendable;
            char c = s$2.charAt(ix);
            char c2 = c;
            if (!JsonPrinter$.MODULE$.requiresEncoding(c2)) {
                appendable = sb$1.append(c2);
            } else {
                switch (c) {
                    case '\"': {
                        appendable = sb$1.append("\\\"");
                        break;
                    }
                    case '\\': {
                        appendable = sb$1.append("\\\\");
                        break;
                    }
                    case '\b': {
                        appendable = sb$1.append("\\b");
                        break;
                    }
                    case '\f': {
                        appendable = sb$1.append("\\f");
                        break;
                    }
                    case '\n': {
                        appendable = sb$1.append("\\n");
                        break;
                    }
                    case '\r': {
                        appendable = sb$1.append("\\r");
                        break;
                    }
                    case '\t': {
                        appendable = sb$1.append("\\t");
                        break;
                    }
                    default: {
                        char x = c;
                        if (x <= '\u000f') {
                            appendable = sb$1.append("\\u000").append(Integer.toHexString(Char$.MODULE$.char2int(x)));
                            break;
                        }
                        char x2 = c;
                        if (x2 <= '\u00ff') {
                            appendable = sb$1.append("\\u00").append(Integer.toHexString(Char$.MODULE$.char2int(x2)));
                            break;
                        }
                        char x3 = c;
                        if (x3 <= '\u0fff') {
                            appendable = sb$1.append("\\u0").append(Integer.toHexString(Char$.MODULE$.char2int(x3)));
                            break;
                        }
                        char x4 = c;
                        appendable = sb$1.append("\\u").append(Integer.toHexString(Char$.MODULE$.char2int(x4)));
                        break;
                    }
                }
            }
            ++ix;
        }
    }
}

