/*
 * Decompiled with CFR 0.152.
 */
package treehugger;

import scala.Function1;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import treehugger.Chars$;
import treehugger.NameManglers$TermNameMangling$;
import treehugger.Names;
import treehugger.StdNames;
import treehugger.StdNames$nme$;
import treehugger.Symbols;

public abstract class NameManglers$TermNameMangling$class {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConstructorName(StdNames$nme$ $this, Names.Name name) {
        Names.Name name2 = name;
        Names.Name name3 = $this.CONSTRUCTOR();
        if (name2 == null) {
            if (name3 == null) return true;
        } else if (name2.equals(name3)) return true;
        Names.Name name4 = name;
        Names.Name name5 = $this.MIXIN_CONSTRUCTOR();
        if (name4 != null) {
            if (!name4.equals(name5)) return false;
            return true;
        }
        if (name5 == null) return true;
        return false;
    }

    public static boolean isExceptionResultName(StdNames$nme$ $this, Names.Name name) {
        return name.startsWith($this.EXCEPTION_RESULT_PREFIX());
    }

    public static boolean isImplClassName(StdNames$nme$ $this, Names.Name name) {
        return $this.stripAnonNumberSuffix(name).endsWith($this.IMPL_CLASS_SUFFIX());
    }

    public static boolean isLocalDummyName(StdNames$nme$ $this, Names.Name name) {
        return name.startsWith($this.LOCALDUMMY_PREFIX());
    }

    public static boolean isLocalName(StdNames$nme$ $this, Names.Name name) {
        return name.endsWith($this.LOCAL_SUFFIX_STRING());
    }

    public static boolean isLoopHeaderLabel(StdNames$nme$ $this, Names.Name name) {
        return name.startsWith($this.WHILE_PREFIX()) || name.startsWith($this.DO_WHILE_PREFIX());
    }

    public static boolean isProtectedAccessorName(StdNames$nme$ $this, Names.Name name) {
        return name.startsWith($this.PROTECTED_PREFIX());
    }

    public static boolean isReplWrapperName(StdNames$nme$ $this, Names.Name name) {
        return name.containsName($this.INTERPRETER_IMPORT_WRAPPER());
    }

    public static boolean isSetterName(StdNames$nme$ $this, Names.Name name) {
        return name.endsWith($this.SETTER_SUFFIX());
    }

    public static boolean isTraitSetterName(StdNames$nme$ $this, Names.Name name) {
        return $this.isSetterName(name) && name.containsName($this.TRAIT_SETTER_SEPARATOR_STRING());
    }

    public static boolean isSingletonName(StdNames$nme$ $this, Names.Name name) {
        return name.endsWith($this.SINGLETON_SUFFIX());
    }

    public static boolean isModuleName(StdNames$nme$ $this, Names.Name name) {
        return name.endsWith($this.MODULE_SUFFIX_STRING());
    }

    public static boolean isOpAssignmentName(StdNames$nme$ $this, Names.Name name) {
        boolean bl;
        Names.Name name2;
        Names.Name name3 = name2 = name;
        Names.Name name4 = $this.raw().NE();
        if (!(name3 != null ? !name3.equals(name4) : name4 != null)) {
            bl = false;
        } else {
            Names.Name name5 = name2;
            Names.Name name6 = $this.raw().LE();
            if (!(name5 != null ? !name5.equals(name6) : name6 != null)) {
                bl = false;
            } else {
                Names.Name name7 = name2;
                Names.Name name8 = $this.raw().GE();
                if (!(name7 != null ? !name7.equals(name8) : name8 != null)) {
                    bl = false;
                } else {
                    Names.Name name9 = name2;
                    Names.Name name10 = $this.EMPTY();
                    bl = !(name9 != null ? !name9.equals(name10) : name10 != null) ? false : name.endChar() == '=' && name.startChar() != '=' && Chars$.MODULE$.isOperatorPart(name.startChar());
                }
            }
        }
        return bl;
    }

    public static Names.Name originalName(StdNames$nme$ $this, Names.Name name) {
        Names.Name name2;
        int i;
        for (i = name.length(); i >= 2 && (name.apply(i - 1) != '$' || name.apply(i - 2) != '$'); --i) {
        }
        if (i >= 2) {
            while (i >= 3 && name.apply(i - 3) == '$') {
                --i;
            }
            name2 = name.subName(i, name.length());
        } else {
            name2 = name;
        }
        return name2;
    }

    public static Tuple3 splitSpecializedName(StdNames$nme$ $this, Names.Name name) {
        Tuple3 tuple3;
        if (name.endsWith("$sp")) {
            Names.Name name1 = name.stripEnd("$sp");
            int idxC = name1.lastIndexOf('c');
            int idxM = name1.lastIndexOf('m');
            tuple3 = new Tuple3((Object)name1.subName(0, idxM - 1), (Object)name1.subName(idxC + 1, name1.length()).toString(), (Object)name1.subName(idxM + 1, idxC).toString());
        } else {
            tuple3 = new Tuple3((Object)name, (Object)"", (Object)"");
        }
        return tuple3;
    }

    public static Names.TermName getterName(StdNames$nme$ $this, Names.TermName name) {
        return $this.isLocalName(name) ? $this.localToGetter(name) : name;
    }

    public static Names.TermName getterToLocal(StdNames$nme$ $this, Names.TermName name) {
        return name.toTermName().append($this.LOCAL_SUFFIX_STRING());
    }

    public static Names.TermName getterToSetter(StdNames$nme$ $this, Names.TermName name) {
        return name.toTermName().append($this.SETTER_SUFFIX());
    }

    public static Names.TermName localToGetter(StdNames$nme$ $this, Names.TermName name) {
        return name.stripEnd($this.LOCAL_SUFFIX_STRING()).toTermName();
    }

    public static Names.TermName setterToGetter(StdNames$nme$ $this, Names.TermName name) {
        int p = name.pos($this.TRAIT_SETTER_SEPARATOR_STRING());
        return p < name.length() ? $this.setterToGetter(name.subName(p + $this.TRAIT_SETTER_SEPARATOR_STRING().length(), name.length())) : name.stripEnd($this.SETTER_SUFFIX()).toTermName();
    }

    public static Names.TermName defaultGetterName(StdNames$nme$ $this, Names.Name name, int pos) {
        Object prefix = $this.isConstructorName(name) ? "init" : name;
        return ((Names)((Object)$this.treehugger$NameManglers$TermNameMangling$$$outer())).newTermName(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(prefix).$plus($this.DEFAULT_GETTER_STRING())).append((Object)BoxesRunTime.boxToInteger((int)pos)).toString());
    }

    public static Names.TermName defaultGetterToMethod(StdNames$nme$ $this, Names.Name name) {
        int p = name.pos($this.DEFAULT_GETTER_STRING());
        return p < name.length() ? ((Names)((Object)$this.treehugger$NameManglers$TermNameMangling$$$outer())).promoteTermNamesAsNecessary(name.subName(0, p)) : ((Names)((Object)$this.treehugger$NameManglers$TermNameMangling$$$outer())).promoteTermNamesAsNecessary(name);
    }

    public static Names.Name stripAnonNumberSuffix(StdNames$nme$ $this, Names.Name name) {
        int idx;
        String str;
        String string = str = new StringBuilder().append((Object)"").append((Object)name).toString();
        String string2 = "";
        return (string == null ? string2 != null : !string.equals(string2)) && Predef$.MODULE$.charWrapper(((StdNames)$this.treehugger$NameManglers$TermNameMangling$$$outer()).stringToTermName(str).endChar()).isDigit() ? ((idx = name.lastPos('$')) < 0 || Predef$.MODULE$.augmentString(str.substring(idx + 1)).exists((Function1)new NameManglers$TermNameMangling$.anonfun.stripAnonNumberSuffix.1($this)) ? name : name.subName(0, idx)) : name;
    }

    public static Names.Name stripModuleSuffix(StdNames$nme$ $this, Names.Name name) {
        return $this.isModuleName(name) ? name.stripEnd($this.MODULE_SUFFIX_STRING()) : name;
    }

    public static Names.TypeName dropSingletonName(StdNames$nme$ $this, Names.Name name) {
        return name.stripEnd($this.SINGLETON_SUFFIX()).toTypeName();
    }

    public static Names.TypeName singletonName(StdNames$nme$ $this, Names.Name name) {
        return name.append($this.SINGLETON_SUFFIX()).toTypeName();
    }

    public static Names.TypeName implClassName(StdNames$nme$ $this, Names.Name name) {
        return name.append($this.IMPL_CLASS_SUFFIX()).toTypeName();
    }

    public static Names.TypeName interfaceName(StdNames$nme$ $this, Names.Name implname) {
        return implname.stripEnd($this.IMPL_CLASS_SUFFIX()).toTypeName();
    }

    public static Names.TermName localDummyName(StdNames$nme$ $this, Symbols.Symbol clazz) {
        return ((Names)((Object)$this.treehugger$NameManglers$TermNameMangling$$$outer())).newTermName(new StringBuilder().append((Object)$this.LOCALDUMMY_PREFIX()).append((Object)clazz.name()).append((Object)">").toString());
    }

    public static Names.TermName productAccessorName(StdNames$nme$ $this, int i) {
        return ((Names)((Object)$this.treehugger$NameManglers$TermNameMangling$$$outer())).newTermName(new StringBuilder().append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
    }

    public static Names.TermName superName(StdNames$nme$ $this, Names.Name name) {
        return ((Names)((Object)$this.treehugger$NameManglers$TermNameMangling$$$outer())).newTermName(new StringBuilder().append((Object)$this.SUPER_PREFIX_STRING()).append((Object)name).toString());
    }

    public static Names.TermName protName(StdNames$nme$ $this, Names.Name name) {
        return ((Names)((Object)$this.treehugger$NameManglers$TermNameMangling$$$outer())).newTermName(new StringBuilder().append((Object)$this.PROTECTED_PREFIX()).append((Object)name).toString());
    }

    public static Names.TermName protSetterName(StdNames$nme$ $this, Names.Name name) {
        return ((Names)((Object)$this.treehugger$NameManglers$TermNameMangling$$$outer())).newTermName(new StringBuilder().append((Object)$this.PROTECTED_SET_PREFIX()).append((Object)name).toString());
    }

    public static void $init$(StdNames$nme$ $this) {
        $this.treehugger$NameManglers$TermNameMangling$_setter_$IMPL_CLASS_SUFFIX_$eq("$class");
        $this.treehugger$NameManglers$TermNameMangling$_setter_$LOCALDUMMY_PREFIX_$eq("<local ");
        $this.treehugger$NameManglers$TermNameMangling$_setter_$PROTECTED_PREFIX_$eq("protected$");
        $this.treehugger$NameManglers$TermNameMangling$_setter_$PROTECTED_SET_PREFIX_$eq(new StringBuilder().append((Object)$this.PROTECTED_PREFIX()).append((Object)"set").toString());
        $this.treehugger$NameManglers$TermNameMangling$_setter_$SETTER_SUFFIX_$eq(((StdNames)$this.treehugger$NameManglers$TermNameMangling$$$outer()).encode("_="));
        $this.treehugger$NameManglers$TermNameMangling$_setter_$SINGLETON_SUFFIX_$eq(".type");
        $this.treehugger$NameManglers$TermNameMangling$_setter_$SUPER_PREFIX_STRING_$eq("super$");
        $this.treehugger$NameManglers$TermNameMangling$_setter_$TRAIT_SETTER_SEPARATOR_STRING_$eq("$_setter_$");
    }
}

